/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.legacy;

import java.util.HashMap;
import java.util.HashSet;

public class LegacyRegister {
    private static final HashMap registers = LegacyRegister.initializeRegisterMap();
    public static final LegacyRegister R0 = LegacyRegister.getRegisterByNumber(0);
    public static final LegacyRegister R1 = LegacyRegister.getRegisterByNumber(1);
    public static final LegacyRegister R2 = LegacyRegister.getRegisterByNumber(2);
    public static final LegacyRegister R3 = LegacyRegister.getRegisterByNumber(3);
    public static final LegacyRegister R4 = LegacyRegister.getRegisterByNumber(4);
    public static final LegacyRegister R5 = LegacyRegister.getRegisterByNumber(5);
    public static final LegacyRegister R6 = LegacyRegister.getRegisterByNumber(6);
    public static final LegacyRegister R7 = LegacyRegister.getRegisterByNumber(7);
    public static final LegacyRegister R8 = LegacyRegister.getRegisterByNumber(8);
    public static final LegacyRegister R9 = LegacyRegister.getRegisterByNumber(9);
    public static final LegacyRegister R10 = LegacyRegister.getRegisterByNumber(10);
    public static final LegacyRegister R11 = LegacyRegister.getRegisterByNumber(11);
    public static final LegacyRegister R12 = LegacyRegister.getRegisterByNumber(12);
    public static final LegacyRegister R13 = LegacyRegister.getRegisterByNumber(13);
    public static final LegacyRegister R14 = LegacyRegister.getRegisterByNumber(14);
    public static final LegacyRegister R15 = LegacyRegister.getRegisterByNumber(15);
    public static final LegacyRegister R16 = LegacyRegister.getRegisterByNumber(16);
    public static final LegacyRegister R17 = LegacyRegister.getRegisterByNumber(17);
    public static final LegacyRegister R18 = LegacyRegister.getRegisterByNumber(18);
    public static final LegacyRegister R19 = LegacyRegister.getRegisterByNumber(19);
    public static final LegacyRegister R20 = LegacyRegister.getRegisterByNumber(20);
    public static final LegacyRegister R21 = LegacyRegister.getRegisterByNumber(21);
    public static final LegacyRegister R22 = LegacyRegister.getRegisterByNumber(22);
    public static final LegacyRegister R23 = LegacyRegister.getRegisterByNumber(23);
    public static final LegacyRegister R24 = LegacyRegister.getRegisterByNumber(24);
    public static final LegacyRegister R25 = LegacyRegister.getRegisterByNumber(25);
    public static final LegacyRegister R26 = LegacyRegister.getRegisterByNumber(26);
    public static final LegacyRegister R27 = LegacyRegister.getRegisterByNumber(27);
    public static final LegacyRegister R28 = LegacyRegister.getRegisterByNumber(28);
    public static final LegacyRegister R29 = LegacyRegister.getRegisterByNumber(29);
    public static final LegacyRegister R30 = LegacyRegister.getRegisterByNumber(30);
    public static final LegacyRegister R31 = LegacyRegister.getRegisterByNumber(31);
    public static final LegacyRegister X = LegacyRegister.getRegisterByName("x");
    public static final LegacyRegister Y = LegacyRegister.getRegisterByName("y");
    public static final LegacyRegister Z = LegacyRegister.getRegisterByName("z");
    private static final LegacyRegister[] REGS_0_31 = new LegacyRegister[]{R0, R1, R2, R3, R4, R5, R6, R7, R8, R9, R10, R11, R12, R13, R14, R15, R16, R17, R18, R19, R20, R21, R22, R23, R24, R25, R26, R27, R28, R29, R30, R31};
    private static final LegacyRegister[] EREGS = new LegacyRegister[]{R0, R2, R4, R6, R8, R10, R12, R14, R16, R18, R20, R22, R24, R26, R28, R30};
    private static final LegacyRegister[] REGS_16_31 = new LegacyRegister[]{R16, R17, R18, R19, R20, R21, R22, R23, R24, R25, R26, R27, R28, R29, R30, R31};
    private static final LegacyRegister[] REGS_16_23 = new LegacyRegister[]{R16, R17, R18, R19, R20, R21, R22, R23};
    private static final LegacyRegister[] REGS_XYZ = new LegacyRegister[]{X, Y, Z};
    private static final LegacyRegister[] REGS_YZ = new LegacyRegister[]{Y, Z};
    private static final LegacyRegister[] REGS_Z = new LegacyRegister[]{Z};
    private static final LegacyRegister[] REGS_RDL = new LegacyRegister[]{R24, R26, R28, R30};
    public static final Set GPR_set = new Set(REGS_0_31);
    public static final Set HGPR_set = new Set(REGS_16_31);
    public static final Set MGPR_set = new Set(REGS_16_23);
    public static final Set EGPR_set = new Set(EREGS);
    public static final Set ADR_set = new Set(REGS_XYZ);
    public static final Set RDL_set = new Set(REGS_RDL);
    public static final Set YZ_set = new Set(REGS_YZ);
    public static final Set Z_set = new Set(REGS_Z);
    private final String name;
    private final int number;
    private final int width;

    private static HashMap initializeRegisterMap() {
        HashMap<String, LegacyRegister> map = new HashMap<String, LegacyRegister>();
        for (int cntr = 0; cntr < 32; ++cntr) {
            LegacyRegister reg = new LegacyRegister("r" + cntr, cntr, 8);
            map.put("r" + cntr, reg);
            map.put("R" + cntr, reg);
        }
        LegacyRegister reg = new LegacyRegister("X", 26, 16);
        map.put("x", reg);
        map.put("X", reg);
        reg = new LegacyRegister("Y", 28, 16);
        map.put("y", reg);
        map.put("Y", reg);
        reg = new LegacyRegister("Z", 30, 16);
        map.put("z", reg);
        map.put("Z", reg);
        return map;
    }

    public static LegacyRegister getRegisterByName(String name) {
        return (LegacyRegister)registers.get(name);
    }

    public static LegacyRegister getRegisterByNumber(int num) {
        return LegacyRegister.getRegisterByName("r" + num);
    }

    private LegacyRegister(String nm, int num, int w) {
        this.name = nm;
        this.number = num;
        this.width = w;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public int getWidth() {
        return this.width;
    }

    public LegacyRegister nextRegister() {
        return REGS_0_31[this.number + 1];
    }

    public static class Set {
        public final String contents;
        private final HashSet registerSet;

        Set(LegacyRegister[] regs) {
            this.registerSet = new HashSet(2 * regs.length);
            for (int cntr = 0; cntr < regs.length; ++cntr) {
                this.registerSet.add(regs[cntr]);
            }
            StringBuffer buf = new StringBuffer("{");
            for (int cntr = 0; cntr < regs.length; ++cntr) {
                this.registerSet.add(regs[cntr]);
                if (cntr == 2 && regs.length > 4) {
                    buf.append("..., ");
                }
                if (cntr >= 2 && cntr != regs.length - 1 && regs.length >= 5) continue;
                buf.append(regs[cntr]);
                if (cntr >= regs.length - 1) continue;
                buf.append(", ");
            }
            buf.append('}');
            this.contents = buf.toString();
        }

        public boolean contains(LegacyRegister reg) {
            return this.registerSet.contains(reg);
        }

        public String toString() {
            return this.contents;
        }
    }
}

