/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.legacy;

import avrora.arch.avr.AVRProperties;
import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.arch.legacy.LegacyRegister;
import avrora.core.Program;
import avrora.sim.AtmelInterpreter;
import avrora.sim.Interpreter;
import avrora.sim.InterpreterFactory;
import avrora.sim.Simulator;
import avrora.sim.mcu.MCUProperties;
import cck.util.Arithmetic;

public class LegacyInterpreter
extends AtmelInterpreter
implements LegacyInstrVisitor {
    public static final Factory FACTORY = new Factory();
    public static final LegacyRegister R0 = LegacyRegister.R0;
    public static final LegacyRegister R1 = LegacyRegister.R1;
    public static final LegacyRegister RZ = LegacyRegister.Z;

    protected LegacyInterpreter(Simulator s, Program p, AVRProperties pr) {
        super(s, p, pr);
        Compiler.compileClass(this.getClass());
    }

    protected void runLoop() {
        this.nextPC = this.pc = this.bootPC;
        this.cyclesConsumed = 0;
        while (this.shouldRun) {
            long pendingInterrupts;
            if (this.delayCycles > 0L) {
                this.advanceClock(this.delayCycles);
                this.delayCycles = 0L;
            }
            if (this.justReturnedFromInterrupt) {
                this.justReturnedFromInterrupt = false;
            } else if (this.I && (pendingInterrupts = this.interrupts.getPendingInterrupts()) != 0L) {
                this.invokeInterrupt(pendingInterrupts);
            }
            if (this.sleeping) {
                this.sleepLoop();
                continue;
            }
            if (this.globalProbe.isEmpty()) {
                this.fastLoop();
                continue;
            }
            this.instrumentedLoop();
        }
    }

    public int step() {
        long pendingInterrupts;
        this.nextPC = this.pc;
        if (this.delayCycles > 0L) {
            this.advanceClock(1L);
            --this.delayCycles;
            return 1;
        }
        if (this.justReturnedFromInterrupt) {
            this.justReturnedFromInterrupt = false;
        } else if (this.I && (pendingInterrupts = this.interrupts.getPendingInterrupts()) != 0L) {
            return this.stepInterrupt(pendingInterrupts);
        }
        if (this.sleeping) {
            this.advanceClock(1L);
            return 1;
        }
        return this.stepInstruction();
    }

    private int stepInstruction() {
        int cycles;
        if (this.globalProbe.isEmpty()) {
            LegacyInstr i = this.shared_instr[this.nextPC];
            i.accept(this);
            cycles = this.cyclesConsumed;
            this.commit();
        } else {
            int curPC = this.nextPC;
            LegacyInstr i = this.shared_instr[this.nextPC];
            this.globalProbe.fireBefore(this.state, curPC);
            i.accept(this);
            cycles = this.cyclesConsumed;
            this.commit();
            this.globalProbe.fireAfter(this.state, curPC);
        }
        return cycles;
    }

    private int stepInterrupt(long pendingInterrupts) {
        int inum = Arithmetic.lowestBit(pendingInterrupts);
        this.interrupts.beforeInvoke(inum);
        this.pushPC(this.nextPC);
        this.pc = this.nextPC = this.getInterruptVectorAddress(inum);
        this.I = false;
        this.advanceClock(1L);
        int cycles = 3;
        if (this.sleeping) {
            cycles += this.simulator.getMicrocontroller().wakeup();
            this.sleeping = false;
            this.innerLoop = false;
        }
        this.delay(cycles);
        return 1;
    }

    private void invokeInterrupt(long pendingInterrupts) {
        int lowestbit = Arithmetic.lowestBit(pendingInterrupts);
        this.interrupts.beforeInvoke(lowestbit);
        if (this.sleeping) {
            this.leaveSleepMode();
        }
        this.pushPC(this.nextPC);
        this.pc = this.nextPC = this.getInterruptVectorAddress(lowestbit);
        this.I = false;
        this.advanceClock(4L);
        this.interrupts.afterInvoke(lowestbit);
    }

    private void sleepLoop() {
        this.innerLoop = true;
        while (this.innerLoop) {
            this.clock.skipAhead();
        }
    }

    private void fastLoop() {
        this.innerLoop = true;
        while (this.innerLoop) {
            try {
                LegacyInstr i = this.shared_instr[this.nextPC];
                i.accept(this);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("Caught ArrayIndexOutOfBoundsException: " + e.getMessage());
                this.nextPC = 6682;
            }
            this.commit();
        }
    }

    private void instrumentedLoop() {
        this.innerLoop = true;
        while (this.innerLoop) {
            int curPC = this.nextPC;
            LegacyInstr i = this.shared_instr[this.nextPC];
            this.globalProbe.fireBefore(this.state, curPC);
            i.accept(this);
            this.commit();
            this.globalProbe.fireAfter(this.state, curPC);
        }
    }

    public void visit(LegacyInstr.ADC i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1);
        int tmp_1 = this.getRegisterUnsigned(i.r2);
        byte tmp_2 = LegacyInterpreter.bit(this.C);
        int tmp_3 = tmp_0 + tmp_1 + tmp_2;
        int tmp_4 = tmp_0 & 0xF;
        int tmp_5 = tmp_1 & 0xF;
        boolean tmp_6 = (tmp_0 & 0x80) != 0;
        boolean tmp_7 = (tmp_1 & 0x80) != 0;
        boolean tmp_8 = (tmp_3 & 0x80) != 0;
        this.H = (tmp_4 + tmp_5 + tmp_2 & 0x10) != 0;
        this.C = (tmp_3 & 0x100) != 0;
        this.N = (tmp_3 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = tmp_6 && tmp_7 && !tmp_8 || !tmp_6 && !tmp_7 && tmp_8;
        this.S = this.N != this.V;
        byte tmp_9 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_9);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.ADD i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1);
        int tmp_1 = this.getRegisterUnsigned(i.r2);
        int tmp_2 = 0;
        int tmp_3 = tmp_0 + tmp_1 + tmp_2;
        int tmp_4 = tmp_0 & 0xF;
        int tmp_5 = tmp_1 & 0xF;
        boolean tmp_6 = (tmp_0 & 0x80) != 0;
        boolean tmp_7 = (tmp_1 & 0x80) != 0;
        boolean tmp_8 = (tmp_3 & 0x80) != 0;
        this.H = (tmp_4 + tmp_5 + tmp_2 & 0x10) != 0;
        this.C = (tmp_3 & 0x100) != 0;
        this.N = (tmp_3 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = tmp_6 && tmp_7 && !tmp_8 || !tmp_6 && !tmp_7 && tmp_8;
        this.S = this.N != this.V;
        byte tmp_9 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_9);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.ADIW i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterWord(i.r1);
        int tmp_1 = tmp_0 + i.imm1;
        boolean tmp_2 = (tmp_1 & 0x8000) != 0;
        boolean tmp_3 = (tmp_0 & 0x8000) != 0;
        this.C = !tmp_2 && tmp_3;
        this.N = tmp_2;
        this.V = !tmp_3 && tmp_2;
        this.Z = (tmp_1 & 0xFFFF) == 0;
        this.S = this.N != this.V;
        this.writeRegisterWord(i.r1, tmp_1);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.AND i) {
        byte tmp_1;
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_2 = tmp_0 & (tmp_1 = this.getRegisterByte(i.r2));
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = false;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.ANDI i) {
        int tmp_1;
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_2 = tmp_0 & (tmp_1 = i.imm1);
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = false;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.ASR i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        boolean tmp_2 = (tmp_0 & 0x80) != 0;
        int tmp_3 = (tmp_0 & 0xFF) >> 1;
        tmp_3 = Arithmetic.setBit(tmp_3, 7, tmp_2);
        this.C = (tmp_0 & 1) != 0;
        this.N = tmp_2;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = this.N != this.C;
        this.S = this.N != this.V;
        byte tmp_4 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_4);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.BCLR i) {
        this.nextPC = this.pc + 2;
        this.setFlag(i.imm1, false);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.BLD i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, Arithmetic.setBit(this.getRegisterByte(i.r1), i.imm1, this.T));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.BRBC i) {
        int npc = this.pc + 2;
        if (!this.getFlag(i.imm1)) {
            this.nextPC = i.imm2 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRBS i) {
        int npc = this.pc + 2;
        if (this.getFlag(i.imm1)) {
            this.nextPC = i.imm2 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRCC i) {
        int npc = this.pc + 2;
        if (!this.C) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRCS i) {
        int npc = this.pc + 2;
        if (this.C) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BREAK i) {
        this.nextPC = this.pc + 2;
        this.stop();
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.BREQ i) {
        int npc = this.pc + 2;
        if (this.Z) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRGE i) {
        int npc = this.pc + 2;
        if (!this.S) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRHC i) {
        int npc = this.pc + 2;
        if (!this.H) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRHS i) {
        int npc = this.pc + 2;
        if (this.H) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRID i) {
        int npc = this.pc + 2;
        if (!this.I) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRIE i) {
        int npc = this.pc + 2;
        if (this.I) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRLO i) {
        int npc = this.pc + 2;
        if (this.C) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRLT i) {
        int npc = this.pc + 2;
        if (this.S) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRMI i) {
        int npc = this.pc + 2;
        if (this.N) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRNE i) {
        int npc = this.pc + 2;
        if (!this.Z) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRPL i) {
        int npc = this.pc + 2;
        if (!this.N) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRSH i) {
        int npc = this.pc + 2;
        if (!this.C) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRTC i) {
        int npc = this.pc + 2;
        if (!this.T) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRTS i) {
        int npc = this.pc + 2;
        if (this.T) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRVC i) {
        int npc = this.pc + 2;
        if (!this.V) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BRVS i) {
        int npc = this.pc + 2;
        if (this.V) {
            this.nextPC = i.imm1 * 2 + npc;
            this.cyclesConsumed += 2;
        } else {
            this.nextPC = npc;
            ++this.cyclesConsumed;
        }
    }

    public void visit(LegacyInstr.BSET i) {
        this.nextPC = this.pc + 2;
        this.setFlag(i.imm1, true);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.BST i) {
        this.nextPC = this.pc + 2;
        this.T = Arithmetic.getBit(this.getRegisterByte(i.r1), i.imm1);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CALL i) {
        int tmp_0 = (this.pc + 4) / 2;
        this.pushByte(LegacyInterpreter.low(tmp_0));
        this.pushByte(LegacyInterpreter.high(tmp_0));
        this.nextPC = i.imm1 * 2;
        this.cyclesConsumed += 4;
    }

    public void visit(LegacyInstr.CBI i) {
        this.nextPC = this.pc + 2;
        this.setIORegBit(i.imm1, i.imm2, false);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.CBR i) {
        int tmp_1;
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_2 = tmp_0 & (tmp_1 = ~i.imm1);
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = false;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLC i) {
        this.nextPC = this.pc + 2;
        this.C = false;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLH i) {
        this.nextPC = this.pc + 2;
        this.H = false;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLI i) {
        this.nextPC = this.pc + 2;
        this.disableInterrupts();
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLN i) {
        this.nextPC = this.pc + 2;
        this.N = false;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLR i) {
        this.nextPC = this.pc + 2;
        this.S = false;
        this.V = false;
        this.N = false;
        this.Z = true;
        this.writeRegisterByte(i.r1, LegacyInterpreter.low(0));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLS i) {
        this.nextPC = this.pc + 2;
        this.S = false;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLT i) {
        this.nextPC = this.pc + 2;
        this.T = false;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLV i) {
        this.nextPC = this.pc + 2;
        this.V = false;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CLZ i) {
        this.nextPC = this.pc + 2;
        this.Z = false;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.COM i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = 255 - this.getRegisterByte(i.r1);
        this.C = true;
        this.N = (tmp_0 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_0) == 0;
        this.V = false;
        this.S = this.N != this.V;
        this.writeRegisterByte(i.r1, LegacyInterpreter.low(tmp_0));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CP i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        byte tmp_1 = this.getRegisterByte(i.r2);
        int tmp_2 = 0;
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CPC i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        byte tmp_1 = this.getRegisterByte(i.r2);
        byte tmp_2 = LegacyInterpreter.bit(this.C);
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0 && this.Z;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CPI i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_1 = i.imm1;
        int tmp_2 = 0;
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.CPSE i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        byte tmp_1 = this.getRegisterByte(i.r2);
        int tmp_4 = 0;
        int tmp_5 = tmp_0 - tmp_1 - tmp_4;
        boolean tmp_6 = (tmp_0 & 0x80) != 0;
        boolean tmp_7 = (tmp_1 & 0x80) != 0;
        boolean tmp_8 = (tmp_5 & 0x80) != 0;
        boolean tmp_9 = (tmp_0 & 8) != 0;
        boolean tmp_10 = (tmp_1 & 8) != 0;
        boolean tmp_11 = (tmp_5 & 8) != 0;
        this.H = !tmp_9 && tmp_10 || tmp_10 && tmp_11 || tmp_11 && !tmp_9;
        this.C = !tmp_6 && tmp_7 || tmp_7 && tmp_8 || tmp_8 && !tmp_6;
        this.N = tmp_8;
        this.Z = LegacyInterpreter.low(tmp_5) == 0;
        this.V = tmp_6 && !tmp_7 && !tmp_8 || !tmp_6 && tmp_7 && tmp_8;
        boolean bl = this.S = this.N != this.V;
        if (tmp_0 == tmp_1) {
            int tmp_13 = this.getInstrSize(this.nextPC);
            this.nextPC += tmp_13;
            this.cyclesConsumed = tmp_13 == 4 ? (this.cyclesConsumed += 2) : ++this.cyclesConsumed;
        }
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.DEC i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1);
        byte tmp_1 = LegacyInterpreter.low(tmp_0 - 1);
        this.N = (tmp_1 & 0x80) != 0;
        this.Z = tmp_1 == 0;
        this.V = tmp_0 == 128;
        this.S = this.N != this.V;
        this.writeRegisterByte(i.r1, tmp_1);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.EICALL i) {
        this.nextPC = this.pc + 2;
        this.cyclesConsumed += 4;
    }

    public void visit(LegacyInstr.EIJMP i) {
        this.nextPC = this.pc + 2;
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.ELPM i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.extended(this.getRegisterWord(RZ));
        this.writeRegisterByte(R0, this.getFlashByte(tmp_0));
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.ELPMD i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.extended(this.getRegisterWord(RZ));
        this.writeRegisterByte(i.r1, this.getFlashByte(tmp_0));
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.ELPMPI i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.extended(this.getRegisterWord(RZ));
        this.writeRegisterByte(i.r1, this.getFlashByte(tmp_0));
        this.writeRegisterWord(RZ, tmp_0 + 1);
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.EOR i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = LegacyInterpreter.low(this.getRegisterByte(i.r1) ^ this.getRegisterByte(i.r2));
        this.N = (tmp_0 & 0x80) != 0;
        this.Z = tmp_0 == 0;
        this.V = false;
        this.S = this.N != this.V;
        this.writeRegisterByte(i.r1, tmp_0);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.FMUL i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1) * this.getRegisterUnsigned(i.r2) << 1;
        this.Z = (tmp_0 & 0xFFFF) == 0;
        this.C = (tmp_0 & 0x10000) != 0;
        this.writeRegisterByte(R0, LegacyInterpreter.low(tmp_0));
        this.writeRegisterByte(R1, LegacyInterpreter.high(tmp_0));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.FMULS i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterByte(i.r1) * this.getRegisterByte(i.r2) << 1;
        this.Z = (tmp_0 & 0xFFFF) == 0;
        this.C = (tmp_0 & 0x10000) != 0;
        this.writeRegisterByte(R0, LegacyInterpreter.low(tmp_0));
        this.writeRegisterByte(R1, LegacyInterpreter.high(tmp_0));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.FMULSU i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterByte(i.r1) * this.getRegisterUnsigned(i.r2) << 1;
        this.Z = (tmp_0 & 0xFFFF) == 0;
        this.C = (tmp_0 & 0x10000) != 0;
        this.writeRegisterByte(R0, LegacyInterpreter.low(tmp_0));
        this.writeRegisterByte(R1, LegacyInterpreter.high(tmp_0));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.ICALL i) {
        int tmp_0 = (this.pc + 2) / 2;
        this.pushByte(LegacyInterpreter.low(tmp_0));
        this.pushByte(LegacyInterpreter.high(tmp_0));
        this.nextPC = this.getRegisterWord(RZ) * 2;
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.IJMP i) {
        this.nextPC = this.getRegisterWord(RZ) * 2;
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.IN i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, this.getIORegisterByte(i.imm1));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.INC i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1);
        byte tmp_1 = LegacyInterpreter.low(tmp_0 + 1);
        this.N = (tmp_1 & 0x80) != 0;
        this.Z = tmp_1 == 0;
        this.V = tmp_0 == 127;
        this.S = this.N != this.V;
        this.writeRegisterByte(i.r1, tmp_1);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.JMP i) {
        this.nextPC = i.imm1 * 2;
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.LD i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, this.getDataByte(this.getRegisterWord(i.r2)));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.LDD i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, this.getDataByte(this.getRegisterWord(i.r2) + i.imm1));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.LDI i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, LegacyInterpreter.low(i.imm1));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.LDPD i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterWord(i.r2) - 1;
        this.writeRegisterByte(i.r1, this.getDataByte(tmp_0));
        this.writeRegisterWord(i.r2, tmp_0);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.LDPI i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterWord(i.r2);
        this.writeRegisterByte(i.r1, this.getDataByte(tmp_0));
        this.writeRegisterWord(i.r2, tmp_0 + 1);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.LDS i) {
        this.nextPC = this.pc + 4;
        this.writeRegisterByte(i.r1, this.getDataByte(i.imm1));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.LPM i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(R0, this.getFlashByte(this.getRegisterWord(RZ)));
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.LPMD i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, this.getFlashByte(this.getRegisterWord(RZ)));
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.LPMPI i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterWord(RZ);
        this.writeRegisterByte(i.r1, this.getFlashByte(tmp_0));
        this.writeRegisterWord(RZ, tmp_0 + 1);
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.LSL i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        boolean tmp_1 = false;
        int tmp_2 = tmp_0 << 1;
        this.H = ((tmp_2 = Arithmetic.setBit(tmp_2, 0, tmp_1)) & 0x10) != 0;
        this.C = (tmp_2 & 0x100) != 0;
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = this.N != this.C;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.LSR i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        boolean tmp_1 = false;
        int tmp_2 = (tmp_0 & 0xFF) >> 1;
        tmp_2 = Arithmetic.setBit(tmp_2, 7, tmp_1);
        this.C = (tmp_0 & 1) != 0;
        this.N = tmp_1;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = this.N != this.C;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.MOV i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, this.getRegisterByte(i.r2));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.MOVW i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterWord(i.r1, this.getRegisterWord(i.r2));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.MUL i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1) * this.getRegisterUnsigned(i.r2);
        this.C = (tmp_0 & 0x8000) != 0;
        this.Z = (tmp_0 & 0xFFFF) == 0;
        this.writeRegisterWord(R0, tmp_0);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.MULS i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterByte(i.r1) * this.getRegisterByte(i.r2);
        this.C = (tmp_0 & 0x8000) != 0;
        this.Z = (tmp_0 & 0xFFFF) == 0;
        this.writeRegisterWord(R0, tmp_0);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.MULSU i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterByte(i.r1) * this.getRegisterUnsigned(i.r2);
        this.C = (tmp_0 & 0x8000) != 0;
        this.Z = (tmp_0 & 0xFFFF) == 0;
        this.writeRegisterWord(R0, tmp_0);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.NEG i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = 0;
        byte tmp_1 = this.getRegisterByte(i.r1);
        int tmp_2 = 0;
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        byte tmp_10 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_10);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.NOP i) {
        this.nextPC = this.pc + 2;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.OR i) {
        byte tmp_1;
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_2 = tmp_0 | (tmp_1 = this.getRegisterByte(i.r2));
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = false;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.ORI i) {
        int tmp_1;
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_2 = tmp_0 | (tmp_1 = i.imm1);
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = false;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.OUT i) {
        this.nextPC = this.pc + 2;
        this.writeIORegisterByte(i.imm1, this.getRegisterByte(i.r1));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.POP i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, this.popByte());
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.PUSH i) {
        this.nextPC = this.pc + 2;
        this.pushByte(this.getRegisterByte(i.r1));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.RCALL i) {
        int tmp_0 = (this.pc + 2) / 2;
        this.pushByte(LegacyInterpreter.low(tmp_0));
        this.pushByte(LegacyInterpreter.high(tmp_0));
        this.nextPC = (i.imm1 + tmp_0) * 2;
        this.cyclesConsumed += 3;
    }

    public void visit(LegacyInstr.RET i) {
        byte tmp_0 = this.popByte();
        byte tmp_1 = this.popByte();
        this.nextPC = LegacyInterpreter.uword(tmp_1, tmp_0) * 2;
        this.cyclesConsumed += 4;
    }

    public void visit(LegacyInstr.RETI i) {
        byte tmp_0 = this.popByte();
        byte tmp_1 = this.popByte();
        this.nextPC = LegacyInterpreter.uword(tmp_1, tmp_0) * 2;
        this.enableInterrupts();
        this.justReturnedFromInterrupt = true;
        this.cyclesConsumed += 4;
    }

    public void visit(LegacyInstr.RJMP i) {
        this.nextPC = i.imm1 * 2 + this.pc + 2;
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.ROL i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1);
        boolean tmp_1 = this.C;
        int tmp_2 = tmp_0 << 1;
        this.H = ((tmp_2 = Arithmetic.setBit(tmp_2, 0, tmp_1)) & 0x10) != 0;
        this.C = (tmp_2 & 0x100) != 0;
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = this.N != this.C;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.ROR i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        boolean tmp_1 = this.C;
        int tmp_2 = (tmp_0 & 0xFF) >> 1;
        tmp_2 = Arithmetic.setBit(tmp_2, 7, tmp_1);
        this.C = (tmp_0 & 1) != 0;
        this.N = tmp_1;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = this.N != this.C;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SBC i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        byte tmp_1 = this.getRegisterByte(i.r2);
        byte tmp_2 = LegacyInterpreter.bit(this.C);
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0 && this.Z;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        byte tmp_10 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_10);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SBCI i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_1 = i.imm1;
        byte tmp_2 = LegacyInterpreter.bit(this.C);
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0 && this.Z;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        byte tmp_10 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_10);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SBI i) {
        this.nextPC = this.pc + 2;
        this.setIORegBit(i.imm1, i.imm2, true);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.SBIC i) {
        this.nextPC = this.pc + 2;
        if (!this.getIORegBit(i.imm1, i.imm2)) {
            int tmp_0 = this.getInstrSize(this.nextPC);
            this.nextPC += tmp_0;
            this.cyclesConsumed = tmp_0 == 4 ? (this.cyclesConsumed += 2) : ++this.cyclesConsumed;
        }
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SBIS i) {
        this.nextPC = this.pc + 2;
        if (this.getIORegBit(i.imm1, i.imm2)) {
            int tmp_0 = this.getInstrSize(this.nextPC);
            this.nextPC += tmp_0;
            this.cyclesConsumed = tmp_0 == 4 ? (this.cyclesConsumed += 2) : ++this.cyclesConsumed;
        }
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SBIW i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterWord(i.r1);
        int tmp_1 = tmp_0 - i.imm1;
        boolean tmp_2 = (tmp_0 & 0x8000) != 0;
        boolean tmp_3 = (tmp_1 & 0x8000) != 0;
        this.V = tmp_2 && !tmp_3;
        this.N = tmp_3;
        this.Z = (tmp_1 & 0xFFFF) == 0;
        this.C = tmp_3 && !tmp_2;
        this.S = this.N != this.V;
        this.writeRegisterWord(i.r1, tmp_1);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.SBR i) {
        int tmp_1;
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_2 = tmp_0 | (tmp_1 = i.imm1);
        this.N = (tmp_2 & 0x80) != 0;
        this.Z = LegacyInterpreter.low(tmp_2) == 0;
        this.V = false;
        this.S = this.N != this.V;
        byte tmp_3 = LegacyInterpreter.low(tmp_2);
        this.writeRegisterByte(i.r1, tmp_3);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SBRC i) {
        this.nextPC = this.pc + 2;
        if (!Arithmetic.getBit(this.getRegisterByte(i.r1), i.imm1)) {
            int tmp_0 = this.getInstrSize(this.nextPC);
            this.nextPC += tmp_0;
            this.cyclesConsumed = tmp_0 == 4 ? (this.cyclesConsumed += 2) : ++this.cyclesConsumed;
        }
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SBRS i) {
        this.nextPC = this.pc + 2;
        if (Arithmetic.getBit(this.getRegisterByte(i.r1), i.imm1)) {
            int tmp_0 = this.getInstrSize(this.nextPC);
            this.nextPC += tmp_0;
            this.cyclesConsumed = tmp_0 == 4 ? (this.cyclesConsumed += 2) : ++this.cyclesConsumed;
        }
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SEC i) {
        this.nextPC = this.pc + 2;
        this.C = true;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SEH i) {
        this.nextPC = this.pc + 2;
        this.H = true;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SEI i) {
        this.nextPC = this.pc + 2;
        this.enableInterrupts();
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SEN i) {
        this.nextPC = this.pc + 2;
        this.N = true;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SER i) {
        this.nextPC = this.pc + 2;
        this.writeRegisterByte(i.r1, LegacyInterpreter.low(255));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SES i) {
        this.nextPC = this.pc + 2;
        this.S = true;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SET i) {
        this.nextPC = this.pc + 2;
        this.T = true;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SEV i) {
        this.nextPC = this.pc + 2;
        this.V = true;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SEZ i) {
        this.nextPC = this.pc + 2;
        this.Z = true;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SLEEP i) {
        this.nextPC = this.pc + 2;
        this.enterSleepMode();
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SPM i) {
        this.nextPC = this.pc + 2;
        this.storeProgramMemory();
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.ST i) {
        this.nextPC = this.pc + 2;
        this.writeDataByte(this.getRegisterWord(i.r1), this.getRegisterByte(i.r2));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.STD i) {
        this.nextPC = this.pc + 2;
        this.writeDataByte(this.getRegisterWord(i.r1) + i.imm1, this.getRegisterByte(i.r2));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.STPD i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterWord(i.r1) - 1;
        this.writeDataByte(tmp_0, this.getRegisterByte(i.r2));
        this.writeRegisterWord(i.r1, tmp_0);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.STPI i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterWord(i.r1);
        this.writeDataByte(tmp_0, this.getRegisterByte(i.r2));
        this.writeRegisterWord(i.r1, tmp_0 + 1);
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.STS i) {
        this.nextPC = this.pc + 4;
        this.writeDataByte(i.imm1, this.getRegisterByte(i.r1));
        this.cyclesConsumed += 2;
    }

    public void visit(LegacyInstr.SUB i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        byte tmp_1 = this.getRegisterByte(i.r2);
        int tmp_2 = 0;
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        byte tmp_10 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_10);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SUBI i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        int tmp_1 = i.imm1;
        int tmp_2 = 0;
        int tmp_3 = tmp_0 - tmp_1 - tmp_2;
        boolean tmp_4 = (tmp_0 & 0x80) != 0;
        boolean tmp_5 = (tmp_1 & 0x80) != 0;
        boolean tmp_6 = (tmp_3 & 0x80) != 0;
        boolean tmp_7 = (tmp_0 & 8) != 0;
        boolean tmp_8 = (tmp_1 & 8) != 0;
        boolean tmp_9 = (tmp_3 & 8) != 0;
        this.H = !tmp_7 && tmp_8 || tmp_8 && tmp_9 || tmp_9 && !tmp_7;
        this.C = !tmp_4 && tmp_5 || tmp_5 && tmp_6 || tmp_6 && !tmp_4;
        this.N = tmp_6;
        this.Z = LegacyInterpreter.low(tmp_3) == 0;
        this.V = tmp_4 && !tmp_5 && !tmp_6 || !tmp_4 && tmp_5 && tmp_6;
        this.S = this.N != this.V;
        byte tmp_10 = LegacyInterpreter.low(tmp_3);
        this.writeRegisterByte(i.r1, tmp_10);
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.SWAP i) {
        this.nextPC = this.pc + 2;
        int tmp_0 = this.getRegisterUnsigned(i.r1);
        int tmp_1 = 0;
        tmp_1 = tmp_1 & 0xFFFFFFF0 | tmp_0 >> 4 & 0xF & 0xF;
        tmp_1 = tmp_1 & 0xFFFFFF0F | (tmp_0 & 0xF & 0xF) << 4;
        this.writeRegisterByte(i.r1, LegacyInterpreter.low(tmp_1));
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.TST i) {
        this.nextPC = this.pc + 2;
        byte tmp_0 = this.getRegisterByte(i.r1);
        this.V = false;
        this.Z = LegacyInterpreter.low(tmp_0) == 0;
        this.N = (tmp_0 & 0x80) != 0;
        this.S = this.N != this.V;
        ++this.cyclesConsumed;
    }

    public void visit(LegacyInstr.WDR i) {
        this.nextPC = this.pc + 2;
        ++this.cyclesConsumed;
    }

    public void pushPC(int npc) {
        this.pushByte(Arithmetic.low(npc /= 2));
        this.pushByte(Arithmetic.high(npc));
    }

    public static byte low(int val) {
        return (byte)val;
    }

    public static byte high(int val) {
        return (byte)(val >> 8);
    }

    public static byte bit(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    public static int uword(byte low, byte high) {
        return Arithmetic.uword(low, high);
    }

    public int extended(int addr) {
        if (this.RAMPZ > 0) {
            return (this.getIORegisterByte(this.RAMPZ) & 1) << 16 | addr;
        }
        return addr;
    }

    public void enterSleepMode() {
        this.sleeping = true;
        this.innerLoop = false;
        this.simulator.getMicrocontroller().sleep();
    }

    public void leaveSleepMode() {
        this.sleeping = false;
        this.innerLoop = false;
        this.advanceClock(this.simulator.getMicrocontroller().wakeup());
    }

    public static class Factory
    extends InterpreterFactory {
        public Interpreter newInterpreter(Simulator s, Program p, MCUProperties pr) {
            return new LegacyInterpreter(s, p, (AVRProperties)pr);
        }
    }
}

