/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.legacy;

import avrora.arch.AbstractArchitecture;
import avrora.arch.AbstractInstr;
import avrora.arch.legacy.LegacyArchitecture;
import avrora.arch.legacy.LegacyInstrProperties;
import avrora.arch.legacy.LegacyInstrProto;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.arch.legacy.LegacyOperand;
import avrora.arch.legacy.LegacyRegister;

public abstract class LegacyInstr
implements LegacyInstrProto,
AbstractInstr {
    public final LegacyInstrProperties properties;
    private static int IMM3_default = 0;
    private static int IMM5_default = 0;
    private static int IMM6_default = 0;
    private static int IMM8_default = 0;
    private static int SREL_default = 0;
    private static int LREL_default = 0;
    private static int PADDR_default = 0;
    private static int DADDR_default = 0;
    private static LegacyRegister GPR_default = LegacyRegister.R0;
    private static LegacyRegister MGPR_default = LegacyRegister.R16;
    private static LegacyRegister HGPR_default = LegacyRegister.R16;
    private static LegacyRegister EGPR_default = LegacyRegister.R0;
    private static LegacyRegister ADR_default = LegacyRegister.X;
    private static LegacyRegister RDL_default = LegacyRegister.R24;
    private static LegacyRegister YZ_default = LegacyRegister.Y;
    private static LegacyRegister Z_default = LegacyRegister.Z;

    public LegacyInstr(LegacyInstrProperties ip) {
        this.properties = ip;
    }

    public abstract String getOperands();

    public String getVariant() {
        return this.properties.variant;
    }

    public int getSize() {
        return this.properties.size;
    }

    public String getName() {
        return this.properties.name;
    }

    public String toString() {
        return this.getVariant() + ' ' + this.getOperands();
    }

    public int getCycles() {
        return this.properties.cycles;
    }

    public LegacyInstr asInstr() {
        return this;
    }

    public AbstractArchitecture getArchitecture() {
        return LegacyArchitecture.INSTANCE;
    }

    public abstract void accept(LegacyInstrVisitor var1);

    private static void need(int num, LegacyOperand[] ops) {
        if (ops.length != num) {
            throw new WrongNumberOfOperands(ops.length, num);
        }
    }

    private static LegacyRegister GPR(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.GPR_set);
    }

    private static LegacyRegister HGPR(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.HGPR_set);
    }

    private static LegacyRegister MGPR(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.MGPR_set);
    }

    private static LegacyRegister ADR(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.ADR_set);
    }

    private static LegacyRegister RDL(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.RDL_set);
    }

    private static LegacyRegister EGPR(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.EGPR_set);
    }

    private static LegacyRegister YZ(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.YZ_set);
    }

    private static LegacyRegister Z(int num, LegacyRegister reg) {
        return LegacyInstr.checkReg(num, reg, LegacyRegister.Z_set);
    }

    private static int IMM3(int num, int val) {
        return LegacyInstr.checkImm(num, val, 0, 7);
    }

    private static int IMM5(int num, int val) {
        return LegacyInstr.checkImm(num, val, 0, 31);
    }

    private static int IMM6(int num, int val) {
        return LegacyInstr.checkImm(num, val, 0, 63);
    }

    private static int IMM8(int num, int val) {
        return LegacyInstr.checkImm(num, val, 0, 255);
    }

    private static int SREL(int pc, int num, int val) {
        return LegacyInstr.checkImm(num, val - pc - 1, -64, 63);
    }

    private static int LREL(int pc, int num, int val) {
        return LegacyInstr.checkImm(num, val - pc - 1, -2048, 2047);
    }

    private static int DADDR(int num, int val) {
        return LegacyInstr.checkImm(num, val, 0, 65536);
    }

    private static int PADDR(int num, int val) {
        return LegacyInstr.checkImm(num, val, 0, 65536);
    }

    private static int checkImm(int num, int val, int low, int high) {
        if (val < low || val > high) {
            throw new InvalidImmediate(num, val, low, high);
        }
        return val;
    }

    private static LegacyRegister checkReg(int num, LegacyRegister reg, LegacyRegister.Set set) {
        if (set.contains(reg)) {
            return reg;
        }
        throw new InvalidRegister(num, reg, set);
    }

    private static LegacyRegister REG(LegacyOperand o) {
        LegacyOperand.Register r = o.asRegister();
        if (r == null) {
            throw new RegisterRequired(o);
        }
        return r.getRegister();
    }

    private static int IMM(LegacyOperand o) {
        LegacyOperand.Constant c = o.asConstant();
        if (c == null) {
            throw new ImmediateRequired(o);
        }
        return c.getValue();
    }

    private static int WORD(LegacyOperand o) {
        LegacyOperand.Constant c = o.asConstant();
        if (c == null) {
            throw new ImmediateRequired(o);
        }
        return c.getValueAsWord();
    }

    static /* synthetic */ LegacyRegister access$400() {
        return GPR_default;
    }

    static /* synthetic */ LegacyRegister access$600() {
        return RDL_default;
    }

    static /* synthetic */ int access$700() {
        return IMM6_default;
    }

    static /* synthetic */ LegacyRegister access$1000() {
        return HGPR_default;
    }

    static /* synthetic */ int access$1100() {
        return IMM8_default;
    }

    static /* synthetic */ int access$1400() {
        return IMM3_default;
    }

    static /* synthetic */ int access$1600() {
        return SREL_default;
    }

    static /* synthetic */ int access$1800() {
        return PADDR_default;
    }

    static /* synthetic */ int access$2000() {
        return IMM5_default;
    }

    static /* synthetic */ LegacyRegister access$2200() {
        return Z_default;
    }

    static /* synthetic */ LegacyRegister access$2400() {
        return MGPR_default;
    }

    static /* synthetic */ LegacyRegister access$2600() {
        return ADR_default;
    }

    static /* synthetic */ LegacyRegister access$2800() {
        return YZ_default;
    }

    static /* synthetic */ int access$3000() {
        return DADDR_default;
    }

    static /* synthetic */ LegacyRegister access$3200() {
        return EGPR_default;
    }

    static /* synthetic */ int access$3400() {
        return LREL_default;
    }

    public static class WDR
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("wdr", "wdr", 2, 1);
        static final LegacyInstrProto prototype = new WDR(0);

        LegacyInstr allocate(int pc) {
            return new WDR(pc);
        }

        public WDR(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class TST
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("tst", "tst", 2, 1);
        static final LegacyInstrProto prototype = new TST(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new TST(pc, a);
        }

        public TST(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SWAP
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("swap", "swap", 2, 1);
        static final LegacyInstrProto prototype = new SWAP(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new SWAP(pc, a);
        }

        public SWAP(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SUBI
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("subi", "subi", 2, 1);
        static final LegacyInstrProto prototype = new SUBI(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new SUBI(pc, a, b);
        }

        public SUBI(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SUB
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sub", "sub", 2, 1);
        static final LegacyInstrProto prototype = new SUB(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new SUB(pc, a, b);
        }

        public SUB(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class STS
    extends IMMREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sts", "sts", 4, 2);
        static final LegacyInstrProto prototype = new STS(0, LegacyInstr.access$3000(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, int a, LegacyRegister b) {
            return new STS(pc, a, b);
        }

        public STS(int pc, int a, LegacyRegister b) {
            super(props, LegacyInstr.DADDR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class STPI
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("st", "stpi", 2, 2);
        static final LegacyInstrProto prototype = new STPI(0, LegacyInstr.access$2600(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new STPI(pc, a, b);
        }

        public STPI(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.ADR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class STPD
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("st", "stpd", 2, 2);
        static final LegacyInstrProto prototype = new STPD(0, LegacyInstr.access$2600(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new STPD(pc, a, b);
        }

        public STPD(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.ADR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class STD
    extends REGIMMREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("std", "std", 2, 2);
        static final LegacyInstrProto prototype = new STD(0, LegacyInstr.access$2800(), LegacyInstr.access$700(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, int b, LegacyRegister c) {
            return new STD(pc, a, b, c);
        }

        public STD(int pc, LegacyRegister a, int b, LegacyRegister c) {
            super(props, LegacyInstr.YZ(1, a), LegacyInstr.IMM6(2, b), LegacyInstr.GPR(3, c));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ST
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("st", "st", 2, 2);
        static final LegacyInstrProto prototype = new ST(0, LegacyInstr.access$2600(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new ST(pc, a, b);
        }

        public ST(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.ADR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SPM
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("spm", "spm", 2, 1);
        static final LegacyInstrProto prototype = new SPM(0);

        LegacyInstr allocate(int pc) {
            return new SPM(pc);
        }

        public SPM(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SLEEP
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sleep", "sleep", 2, 1);
        static final LegacyInstrProto prototype = new SLEEP(0);

        LegacyInstr allocate(int pc) {
            return new SLEEP(pc);
        }

        public SLEEP(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SEZ
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sez", "sez", 2, 1);
        static final LegacyInstrProto prototype = new SEZ(0);

        LegacyInstr allocate(int pc) {
            return new SEZ(pc);
        }

        public SEZ(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SEV
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sev", "sev", 2, 1);
        static final LegacyInstrProto prototype = new SEV(0);

        LegacyInstr allocate(int pc) {
            return new SEV(pc);
        }

        public SEV(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SET
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("set", "set", 2, 1);
        static final LegacyInstrProto prototype = new SET(0);

        LegacyInstr allocate(int pc) {
            return new SET(pc);
        }

        public SET(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SES
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ses", "ses", 2, 1);
        static final LegacyInstrProto prototype = new SES(0);

        LegacyInstr allocate(int pc) {
            return new SES(pc);
        }

        public SES(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SER
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ser", "ser", 2, 1);
        static final LegacyInstrProto prototype = new SER(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new SER(pc, a);
        }

        public SER(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SEN
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sen", "sen", 2, 1);
        static final LegacyInstrProto prototype = new SEN(0);

        LegacyInstr allocate(int pc) {
            return new SEN(pc);
        }

        public SEN(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SEI
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sei", "sei", 2, 1);
        static final LegacyInstrProto prototype = new SEI(0);

        LegacyInstr allocate(int pc) {
            return new SEI(pc);
        }

        public SEI(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SEH
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("seh", "seh", 2, 1);
        static final LegacyInstrProto prototype = new SEH(0);

        LegacyInstr allocate(int pc) {
            return new SEH(pc);
        }

        public SEH(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SEC
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sec", "sec", 2, 1);
        static final LegacyInstrProto prototype = new SEC(0);

        LegacyInstr allocate(int pc) {
            return new SEC(pc);
        }

        public SEC(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBRS
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbrs", "sbrs", 2, 1);
        static final LegacyInstrProto prototype = new SBRS(0, LegacyInstr.access$400(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new SBRS(pc, a, b);
        }

        public SBRS(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBRC
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbrc", "sbrc", 2, 1);
        static final LegacyInstrProto prototype = new SBRC(0, LegacyInstr.access$400(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new SBRC(pc, a, b);
        }

        public SBRC(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBR
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbr", "sbr", 2, 1);
        static final LegacyInstrProto prototype = new SBR(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new SBR(pc, a, b);
        }

        public SBR(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBIW
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbiw", "sbiw", 2, 2);
        static final LegacyInstrProto prototype = new SBIW(0, LegacyInstr.access$600(), LegacyInstr.access$700());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new SBIW(pc, a, b);
        }

        public SBIW(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.RDL(1, a), LegacyInstr.IMM6(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBIS
    extends IMMIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbis", "sbis", 2, 1);
        static final LegacyInstrProto prototype = new SBIS(0, LegacyInstr.access$2000(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, int a, int b) {
            return new SBIS(pc, a, b);
        }

        public SBIS(int pc, int a, int b) {
            super(props, LegacyInstr.IMM5(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBIC
    extends IMMIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbic", "sbic", 2, 1);
        static final LegacyInstrProto prototype = new SBIC(0, LegacyInstr.access$2000(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, int a, int b) {
            return new SBIC(pc, a, b);
        }

        public SBIC(int pc, int a, int b) {
            super(props, LegacyInstr.IMM5(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBI
    extends IMMIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbi", "sbi", 2, 2);
        static final LegacyInstrProto prototype = new SBI(0, LegacyInstr.access$2000(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, int a, int b) {
            return new SBI(pc, a, b);
        }

        public SBI(int pc, int a, int b) {
            super(props, LegacyInstr.IMM5(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBCI
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbci", "sbci", 2, 1);
        static final LegacyInstrProto prototype = new SBCI(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new SBCI(pc, a, b);
        }

        public SBCI(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class SBC
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("sbc", "sbc", 2, 1);
        static final LegacyInstrProto prototype = new SBC(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new SBC(pc, a, b);
        }

        public SBC(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ROR
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ror", "ror", 2, 1);
        static final LegacyInstrProto prototype = new ROR(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new ROR(pc, a);
        }

        public ROR(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ROL
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("rol", "rol", 2, 1);
        static final LegacyInstrProto prototype = new ROL(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new ROL(pc, a);
        }

        public ROL(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class RJMP
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("rjmp", "rjmp", 2, 2);
        static final LegacyInstrProto prototype = new RJMP(0, LegacyInstr.access$3400());

        LegacyInstr allocate(int pc, int a) {
            return new RJMP(pc, a);
        }

        public RJMP(int pc, int a) {
            super(props, LegacyInstr.LREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class RETI
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("reti", "reti", 2, 4);
        static final LegacyInstrProto prototype = new RETI(0);

        LegacyInstr allocate(int pc) {
            return new RETI(pc);
        }

        public RETI(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class RET
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ret", "ret", 2, 4);
        static final LegacyInstrProto prototype = new RET(0);

        LegacyInstr allocate(int pc) {
            return new RET(pc);
        }

        public RET(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class RCALL
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("rcall", "rcall", 2, 3);
        static final LegacyInstrProto prototype = new RCALL(0, LegacyInstr.access$3400());

        LegacyInstr allocate(int pc, int a) {
            return new RCALL(pc, a);
        }

        public RCALL(int pc, int a) {
            super(props, LegacyInstr.LREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class PUSH
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("push", "push", 2, 2);
        static final LegacyInstrProto prototype = new PUSH(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new PUSH(pc, a);
        }

        public PUSH(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class POP
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("pop", "pop", 2, 2);
        static final LegacyInstrProto prototype = new POP(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new POP(pc, a);
        }

        public POP(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class OUT
    extends IMMREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("out", "out", 2, 1);
        static final LegacyInstrProto prototype = new OUT(0, LegacyInstr.access$700(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, int a, LegacyRegister b) {
            return new OUT(pc, a, b);
        }

        public OUT(int pc, int a, LegacyRegister b) {
            super(props, LegacyInstr.IMM6(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ORI
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ori", "ori", 2, 1);
        static final LegacyInstrProto prototype = new ORI(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new ORI(pc, a, b);
        }

        public ORI(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class OR
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("or", "or", 2, 1);
        static final LegacyInstrProto prototype = new OR(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new OR(pc, a, b);
        }

        public OR(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class NOP
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("nop", "nop", 2, 1);
        static final LegacyInstrProto prototype = new NOP(0);

        LegacyInstr allocate(int pc) {
            return new NOP(pc);
        }

        public NOP(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class NEG
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("neg", "neg", 2, 1);
        static final LegacyInstrProto prototype = new NEG(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new NEG(pc, a);
        }

        public NEG(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class MULSU
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("mulsu", "mulsu", 2, 2);
        static final LegacyInstrProto prototype = new MULSU(0, LegacyInstr.access$2400(), LegacyInstr.access$2400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new MULSU(pc, a, b);
        }

        public MULSU(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.MGPR(1, a), LegacyInstr.MGPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class MULS
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("muls", "muls", 2, 2);
        static final LegacyInstrProto prototype = new MULS(0, LegacyInstr.access$1000(), LegacyInstr.access$1000());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new MULS(pc, a, b);
        }

        public MULS(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.HGPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class MUL
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("mul", "mul", 2, 2);
        static final LegacyInstrProto prototype = new MUL(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new MUL(pc, a, b);
        }

        public MUL(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class MOVW
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("movw", "movw", 2, 1);
        static final LegacyInstrProto prototype = new MOVW(0, LegacyInstr.access$3200(), LegacyInstr.access$3200());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new MOVW(pc, a, b);
        }

        public MOVW(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.EGPR(1, a), LegacyInstr.EGPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class MOV
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("mov", "mov", 2, 1);
        static final LegacyInstrProto prototype = new MOV(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new MOV(pc, a, b);
        }

        public MOV(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LSR
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("lsr", "lsr", 2, 1);
        static final LegacyInstrProto prototype = new LSR(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new LSR(pc, a);
        }

        public LSR(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LSL
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("lsl", "lsl", 2, 1);
        static final LegacyInstrProto prototype = new LSL(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new LSL(pc, a);
        }

        public LSL(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LPMPI
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("lpm", "lpmpi", 2, 3);
        static final LegacyInstrProto prototype = new LPMPI(0, LegacyInstr.access$400(), LegacyInstr.access$2200());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new LPMPI(pc, a, b);
        }

        public LPMPI(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.Z(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LPMD
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("lpm", "lpmd", 2, 3);
        static final LegacyInstrProto prototype = new LPMD(0, LegacyInstr.access$400(), LegacyInstr.access$2200());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new LPMD(pc, a, b);
        }

        public LPMD(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.Z(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LPM
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("lpm", "lpm", 2, 3);
        static final LegacyInstrProto prototype = new LPM(0);

        LegacyInstr allocate(int pc) {
            return new LPM(pc);
        }

        public LPM(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LDS
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("lds", "lds", 4, 2);
        static final LegacyInstrProto prototype = new LDS(0, LegacyInstr.access$400(), LegacyInstr.access$3000());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new LDS(pc, a, b);
        }

        public LDS(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.DADDR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LDPI
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ld", "ldpi", 2, 2);
        static final LegacyInstrProto prototype = new LDPI(0, LegacyInstr.access$400(), LegacyInstr.access$2600());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new LDPI(pc, a, b);
        }

        public LDPI(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.ADR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LDPD
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ld", "ldpd", 2, 2);
        static final LegacyInstrProto prototype = new LDPD(0, LegacyInstr.access$400(), LegacyInstr.access$2600());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new LDPD(pc, a, b);
        }

        public LDPD(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.ADR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LDI
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ldi", "ldi", 2, 1);
        static final LegacyInstrProto prototype = new LDI(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new LDI(pc, a, b);
        }

        public LDI(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LDD
    extends REGREGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ldd", "ldd", 2, 2);
        static final LegacyInstrProto prototype = new LDD(0, LegacyInstr.access$400(), LegacyInstr.access$2800(), LegacyInstr.access$700());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b, int c) {
            return new LDD(pc, a, b, c);
        }

        public LDD(int pc, LegacyRegister a, LegacyRegister b, int c) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.YZ(2, b), LegacyInstr.IMM6(3, c));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class LD
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ld", "ld", 2, 2);
        static final LegacyInstrProto prototype = new LD(0, LegacyInstr.access$400(), LegacyInstr.access$2600());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new LD(pc, a, b);
        }

        public LD(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.ADR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class JMP
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("jmp", "jmp", 4, 3);
        static final LegacyInstrProto prototype = new JMP(0, LegacyInstr.access$1800());

        LegacyInstr allocate(int pc, int a) {
            return new JMP(pc, a);
        }

        public JMP(int pc, int a) {
            super(props, LegacyInstr.PADDR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class INC
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("inc", "inc", 2, 1);
        static final LegacyInstrProto prototype = new INC(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new INC(pc, a);
        }

        public INC(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class IN
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("in", "in", 2, 1);
        static final LegacyInstrProto prototype = new IN(0, LegacyInstr.access$400(), LegacyInstr.access$700());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new IN(pc, a, b);
        }

        public IN(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.IMM6(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class IJMP
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("ijmp", "ijmp", 2, 2);
        static final LegacyInstrProto prototype = new IJMP(0);

        LegacyInstr allocate(int pc) {
            return new IJMP(pc);
        }

        public IJMP(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ICALL
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("icall", "icall", 2, 3);
        static final LegacyInstrProto prototype = new ICALL(0);

        LegacyInstr allocate(int pc) {
            return new ICALL(pc);
        }

        public ICALL(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class FMULSU
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("fmulsu", "fmulsu", 2, 2);
        static final LegacyInstrProto prototype = new FMULSU(0, LegacyInstr.access$2400(), LegacyInstr.access$2400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new FMULSU(pc, a, b);
        }

        public FMULSU(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.MGPR(1, a), LegacyInstr.MGPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class FMULS
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("fmuls", "fmuls", 2, 2);
        static final LegacyInstrProto prototype = new FMULS(0, LegacyInstr.access$2400(), LegacyInstr.access$2400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new FMULS(pc, a, b);
        }

        public FMULS(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.MGPR(1, a), LegacyInstr.MGPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class FMUL
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("fmul", "fmul", 2, 2);
        static final LegacyInstrProto prototype = new FMUL(0, LegacyInstr.access$2400(), LegacyInstr.access$2400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new FMUL(pc, a, b);
        }

        public FMUL(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.MGPR(1, a), LegacyInstr.MGPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class EOR
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("eor", "eor", 2, 1);
        static final LegacyInstrProto prototype = new EOR(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new EOR(pc, a, b);
        }

        public EOR(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ELPMPI
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("elpm", "elpmpi", 2, 3);
        static final LegacyInstrProto prototype = new ELPMPI(0, LegacyInstr.access$400(), LegacyInstr.access$2200());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new ELPMPI(pc, a, b);
        }

        public ELPMPI(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.Z(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ELPMD
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("elpm", "elpmd", 2, 3);
        static final LegacyInstrProto prototype = new ELPMD(0, LegacyInstr.access$400(), LegacyInstr.access$2200());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new ELPMD(pc, a, b);
        }

        public ELPMD(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.Z(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ELPM
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("elpm", "elpm", 2, 3);
        static final LegacyInstrProto prototype = new ELPM(0);

        LegacyInstr allocate(int pc) {
            return new ELPM(pc);
        }

        public ELPM(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class EIJMP
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("eijmp", "eijmp", 2, 2);
        static final LegacyInstrProto prototype = new EIJMP(0);

        LegacyInstr allocate(int pc) {
            return new EIJMP(pc);
        }

        public EIJMP(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class EICALL
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("eicall", "eicall", 2, 4);
        static final LegacyInstrProto prototype = new EICALL(0);

        LegacyInstr allocate(int pc) {
            return new EICALL(pc);
        }

        public EICALL(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class DEC
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("dec", "dec", 2, 1);
        static final LegacyInstrProto prototype = new DEC(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new DEC(pc, a);
        }

        public DEC(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CPSE
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cpse", "cpse", 2, 1);
        static final LegacyInstrProto prototype = new CPSE(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new CPSE(pc, a, b);
        }

        public CPSE(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CPI
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cpi", "cpi", 2, 1);
        static final LegacyInstrProto prototype = new CPI(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new CPI(pc, a, b);
        }

        public CPI(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CPC
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cpc", "cpc", 2, 1);
        static final LegacyInstrProto prototype = new CPC(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new CPC(pc, a, b);
        }

        public CPC(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CP
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cp", "cp", 2, 1);
        static final LegacyInstrProto prototype = new CP(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new CP(pc, a, b);
        }

        public CP(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class COM
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("com", "com", 2, 1);
        static final LegacyInstrProto prototype = new COM(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new COM(pc, a);
        }

        public COM(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLZ
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("clz", "clz", 2, 1);
        static final LegacyInstrProto prototype = new CLZ(0);

        LegacyInstr allocate(int pc) {
            return new CLZ(pc);
        }

        public CLZ(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLV
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("clv", "clv", 2, 1);
        static final LegacyInstrProto prototype = new CLV(0);

        LegacyInstr allocate(int pc) {
            return new CLV(pc);
        }

        public CLV(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLT
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("clt", "clt", 2, 1);
        static final LegacyInstrProto prototype = new CLT(0);

        LegacyInstr allocate(int pc) {
            return new CLT(pc);
        }

        public CLT(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLS
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cls", "cls", 2, 1);
        static final LegacyInstrProto prototype = new CLS(0);

        LegacyInstr allocate(int pc) {
            return new CLS(pc);
        }

        public CLS(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLR
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("clr", "clr", 2, 1);
        static final LegacyInstrProto prototype = new CLR(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new CLR(pc, a);
        }

        public CLR(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLN
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cln", "cln", 2, 1);
        static final LegacyInstrProto prototype = new CLN(0);

        LegacyInstr allocate(int pc) {
            return new CLN(pc);
        }

        public CLN(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLI
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cli", "cli", 2, 1);
        static final LegacyInstrProto prototype = new CLI(0);

        LegacyInstr allocate(int pc) {
            return new CLI(pc);
        }

        public CLI(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLH
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("clh", "clh", 2, 1);
        static final LegacyInstrProto prototype = new CLH(0);

        LegacyInstr allocate(int pc) {
            return new CLH(pc);
        }

        public CLH(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CLC
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("clc", "clc", 2, 1);
        static final LegacyInstrProto prototype = new CLC(0);

        LegacyInstr allocate(int pc) {
            return new CLC(pc);
        }

        public CLC(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CBR
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cbr", "cbr", 2, 1);
        static final LegacyInstrProto prototype = new CBR(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new CBR(pc, a, b);
        }

        public CBR(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CBI
    extends IMMIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("cbi", "cbi", 2, 2);
        static final LegacyInstrProto prototype = new CBI(0, LegacyInstr.access$2000(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, int a, int b) {
            return new CBI(pc, a, b);
        }

        public CBI(int pc, int a, int b) {
            super(props, LegacyInstr.IMM5(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class CALL
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("call", "call", 4, 4);
        static final LegacyInstrProto prototype = new CALL(0, LegacyInstr.access$1800());

        LegacyInstr allocate(int pc, int a) {
            return new CALL(pc, a);
        }

        public CALL(int pc, int a) {
            super(props, LegacyInstr.PADDR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BST
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("bst", "bst", 2, 1);
        static final LegacyInstrProto prototype = new BST(0, LegacyInstr.access$400(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new BST(pc, a, b);
        }

        public BST(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BSET
    extends IMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("bset", "bset", 2, 1);
        static final LegacyInstrProto prototype = new BSET(0, LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, int a) {
            return new BSET(pc, a);
        }

        public BSET(int pc, int a) {
            super(props, LegacyInstr.IMM3(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRVS
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brvs", "brvs", 2, 1);
        static final LegacyInstrProto prototype = new BRVS(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRVS(pc, a);
        }

        public BRVS(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRVC
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brvc", "brvc", 2, 1);
        static final LegacyInstrProto prototype = new BRVC(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRVC(pc, a);
        }

        public BRVC(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRTS
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brts", "brts", 2, 1);
        static final LegacyInstrProto prototype = new BRTS(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRTS(pc, a);
        }

        public BRTS(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRTC
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brtc", "brtc", 2, 1);
        static final LegacyInstrProto prototype = new BRTC(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRTC(pc, a);
        }

        public BRTC(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRSH
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brsh", "brsh", 2, 1);
        static final LegacyInstrProto prototype = new BRSH(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRSH(pc, a);
        }

        public BRSH(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRPL
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brpl", "brpl", 2, 1);
        static final LegacyInstrProto prototype = new BRPL(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRPL(pc, a);
        }

        public BRPL(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRNE
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brne", "brne", 2, 1);
        static final LegacyInstrProto prototype = new BRNE(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRNE(pc, a);
        }

        public BRNE(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRMI
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brmi", "brmi", 2, 1);
        static final LegacyInstrProto prototype = new BRMI(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRMI(pc, a);
        }

        public BRMI(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRLT
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brlt", "brlt", 2, 1);
        static final LegacyInstrProto prototype = new BRLT(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRLT(pc, a);
        }

        public BRLT(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRLO
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brlo", "brlo", 2, 1);
        static final LegacyInstrProto prototype = new BRLO(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRLO(pc, a);
        }

        public BRLO(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRIE
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brie", "brie", 2, 1);
        static final LegacyInstrProto prototype = new BRIE(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRIE(pc, a);
        }

        public BRIE(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRID
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brid", "brid", 2, 1);
        static final LegacyInstrProto prototype = new BRID(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRID(pc, a);
        }

        public BRID(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRHS
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brhs", "brhs", 2, 1);
        static final LegacyInstrProto prototype = new BRHS(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRHS(pc, a);
        }

        public BRHS(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRHC
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brhc", "brhc", 2, 1);
        static final LegacyInstrProto prototype = new BRHC(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRHC(pc, a);
        }

        public BRHC(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRGE
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brge", "brge", 2, 1);
        static final LegacyInstrProto prototype = new BRGE(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRGE(pc, a);
        }

        public BRGE(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BREQ
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("breq", "breq", 2, 1);
        static final LegacyInstrProto prototype = new BREQ(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BREQ(pc, a);
        }

        public BREQ(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BREAK
    extends NONE_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("break", "break", 2, 1);
        static final LegacyInstrProto prototype = new BREAK(0);

        LegacyInstr allocate(int pc) {
            return new BREAK(pc);
        }

        public BREAK(int pc) {
            super(props);
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRCS
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brcs", "brcs", 2, 1);
        static final LegacyInstrProto prototype = new BRCS(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRCS(pc, a);
        }

        public BRCS(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRCC
    extends WORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brcc", "brcc", 2, 1);
        static final LegacyInstrProto prototype = new BRCC(0, LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a) {
            return new BRCC(pc, a);
        }

        public BRCC(int pc, int a) {
            super(props, LegacyInstr.SREL(pc, 1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRBS
    extends IMMWORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brbs", "brbs", 2, 1);
        static final LegacyInstrProto prototype = new BRBS(0, LegacyInstr.access$1400(), LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a, int b) {
            return new BRBS(pc, a, b);
        }

        public BRBS(int pc, int a, int b) {
            super(props, LegacyInstr.IMM3(1, a), LegacyInstr.SREL(pc, 2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BRBC
    extends IMMWORD_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("brbc", "brbc", 2, 1);
        static final LegacyInstrProto prototype = new BRBC(0, LegacyInstr.access$1400(), LegacyInstr.access$1600());

        LegacyInstr allocate(int pc, int a, int b) {
            return new BRBC(pc, a, b);
        }

        public BRBC(int pc, int a, int b) {
            super(props, LegacyInstr.IMM3(1, a), LegacyInstr.SREL(pc, 2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BLD
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("bld", "bld", 2, 1);
        static final LegacyInstrProto prototype = new BLD(0, LegacyInstr.access$400(), LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new BLD(pc, a, b);
        }

        public BLD(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.IMM3(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class BCLR
    extends IMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("bclr", "bclr", 2, 1);
        static final LegacyInstrProto prototype = new BCLR(0, LegacyInstr.access$1400());

        LegacyInstr allocate(int pc, int a) {
            return new BCLR(pc, a);
        }

        public BCLR(int pc, int a) {
            super(props, LegacyInstr.IMM3(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ASR
    extends REG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("asr", "asr", 2, 1);
        static final LegacyInstrProto prototype = new ASR(0, LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a) {
            return new ASR(pc, a);
        }

        public ASR(int pc, LegacyRegister a) {
            super(props, LegacyInstr.GPR(1, a));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ANDI
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("andi", "andi", 2, 1);
        static final LegacyInstrProto prototype = new ANDI(0, LegacyInstr.access$1000(), LegacyInstr.access$1100());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new ANDI(pc, a, b);
        }

        public ANDI(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.HGPR(1, a), LegacyInstr.IMM8(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class AND
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("and", "and", 2, 1);
        static final LegacyInstrProto prototype = new AND(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new AND(pc, a, b);
        }

        public AND(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ADIW
    extends REGIMM_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("adiw", "adiw", 2, 2);
        static final LegacyInstrProto prototype = new ADIW(0, LegacyInstr.access$600(), LegacyInstr.access$700());

        LegacyInstr allocate(int pc, LegacyRegister a, int b) {
            return new ADIW(pc, a, b);
        }

        public ADIW(int pc, LegacyRegister a, int b) {
            super(props, LegacyInstr.RDL(1, a), LegacyInstr.IMM6(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ADD
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("add", "add", 2, 1);
        static final LegacyInstrProto prototype = new ADD(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new ADD(pc, a, b);
        }

        public ADD(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static class ADC
    extends REGREG_class {
        static final LegacyInstrProperties props = new LegacyInstrProperties("adc", "adc", 2, 1);
        static final LegacyInstrProto prototype = new ADC(0, LegacyInstr.access$400(), LegacyInstr.access$400());

        LegacyInstr allocate(int pc, LegacyRegister a, LegacyRegister b) {
            return new ADC(pc, a, b);
        }

        public ADC(int pc, LegacyRegister a, LegacyRegister b) {
            super(props, LegacyInstr.GPR(1, a), LegacyInstr.GPR(2, b));
        }

        public void accept(LegacyInstrVisitor v) {
            v.visit(this);
        }
    }

    public static abstract class NONE_class
    extends LegacyInstr {
        NONE_class(LegacyInstrProperties p) {
            super(p);
        }

        public String getOperands() {
            return "";
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(0, ops);
            return this.allocate(pc);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NONE_class)) {
                return false;
            }
            NONE_class i = (NONE_class)o;
            return i.properties == this.properties;
        }

        abstract LegacyInstr allocate(int var1);
    }

    public static abstract class REGIMMREG_class
    extends LegacyInstr {
        public final LegacyRegister r1;
        public final LegacyRegister r2;
        public final int imm1;

        REGIMMREG_class(LegacyInstrProperties p, LegacyRegister r1, int i1, LegacyRegister r2) {
            super(p);
            this.r1 = r1;
            this.r2 = r2;
            this.imm1 = i1;
        }

        public String getOperands() {
            return this.r1 + "+" + this.imm1 + ", " + this.r2;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(3, ops);
            return this.allocate(pc, LegacyInstr.REG(ops[0]), LegacyInstr.IMM(ops[1]), LegacyInstr.REG(ops[2]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof REGIMMREG_class)) {
                return false;
            }
            REGIMMREG_class i = (REGIMMREG_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            if (i.r1 != this.r1) {
                return false;
            }
            if (i.r2 != this.r2) {
                return false;
            }
            return i.imm1 == this.imm1;
        }

        abstract LegacyInstr allocate(int var1, LegacyRegister var2, int var3, LegacyRegister var4);
    }

    public static abstract class REGREGIMM_class
    extends LegacyInstr {
        public final LegacyRegister r1;
        public final LegacyRegister r2;
        public final int imm1;

        REGREGIMM_class(LegacyInstrProperties p, LegacyRegister r1, LegacyRegister r2, int i1) {
            super(p);
            this.r1 = r1;
            this.r2 = r2;
            this.imm1 = i1;
        }

        public String getOperands() {
            return this.r1 + ", " + this.r2 + '+' + this.imm1;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(3, ops);
            return this.allocate(pc, LegacyInstr.REG(ops[0]), LegacyInstr.REG(ops[1]), LegacyInstr.IMM(ops[2]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof REGREGIMM_class)) {
                return false;
            }
            REGREGIMM_class i = (REGREGIMM_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            if (i.r1 != this.r1) {
                return false;
            }
            if (i.r2 != this.r2) {
                return false;
            }
            return i.imm1 == this.imm1;
        }

        abstract LegacyInstr allocate(int var1, LegacyRegister var2, LegacyRegister var3, int var4);
    }

    public static abstract class WORD_class
    extends LegacyInstr {
        public final int imm1;

        WORD_class(LegacyInstrProperties p, int i1) {
            super(p);
            this.imm1 = i1;
        }

        public String getOperands() {
            return "" + this.imm1;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(1, ops);
            return this.allocate(pc, LegacyInstr.WORD(ops[0]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WORD_class)) {
                return false;
            }
            WORD_class i = (WORD_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            return i.imm1 == this.imm1;
        }

        abstract LegacyInstr allocate(int var1, int var2);
    }

    public static abstract class IMM_class
    extends LegacyInstr {
        public final int imm1;

        IMM_class(LegacyInstrProperties p, int i1) {
            super(p);
            this.imm1 = i1;
        }

        public String getOperands() {
            return "" + this.imm1;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(1, ops);
            return this.allocate(pc, LegacyInstr.IMM(ops[0]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IMM_class)) {
                return false;
            }
            IMM_class i = (IMM_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            return i.imm1 == this.imm1;
        }

        abstract LegacyInstr allocate(int var1, int var2);
    }

    public static abstract class IMMWORD_class
    extends LegacyInstr {
        public final int imm1;
        public final int imm2;

        IMMWORD_class(LegacyInstrProperties p, int i1, int i2) {
            super(p);
            this.imm1 = i1;
            this.imm2 = i2;
        }

        public String getOperands() {
            return this.imm1 + ", " + this.imm2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IMMWORD_class)) {
                return false;
            }
            IMMWORD_class i = (IMMWORD_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            if (i.imm1 != this.imm1) {
                return false;
            }
            return i.imm2 == this.imm2;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(2, ops);
            return this.allocate(pc, LegacyInstr.IMM(ops[0]), LegacyInstr.WORD(ops[1]));
        }

        abstract LegacyInstr allocate(int var1, int var2, int var3);
    }

    public static abstract class IMMIMM_class
    extends LegacyInstr {
        public final int imm1;
        public final int imm2;

        IMMIMM_class(LegacyInstrProperties p, int i1, int i2) {
            super(p);
            this.imm1 = i1;
            this.imm2 = i2;
        }

        public String getOperands() {
            return this.imm1 + ", " + this.imm2;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(2, ops);
            return this.allocate(pc, LegacyInstr.IMM(ops[0]), LegacyInstr.IMM(ops[1]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IMMIMM_class)) {
                return false;
            }
            IMMIMM_class i = (IMMIMM_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            if (i.imm1 != this.imm1) {
                return false;
            }
            return i.imm2 == this.imm2;
        }

        abstract LegacyInstr allocate(int var1, int var2, int var3);
    }

    public static abstract class REG_class
    extends LegacyInstr {
        public final LegacyRegister r1;

        REG_class(LegacyInstrProperties p, LegacyRegister r) {
            super(p);
            this.r1 = r;
        }

        public String getOperands() {
            return this.r1.toString();
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(1, ops);
            return this.allocate(pc, LegacyInstr.REG(ops[0]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof REG_class)) {
                return false;
            }
            REG_class i = (REG_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            return i.r1 == this.r1;
        }

        abstract LegacyInstr allocate(int var1, LegacyRegister var2);
    }

    public static abstract class IMMREG_class
    extends LegacyInstr {
        public final LegacyRegister r1;
        public final int imm1;

        IMMREG_class(LegacyInstrProperties p, int i, LegacyRegister r) {
            super(p);
            this.r1 = r;
            this.imm1 = i;
        }

        public String getOperands() {
            return this.imm1 + ", " + this.r1;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(2, ops);
            return this.allocate(pc, LegacyInstr.IMM(ops[0]), LegacyInstr.REG(ops[1]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IMMREG_class)) {
                return false;
            }
            IMMREG_class i = (IMMREG_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            if (i.r1 != this.r1) {
                return false;
            }
            return i.imm1 == this.imm1;
        }

        abstract LegacyInstr allocate(int var1, int var2, LegacyRegister var3);
    }

    public static abstract class REGIMM_class
    extends LegacyInstr {
        public final LegacyRegister r1;
        public final int imm1;

        REGIMM_class(LegacyInstrProperties p, LegacyRegister r, int i) {
            super(p);
            this.r1 = r;
            this.imm1 = i;
        }

        public String getOperands() {
            return this.r1 + ", " + this.imm1;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(2, ops);
            return this.allocate(pc, LegacyInstr.REG(ops[0]), LegacyInstr.IMM(ops[1]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof REGIMM_class)) {
                return false;
            }
            REGIMM_class i = (REGIMM_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            if (i.r1 != this.r1) {
                return false;
            }
            return i.imm1 == this.imm1;
        }

        abstract LegacyInstr allocate(int var1, LegacyRegister var2, int var3);
    }

    public static abstract class REGREG_class
    extends LegacyInstr {
        public final LegacyRegister r1;
        public final LegacyRegister r2;

        REGREG_class(LegacyInstrProperties p, LegacyRegister _r1, LegacyRegister _r2) {
            super(p);
            this.r1 = _r1;
            this.r2 = _r2;
        }

        public String getOperands() {
            return this.r1 + ", " + this.r2;
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            LegacyInstr.need(2, ops);
            return this.allocate(pc, LegacyInstr.REG(ops[0]), LegacyInstr.REG(ops[1]));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof REGREG_class)) {
                return false;
            }
            REGREG_class i = (REGREG_class)o;
            if (i.properties != this.properties) {
                return false;
            }
            if (i.r1 != this.r1) {
                return false;
            }
            return i.r2 == this.r2;
        }

        abstract LegacyInstr allocate(int var1, LegacyRegister var2, LegacyRegister var3);
    }

    public static class WrongNumberOfOperands
    extends RuntimeException {
        public final int expected;
        public final int found;

        WrongNumberOfOperands(int f, int e) {
            super("wrong number of operands, expected " + e + " and found " + f);
            this.expected = e;
            this.found = f;
        }
    }

    public static class ImmediateRequired
    extends RuntimeException {
        public final LegacyOperand operand;

        ImmediateRequired(LegacyOperand o) {
            super("immediate required");
            this.operand = o;
        }
    }

    public static class RegisterRequired
    extends RuntimeException {
        public final LegacyOperand operand;

        RegisterRequired(LegacyOperand o) {
            super("register required");
            this.operand = o;
        }
    }

    public static class InvalidImmediate
    extends InvalidOperand {
        public final int low;
        public final int high;
        public final int value;

        public InvalidImmediate(int num, int v, int l, int h) {
            super(num, "value out of required range [" + l + ", " + h + ']');
            this.low = l;
            this.high = h;
            this.value = v;
        }
    }

    public static class InvalidRegister
    extends InvalidOperand {
        public final LegacyRegister.Set set;
        public final LegacyRegister register;

        public InvalidRegister(int num, LegacyRegister reg, LegacyRegister.Set s) {
            super(num, "must be one of " + s.contents);
            this.set = s;
            this.register = reg;
        }
    }

    public static class InvalidOperand
    extends RuntimeException {
        public final int number;

        InvalidOperand(int num, String msg) {
            super("invalid operand #" + num + ": " + msg);
            this.number = num;
        }
    }
}

