/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.legacy;

import avrora.arch.AbstractDisassembler;
import avrora.arch.AbstractInstr;
import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyRegister;
import cck.text.StringUtil;
import cck.util.Arithmetic;

public class LegacyDisassembler
implements AbstractDisassembler {
    int pc;
    int index;
    byte[] code;
    static final LegacyRegister[] GPR_table = new LegacyRegister[]{LegacyRegister.R0, LegacyRegister.R1, LegacyRegister.R2, LegacyRegister.R3, LegacyRegister.R4, LegacyRegister.R5, LegacyRegister.R6, LegacyRegister.R7, LegacyRegister.R8, LegacyRegister.R9, LegacyRegister.R10, LegacyRegister.R11, LegacyRegister.R12, LegacyRegister.R13, LegacyRegister.R14, LegacyRegister.R15, LegacyRegister.R16, LegacyRegister.R17, LegacyRegister.R18, LegacyRegister.R19, LegacyRegister.R20, LegacyRegister.R21, LegacyRegister.R22, LegacyRegister.R23, LegacyRegister.R24, LegacyRegister.R25, LegacyRegister.R26, LegacyRegister.R27, LegacyRegister.R28, LegacyRegister.R29, LegacyRegister.R30, LegacyRegister.R31};
    static final LegacyRegister[] HGPR_table = new LegacyRegister[]{LegacyRegister.R16, LegacyRegister.R17, LegacyRegister.R18, LegacyRegister.R19, LegacyRegister.R20, LegacyRegister.R21, LegacyRegister.R22, LegacyRegister.R23, LegacyRegister.R24, LegacyRegister.R25, LegacyRegister.R26, LegacyRegister.R27, LegacyRegister.R28, LegacyRegister.R29, LegacyRegister.R30, LegacyRegister.R31};
    static final LegacyRegister[] MGPR_table = new LegacyRegister[]{LegacyRegister.R16, LegacyRegister.R17, LegacyRegister.R18, LegacyRegister.R19, LegacyRegister.R20, LegacyRegister.R21, LegacyRegister.R22, LegacyRegister.R23};
    static final LegacyRegister[] YZ_table = new LegacyRegister[]{LegacyRegister.Z, LegacyRegister.Y};
    static final LegacyRegister[] Z_table = new LegacyRegister[]{LegacyRegister.Z};
    static final LegacyRegister[] EGPR_table = new LegacyRegister[]{LegacyRegister.R0, LegacyRegister.R2, LegacyRegister.R4, LegacyRegister.R6, LegacyRegister.R8, LegacyRegister.R10, LegacyRegister.R12, LegacyRegister.R14, LegacyRegister.R16, LegacyRegister.R18, LegacyRegister.R20, LegacyRegister.R22, LegacyRegister.R24, LegacyRegister.R26, LegacyRegister.R28, LegacyRegister.R30};
    static final LegacyRegister[] RDL_table = new LegacyRegister[]{LegacyRegister.R24, LegacyRegister.R26, LegacyRegister.R28, LegacyRegister.R30};
    static final LegacyRegister[] XYZ_table = new LegacyRegister[]{LegacyRegister.X, LegacyRegister.Y, LegacyRegister.Z, null};

    public AbstractInstr disassemble(int base, int index, byte[] code) {
        return this.disassembleLegacy(code, base, index);
    }

    public LegacyInstr disassembleLegacy(byte[] code, int base, int index) {
        try {
            short word1 = Arithmetic.word(code[index], code[index + 1]);
            this.index = index;
            this.pc = base + index;
            this.code = code;
            return this.decode_root(word1);
        }
        catch (InvalidInstruction e) {
            return null;
        }
        catch (LegacyInstr.InvalidImmediate e) {
            return null;
        }
    }

    private LegacyRegister getReg(LegacyRegister[] table, int index) throws InvalidInstruction {
        if (index < 0 || index >= table.length) {
            throw new InvalidInstruction(this.getWord(0), this.pc);
        }
        LegacyRegister reg = table[index];
        if (reg == null) {
            throw new InvalidInstruction(this.getWord(0), this.pc);
        }
        return reg;
    }

    private int getWord(int word) {
        return Arithmetic.word(this.code[this.index + word * 2], this.code[this.index + word * 2 + 1]);
    }

    private int getByte(int word) {
        return this.code[word * 2] & 0xFF;
    }

    private int relative(int address, int signbit) {
        address = Arithmetic.signExtend(address, signbit);
        return address + this.pc + 1;
    }

    private LegacyInstr decode_BST_0(int word1) throws InvalidInstruction {
        if ((word1 & 8) != 0) {
            return null;
        }
        int rr = 0;
        int bit = 0;
        return new LegacyInstr.BST(this.pc, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F), bit |= word1 & 7);
    }

    private LegacyInstr decode_BLD_0(int word1) throws InvalidInstruction {
        if ((word1 & 8) != 0) {
            return null;
        }
        int rr = 0;
        int bit = 0;
        return new LegacyInstr.BLD(this.pc, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F), bit |= word1 & 7);
    }

    private LegacyInstr decode_0(int word1) throws InvalidInstruction {
        int value = word1 >> 9 & 1;
        switch (value) {
            case 1: {
                return this.decode_BST_0(word1);
            }
            case 0: {
                return this.decode_BLD_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_BRPL_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRPL(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRGE_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRGE(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRTC_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRTC(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRNE_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRNE(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRVC_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRVC(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRID_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRID(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRHC_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRHC(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRCC_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRCC(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_1(int word1) throws InvalidInstruction {
        int value = word1 & 7;
        switch (value) {
            case 2: {
                return this.decode_BRPL_0(word1);
            }
            case 4: {
                return this.decode_BRGE_0(word1);
            }
            case 6: {
                return this.decode_BRTC_0(word1);
            }
            case 1: {
                return this.decode_BRNE_0(word1);
            }
            case 3: {
                return this.decode_BRVC_0(word1);
            }
            case 7: {
                return this.decode_BRID_0(word1);
            }
            case 5: {
                return this.decode_BRHC_0(word1);
            }
            case 0: {
                return this.decode_BRCC_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_SBRS_0(int word1) throws InvalidInstruction {
        if ((word1 & 8) != 0) {
            return null;
        }
        int rr = 0;
        int bit = 0;
        return new LegacyInstr.SBRS(this.pc, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F), bit |= word1 & 7);
    }

    private LegacyInstr decode_SBRC_0(int word1) throws InvalidInstruction {
        if ((word1 & 8) != 0) {
            return null;
        }
        int rr = 0;
        int bit = 0;
        return new LegacyInstr.SBRC(this.pc, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F), bit |= word1 & 7);
    }

    private LegacyInstr decode_2(int word1) throws InvalidInstruction {
        int value = word1 >> 9 & 1;
        switch (value) {
            case 1: {
                return this.decode_SBRS_0(word1);
            }
            case 0: {
                return this.decode_SBRC_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_BRMI_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRMI(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRLT_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRLT(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRTS_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRTS(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BREQ_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BREQ(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRVS_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRVS(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRIE_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRIE(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRHS_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRHS(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_BRCS_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.BRCS(this.pc, this.relative(target |= word1 >> 3 & 0x7F, 6));
    }

    private LegacyInstr decode_3(int word1) throws InvalidInstruction {
        int value = word1 & 7;
        switch (value) {
            case 2: {
                return this.decode_BRMI_0(word1);
            }
            case 4: {
                return this.decode_BRLT_0(word1);
            }
            case 6: {
                return this.decode_BRTS_0(word1);
            }
            case 1: {
                return this.decode_BREQ_0(word1);
            }
            case 3: {
                return this.decode_BRVS_0(word1);
            }
            case 7: {
                return this.decode_BRIE_0(word1);
            }
            case 5: {
                return this.decode_BRHS_0(word1);
            }
            case 0: {
                return this.decode_BRCS_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_4(int word1) throws InvalidInstruction {
        int value = word1 >> 10 & 3;
        switch (value) {
            case 2: {
                return this.decode_0(word1);
            }
            case 1: {
                return this.decode_1(word1);
            }
            case 3: {
                return this.decode_2(word1);
            }
            case 0: {
                return this.decode_3(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_SBCI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 8 & 0xF) << 4;
        return new LegacyInstr.SBCI(this.pc, this.getReg(HGPR_table, rd |= word1 >> 4 & 0xF), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_ST_1(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.ST(this.pc, LegacyRegister.Y, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_ST_2(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.ST(this.pc, LegacyRegister.Z, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_5(int word1) throws InvalidInstruction {
        int value = word1 & 0xF;
        switch (value) {
            case 8: {
                return this.decode_ST_1(word1);
            }
            case 0: {
                return this.decode_ST_2(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_LD_1(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.Y);
    }

    private LegacyInstr decode_LD_2(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.Z);
    }

    private LegacyInstr decode_6(int word1) throws InvalidInstruction {
        int value = word1 & 0xF;
        switch (value) {
            case 8: {
                return this.decode_LD_1(word1);
            }
            case 0: {
                return this.decode_LD_2(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_7(int word1) throws InvalidInstruction {
        int value = word1 >> 9 & 7;
        switch (value) {
            case 1: {
                return this.decode_5(word1);
            }
            case 0: {
                return this.decode_6(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_OUT_0(int word1) throws InvalidInstruction {
        int ior = 0;
        int rr = 0;
        ior |= (word1 >> 9 & 3) << 4;
        return new LegacyInstr.OUT(this.pc, ior |= word1 & 0xF, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_IN_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 9 & 3) << 4;
        return new LegacyInstr.IN(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_8(int word1) throws InvalidInstruction {
        int value = word1 >> 11 & 1;
        switch (value) {
            case 1: {
                return this.decode_OUT_0(word1);
            }
            case 0: {
                return this.decode_IN_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_CPI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 8 & 0xF) << 4;
        return new LegacyInstr.CPI(this.pc, this.getReg(HGPR_table, rd |= word1 >> 4 & 0xF), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_ANDI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 8 & 0xF) << 4;
        return new LegacyInstr.ANDI(this.pc, this.getReg(HGPR_table, rd |= word1 >> 4 & 0xF), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_RJMP_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.RJMP(this.pc, this.relative(target |= word1 & 0xFFF, 11));
    }

    private LegacyInstr decode_OR_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.OR(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_EOR_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.EOR(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_MOV_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.MOV(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_AND_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.AND(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_9(int word1) throws InvalidInstruction {
        int value = word1 >> 10 & 3;
        switch (value) {
            case 2: {
                return this.decode_OR_0(word1);
            }
            case 1: {
                return this.decode_EOR_0(word1);
            }
            case 3: {
                return this.decode_MOV_0(word1);
            }
            case 0: {
                return this.decode_AND_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_RCALL_0(int word1) throws InvalidInstruction {
        int target = 0;
        return new LegacyInstr.RCALL(this.pc, this.relative(target |= word1 & 0xFFF, 11));
    }

    private LegacyInstr decode_SBI_0(int word1) throws InvalidInstruction {
        int ior = 0;
        int bit = 0;
        return new LegacyInstr.SBI(this.pc, ior |= word1 >> 3 & 0x1F, bit |= word1 & 7);
    }

    private LegacyInstr decode_SBIC_0(int word1) throws InvalidInstruction {
        int ior = 0;
        int bit = 0;
        return new LegacyInstr.SBIC(this.pc, ior |= word1 >> 3 & 0x1F, bit |= word1 & 7);
    }

    private LegacyInstr decode_SBIS_0(int word1) throws InvalidInstruction {
        int ior = 0;
        int bit = 0;
        return new LegacyInstr.SBIS(this.pc, ior |= word1 >> 3 & 0x1F, bit |= word1 & 7);
    }

    private LegacyInstr decode_CBI_0(int word1) throws InvalidInstruction {
        int ior = 0;
        int bit = 0;
        return new LegacyInstr.CBI(this.pc, ior |= word1 >> 3 & 0x1F, bit |= word1 & 7);
    }

    private LegacyInstr decode_10(int word1) throws InvalidInstruction {
        int value = word1 >> 8 & 3;
        switch (value) {
            case 2: {
                return this.decode_SBI_0(word1);
            }
            case 1: {
                return this.decode_SBIC_0(word1);
            }
            case 3: {
                return this.decode_SBIS_0(word1);
            }
            case 0: {
                return this.decode_CBI_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_SBIW_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 6 & 3) << 4;
        return new LegacyInstr.SBIW(this.pc, this.getReg(RDL_table, rd |= word1 >> 4 & 3), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_ADIW_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 6 & 3) << 4;
        return new LegacyInstr.ADIW(this.pc, this.getReg(RDL_table, rd |= word1 >> 4 & 3), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_11(int word1) throws InvalidInstruction {
        int value = word1 >> 8 & 1;
        switch (value) {
            case 1: {
                return this.decode_SBIW_0(word1);
            }
            case 0: {
                return this.decode_ADIW_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_ASR_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 1) {
            return null;
        }
        int rd = 0;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.ASR(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF));
    }

    private LegacyInstr decode_CLI_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLI(this.pc);
    }

    private LegacyInstr decode_SES_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SES(this.pc);
    }

    private LegacyInstr decode_SPM_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SPM(this.pc);
    }

    private LegacyInstr decode_CLC_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLC(this.pc);
    }

    private LegacyInstr decode_WDR_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.WDR(this.pc);
    }

    private LegacyInstr decode_CLV_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLV(this.pc);
    }

    private LegacyInstr decode_ICALL_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.ICALL(this.pc);
    }

    private LegacyInstr decode_RET_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.RET(this.pc);
    }

    private LegacyInstr decode_12(int word1) throws InvalidInstruction {
        int value = word1 & 1;
        switch (value) {
            case 1: {
                return this.decode_ICALL_0(word1);
            }
            case 0: {
                return this.decode_RET_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_SEV_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SEV(this.pc);
    }

    private LegacyInstr decode_SEI_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SEI(this.pc);
    }

    private LegacyInstr decode_CLS_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLS(this.pc);
    }

    private LegacyInstr decode_EICALL_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.EICALL(this.pc);
    }

    private LegacyInstr decode_RETI_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.RETI(this.pc);
    }

    private LegacyInstr decode_13(int word1) throws InvalidInstruction {
        int value = word1 & 1;
        switch (value) {
            case 1: {
                return this.decode_EICALL_0(word1);
            }
            case 0: {
                return this.decode_RETI_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_SEN_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SEN(this.pc);
    }

    private LegacyInstr decode_CLH_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLH(this.pc);
    }

    private LegacyInstr decode_CLZ_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLZ(this.pc);
    }

    private LegacyInstr decode_LPM_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.LPM(this.pc);
    }

    private LegacyInstr decode_SET_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SET(this.pc);
    }

    private LegacyInstr decode_EIJMP_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.EIJMP(this.pc);
    }

    private LegacyInstr decode_SEZ_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.SEZ(this.pc);
    }

    private LegacyInstr decode_14(int word1) throws InvalidInstruction {
        int value = word1 & 1;
        switch (value) {
            case 1: {
                return this.decode_EIJMP_0(word1);
            }
            case 0: {
                return this.decode_SEZ_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_ELPM_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.ELPM(this.pc);
    }

    private LegacyInstr decode_CLT_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLT(this.pc);
    }

    private LegacyInstr decode_BREAK_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.BREAK(this.pc);
    }

    private LegacyInstr decode_SLEEP_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SLEEP(this.pc);
    }

    private LegacyInstr decode_CLN_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.CLN(this.pc);
    }

    private LegacyInstr decode_SEH_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        return new LegacyInstr.SEH(this.pc);
    }

    private LegacyInstr decode_IJMP_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.IJMP(this.pc);
    }

    private LegacyInstr decode_SEC_0(int word1) throws InvalidInstruction {
        return new LegacyInstr.SEC(this.pc);
    }

    private LegacyInstr decode_15(int word1) throws InvalidInstruction {
        int value = word1 & 1;
        switch (value) {
            case 1: {
                return this.decode_IJMP_0(word1);
            }
            case 0: {
                return this.decode_SEC_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_16(int word1) throws InvalidInstruction {
        int value = word1 >> 4 & 0x1F;
        switch (value) {
            case 15: {
                return this.decode_CLI_0(word1);
            }
            case 4: {
                return this.decode_SES_0(word1);
            }
            case 30: {
                return this.decode_SPM_0(word1);
            }
            case 8: {
                return this.decode_CLC_0(word1);
            }
            case 26: {
                return this.decode_WDR_0(word1);
            }
            case 11: {
                return this.decode_CLV_0(word1);
            }
            case 16: {
                return this.decode_12(word1);
            }
            case 3: {
                return this.decode_SEV_0(word1);
            }
            case 7: {
                return this.decode_SEI_0(word1);
            }
            case 12: {
                return this.decode_CLS_0(word1);
            }
            case 17: {
                return this.decode_13(word1);
            }
            case 2: {
                return this.decode_SEN_0(word1);
            }
            case 13: {
                return this.decode_CLH_0(word1);
            }
            case 9: {
                return this.decode_CLZ_0(word1);
            }
            case 28: {
                return this.decode_LPM_0(word1);
            }
            case 6: {
                return this.decode_SET_0(word1);
            }
            case 1: {
                return this.decode_14(word1);
            }
            case 29: {
                return this.decode_ELPM_0(word1);
            }
            case 14: {
                return this.decode_CLT_0(word1);
            }
            case 25: {
                return this.decode_BREAK_0(word1);
            }
            case 24: {
                return this.decode_SLEEP_0(word1);
            }
            case 10: {
                return this.decode_CLN_0(word1);
            }
            case 5: {
                return this.decode_SEH_0(word1);
            }
            case 0: {
                return this.decode_15(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_JMP_0(int word1) throws InvalidInstruction {
        int word2 = this.getWord(1);
        int target = 0;
        target |= (word1 >> 4 & 0x1F) << 17;
        target |= (word1 & 1) << 16;
        return new LegacyInstr.JMP(this.pc, target |= word2 & 0xFFFF);
    }

    private LegacyInstr decode_INC_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.INC(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_SWAP_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.SWAP(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_17(int word1) throws InvalidInstruction {
        int value = word1 & 1;
        switch (value) {
            case 1: {
                return this.decode_INC_0(word1);
            }
            case 0: {
                return this.decode_SWAP_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_ROR_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.ROR(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_LSR_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LSR(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_18(int word1) throws InvalidInstruction {
        int value = word1 & 1;
        switch (value) {
            case 1: {
                return this.decode_ROR_0(word1);
            }
            case 0: {
                return this.decode_LSR_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_CALL_0(int word1) throws InvalidInstruction {
        int word2 = this.getWord(1);
        int target = 0;
        target |= (word1 >> 4 & 0x1F) << 17;
        target |= (word1 & 1) << 16;
        return new LegacyInstr.CALL(this.pc, target |= word2 & 0xFFFF);
    }

    private LegacyInstr decode_DEC_0(int word1) throws InvalidInstruction {
        if ((word1 & 1) != 0) {
            return null;
        }
        int rd = 0;
        return new LegacyInstr.DEC(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_NEG_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.NEG(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_COM_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.COM(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_19(int word1) throws InvalidInstruction {
        int value = word1 & 1;
        switch (value) {
            case 1: {
                return this.decode_NEG_0(word1);
            }
            case 0: {
                return this.decode_COM_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_20(int word1) throws InvalidInstruction {
        int value = word1 >> 1 & 7;
        switch (value) {
            case 2: {
                return this.decode_ASR_0(word1);
            }
            case 4: {
                return this.decode_16(word1);
            }
            case 6: {
                return this.decode_JMP_0(word1);
            }
            case 1: {
                return this.decode_17(word1);
            }
            case 3: {
                return this.decode_18(word1);
            }
            case 7: {
                return this.decode_CALL_0(word1);
            }
            case 5: {
                return this.decode_DEC_0(word1);
            }
            case 0: {
                return this.decode_19(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_21(int word1) throws InvalidInstruction {
        int value = word1 >> 9 & 1;
        switch (value) {
            case 1: {
                return this.decode_11(word1);
            }
            case 0: {
                return this.decode_20(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_MUL_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.MUL(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_STPD_2(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.STPD(this.pc, LegacyRegister.Z, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_PUSH_0(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.PUSH(this.pc, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_STPI_0(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.STPI(this.pc, LegacyRegister.X, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_STPI_1(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.STPI(this.pc, LegacyRegister.Y, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_STPI_2(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.STPI(this.pc, LegacyRegister.Z, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_STPD_0(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.STPD(this.pc, LegacyRegister.X, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_STPD_1(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.STPD(this.pc, LegacyRegister.Y, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_ST_0(int word1) throws InvalidInstruction {
        int rr = 0;
        return new LegacyInstr.ST(this.pc, LegacyRegister.X, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_STS_0(int word1) throws InvalidInstruction {
        int word2 = this.getWord(1);
        int addr = 0;
        int rr = 0;
        return new LegacyInstr.STS(this.pc, addr |= word2 & 0xFFFF, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_22(int word1) throws InvalidInstruction {
        int value = word1 & 0xF;
        switch (value) {
            case 2: {
                return this.decode_STPD_2(word1);
            }
            case 15: {
                return this.decode_PUSH_0(word1);
            }
            case 13: {
                return this.decode_STPI_0(word1);
            }
            case 9: {
                return this.decode_STPI_1(word1);
            }
            case 1: {
                return this.decode_STPI_2(word1);
            }
            case 14: {
                return this.decode_STPD_0(word1);
            }
            case 10: {
                return this.decode_STPD_1(word1);
            }
            case 12: {
                return this.decode_ST_0(word1);
            }
            case 0: {
                return this.decode_STS_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_POP_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.POP(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_LPMD_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int z = 0;
        return new LegacyInstr.LPMD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), this.getReg(Z_table, z));
    }

    private LegacyInstr decode_ELPMPI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.ELPMPI(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), this.getReg(Z_table, rr));
    }

    private LegacyInstr decode_LD_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.X);
    }

    private LegacyInstr decode_LDPD_2(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LDPD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.Z);
    }

    private LegacyInstr decode_LDPI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LDPI(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.X);
    }

    private LegacyInstr decode_LDPI_1(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LDPI(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.Y);
    }

    private LegacyInstr decode_ELPMD_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.ELPMD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), this.getReg(Z_table, rr));
    }

    private LegacyInstr decode_LDPI_2(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LDPI(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.Z);
    }

    private LegacyInstr decode_LDPD_0(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LDPD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.X);
    }

    private LegacyInstr decode_LDPD_1(int word1) throws InvalidInstruction {
        int rd = 0;
        return new LegacyInstr.LDPD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), LegacyRegister.Y);
    }

    private LegacyInstr decode_LPMPI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int z = 0;
        return new LegacyInstr.LPMPI(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), this.getReg(Z_table, z));
    }

    private LegacyInstr decode_LDS_0(int word1) throws InvalidInstruction {
        int word2 = this.getWord(1);
        int rd = 0;
        int addr = 0;
        return new LegacyInstr.LDS(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), addr |= word2 & 0xFFFF);
    }

    private LegacyInstr decode_23(int word1) throws InvalidInstruction {
        int value = word1 & 0xF;
        switch (value) {
            case 15: {
                return this.decode_POP_0(word1);
            }
            case 4: {
                return this.decode_LPMD_0(word1);
            }
            case 7: {
                return this.decode_ELPMPI_0(word1);
            }
            case 12: {
                return this.decode_LD_0(word1);
            }
            case 2: {
                return this.decode_LDPD_2(word1);
            }
            case 13: {
                return this.decode_LDPI_0(word1);
            }
            case 9: {
                return this.decode_LDPI_1(word1);
            }
            case 6: {
                return this.decode_ELPMD_0(word1);
            }
            case 1: {
                return this.decode_LDPI_2(word1);
            }
            case 14: {
                return this.decode_LDPD_0(word1);
            }
            case 10: {
                return this.decode_LDPD_1(word1);
            }
            case 5: {
                return this.decode_LPMPI_0(word1);
            }
            case 0: {
                return this.decode_LDS_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_24(int word1) throws InvalidInstruction {
        int value = word1 >> 9 & 1;
        switch (value) {
            case 1: {
                return this.decode_22(word1);
            }
            case 0: {
                return this.decode_23(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_25(int word1) throws InvalidInstruction {
        int value = word1 >> 10 & 3;
        switch (value) {
            case 2: {
                return this.decode_10(word1);
            }
            case 1: {
                return this.decode_21(word1);
            }
            case 3: {
                return this.decode_MUL_0(word1);
            }
            case 0: {
                return this.decode_24(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_ORI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 8 & 0xF) << 4;
        return new LegacyInstr.ORI(this.pc, this.getReg(HGPR_table, rd |= word1 >> 4 & 0xF), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_SUB_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.SUB(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_CP_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.CP(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_ADC_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.ADC(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_CPSE_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.CPSE(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_26(int word1) throws InvalidInstruction {
        int value = word1 >> 10 & 3;
        switch (value) {
            case 2: {
                return this.decode_SUB_0(word1);
            }
            case 1: {
                return this.decode_CP_0(word1);
            }
            case 3: {
                return this.decode_ADC_0(word1);
            }
            case 0: {
                return this.decode_CPSE_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_LDI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 8 & 0xF) << 4;
        return new LegacyInstr.LDI(this.pc, this.getReg(HGPR_table, rd |= word1 >> 4 & 0xF), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_SUBI_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int imm = 0;
        imm |= (word1 >> 8 & 0xF) << 4;
        return new LegacyInstr.SUBI(this.pc, this.getReg(HGPR_table, rd |= word1 >> 4 & 0xF), imm |= word1 & 0xF);
    }

    private LegacyInstr decode_SBC_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.SBC(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_CPC_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.CPC(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_ADD_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        rr |= (word1 >> 9 & 1) << 4;
        rd |= (word1 >> 8 & 1) << 4;
        return new LegacyInstr.ADD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0xF), this.getReg(GPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_MULS_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.MULS(this.pc, this.getReg(HGPR_table, rd |= word1 >> 4 & 0xF), this.getReg(HGPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_MOVW_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.MOVW(this.pc, this.getReg(EGPR_table, rd |= word1 >> 4 & 0xF), this.getReg(EGPR_table, rr |= word1 & 0xF));
    }

    private LegacyInstr decode_FMULSU_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.FMULSU(this.pc, this.getReg(MGPR_table, rd |= word1 >> 4 & 7), this.getReg(MGPR_table, rr |= word1 & 7));
    }

    private LegacyInstr decode_FMULS_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.FMULS(this.pc, this.getReg(MGPR_table, rd |= word1 >> 4 & 7), this.getReg(MGPR_table, rr |= word1 & 7));
    }

    private LegacyInstr decode_27(int word1) throws InvalidInstruction {
        int value = word1 >> 3 & 1;
        switch (value) {
            case 1: {
                return this.decode_FMULSU_0(word1);
            }
            case 0: {
                return this.decode_FMULS_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_FMUL_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.FMUL(this.pc, this.getReg(MGPR_table, rd |= word1 >> 4 & 7), this.getReg(MGPR_table, rr |= word1 & 7));
    }

    private LegacyInstr decode_MULSU_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int rr = 0;
        return new LegacyInstr.MULSU(this.pc, this.getReg(MGPR_table, rd |= word1 >> 4 & 7), this.getReg(MGPR_table, rr |= word1 & 7));
    }

    private LegacyInstr decode_28(int word1) throws InvalidInstruction {
        int value = word1 >> 3 & 1;
        switch (value) {
            case 1: {
                return this.decode_FMUL_0(word1);
            }
            case 0: {
                return this.decode_MULSU_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_29(int word1) throws InvalidInstruction {
        int value = word1 >> 7 & 1;
        switch (value) {
            case 1: {
                return this.decode_27(word1);
            }
            case 0: {
                return this.decode_28(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_NOP_0(int word1) throws InvalidInstruction {
        if ((word1 & 0xFF) != 0) {
            return null;
        }
        return new LegacyInstr.NOP(this.pc);
    }

    private LegacyInstr decode_30(int word1) throws InvalidInstruction {
        int value = word1 >> 8 & 3;
        switch (value) {
            case 2: {
                return this.decode_MULS_0(word1);
            }
            case 1: {
                return this.decode_MOVW_0(word1);
            }
            case 3: {
                return this.decode_29(word1);
            }
            case 0: {
                return this.decode_NOP_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_31(int word1) throws InvalidInstruction {
        int value = word1 >> 10 & 3;
        switch (value) {
            case 2: {
                return this.decode_SBC_0(word1);
            }
            case 1: {
                return this.decode_CPC_0(word1);
            }
            case 3: {
                return this.decode_ADD_0(word1);
            }
            case 0: {
                return this.decode_30(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_root0(int word1) throws InvalidInstruction {
        int value = word1 >> 12 & 0xF;
        switch (value) {
            case 15: {
                return this.decode_4(word1);
            }
            case 4: {
                return this.decode_SBCI_0(word1);
            }
            case 8: {
                return this.decode_7(word1);
            }
            case 11: {
                return this.decode_8(word1);
            }
            case 3: {
                return this.decode_CPI_0(word1);
            }
            case 7: {
                return this.decode_ANDI_0(word1);
            }
            case 12: {
                return this.decode_RJMP_0(word1);
            }
            case 2: {
                return this.decode_9(word1);
            }
            case 13: {
                return this.decode_RCALL_0(word1);
            }
            case 9: {
                return this.decode_25(word1);
            }
            case 6: {
                return this.decode_ORI_0(word1);
            }
            case 1: {
                return this.decode_26(word1);
            }
            case 14: {
                return this.decode_LDI_0(word1);
            }
            case 5: {
                return this.decode_SUBI_0(word1);
            }
            case 0: {
                return this.decode_31(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_STD_0(int word1) throws InvalidInstruction {
        int ar = 0;
        int imm = 0;
        int rr = 0;
        imm = Arithmetic.setBit(imm, 5, Arithmetic.getBit(word1, 13));
        imm |= (word1 >> 10 & 3) << 3;
        ar = Arithmetic.setBit(ar, 0, Arithmetic.getBit(word1, 3));
        return new LegacyInstr.STD(this.pc, this.getReg(YZ_table, ar), imm |= word1 & 7, this.getReg(GPR_table, rr |= word1 >> 4 & 0x1F));
    }

    private LegacyInstr decode_LDD_0(int word1) throws InvalidInstruction {
        int rd = 0;
        int ar = 0;
        int imm = 0;
        imm = Arithmetic.setBit(imm, 5, Arithmetic.getBit(word1, 13));
        imm |= (word1 >> 10 & 3) << 3;
        ar = Arithmetic.setBit(ar, 0, Arithmetic.getBit(word1, 3));
        return new LegacyInstr.LDD(this.pc, this.getReg(GPR_table, rd |= word1 >> 4 & 0x1F), this.getReg(YZ_table, ar), imm |= word1 & 7);
    }

    private LegacyInstr decode_32(int word1) throws InvalidInstruction {
        int value = word1 >> 9 & 1;
        switch (value) {
            case 1: {
                return this.decode_STD_0(word1);
            }
            case 0: {
                return this.decode_LDD_0(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_33(int word1) throws InvalidInstruction {
        int value = word1 >> 12 & 1;
        switch (value) {
            case 0: {
                return this.decode_32(word1);
            }
        }
        return null;
    }

    private LegacyInstr decode_root1(int word1) throws InvalidInstruction {
        int value = word1 >> 14 & 3;
        switch (value) {
            case 2: {
                return this.decode_33(word1);
            }
        }
        return null;
    }

    LegacyInstr decode_root(int word1) throws InvalidInstruction {
        LegacyInstr i = null;
        i = this.decode_root0(word1);
        if (i != null) {
            return i;
        }
        i = this.decode_root1(word1);
        if (i != null) {
            return i;
        }
        throw new InvalidInstruction(word1, this.pc);
    }

    public class InvalidInstruction
    extends Exception {
        public final int pc;
        public final int word1;

        InvalidInstruction(int word1, int pc) {
            super("Invalid Instruction at " + StringUtil.addrToString(pc));
            this.pc = pc;
            this.word1 = word1;
        }
    }
}

