/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import java.util.HashMap;

public class AVRSymbol {
    public final String symbol;
    public final int value;

    AVRSymbol(String sym, int v) {
        this.symbol = sym;
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    public int getEncodingValue() {
        return this.value;
    }

    public static GPR get_GPR(String name) {
        return (GPR)GPR.set.get(name);
    }

    public static ADR get_ADR(String name) {
        return (ADR)ADR.set.get(name);
    }

    public static HGPR get_HGPR(String name) {
        return (HGPR)HGPR.set.get(name);
    }

    public static EGPR get_EGPR(String name) {
        return (EGPR)EGPR.set.get(name);
    }

    public static MGPR get_MGPR(String name) {
        return (MGPR)MGPR.set.get(name);
    }

    public static YZ get_YZ(String name) {
        return (YZ)YZ.set.get(name);
    }

    public static RDL get_RDL(String name) {
        return (RDL)RDL.set.get(name);
    }

    public static R0 get_R0(String name) {
        return (R0)R0.set.get(name);
    }

    public static RZ get_RZ(String name) {
        return (RZ)RZ.set.get(name);
    }

    public static class RZ
    extends ADR {
        public final int encoding;
        private static HashMap set = new HashMap();
        public static final RZ Z = RZ.newRZ("Z", 30, 0);

        public int getEncodingValue() {
            return this.encoding;
        }

        private static RZ newRZ(String n, int v, int ev) {
            RZ obj = new RZ(n, v, ev);
            set.put(n, obj);
            return obj;
        }

        RZ(String sym, int v, int ev) {
            super(sym, v);
            this.encoding = ev;
        }
    }

    public static class R0
    extends GPR {
        public final int encoding;
        private static HashMap set = new HashMap();
        public static final R0 R0 = avrora.arch.avr.AVRSymbol$R0.newR0("r0", 0, 0);

        public int getEncodingValue() {
            return this.encoding;
        }

        private static R0 newR0(String n, int v, int ev) {
            R0 obj = new R0(n, v, ev);
            set.put(n, obj);
            return obj;
        }

        R0(String sym, int v, int ev) {
            super(sym, v);
            this.encoding = ev;
        }
    }

    public static class RDL
    extends GPR {
        public final int encoding;
        private static HashMap set = new HashMap();
        public static final RDL R24 = RDL.newRDL("r24", 24, 0);
        public static final RDL R26 = RDL.newRDL("r26", 26, 1);
        public static final RDL R28 = RDL.newRDL("r28", 28, 2);
        public static final RDL R30 = RDL.newRDL("r30", 30, 3);

        public int getEncodingValue() {
            return this.encoding;
        }

        private static RDL newRDL(String n, int v, int ev) {
            RDL obj = new RDL(n, v, ev);
            set.put(n, obj);
            return obj;
        }

        RDL(String sym, int v, int ev) {
            super(sym, v);
            this.encoding = ev;
        }
    }

    public static class YZ
    extends ADR {
        public final int encoding;
        private static HashMap set = new HashMap();
        public static final YZ Y = YZ.newYZ("Y", 28, 1);
        public static final YZ Z = YZ.newYZ("Z", 30, 0);

        public int getEncodingValue() {
            return this.encoding;
        }

        private static YZ newYZ(String n, int v, int ev) {
            YZ obj = new YZ(n, v, ev);
            set.put(n, obj);
            return obj;
        }

        YZ(String sym, int v, int ev) {
            super(sym, v);
            this.encoding = ev;
        }
    }

    public static class MGPR
    extends GPR {
        public final int encoding;
        private static HashMap set = new HashMap();
        public static final MGPR R16 = MGPR.newMGPR("r16", 16, 0);
        public static final MGPR R17 = MGPR.newMGPR("r17", 17, 1);
        public static final MGPR R18 = MGPR.newMGPR("r18", 18, 2);
        public static final MGPR R19 = MGPR.newMGPR("r19", 19, 3);
        public static final MGPR R20 = MGPR.newMGPR("r20", 20, 4);
        public static final MGPR R21 = MGPR.newMGPR("r21", 21, 5);
        public static final MGPR R22 = MGPR.newMGPR("r22", 22, 6);
        public static final MGPR R23 = MGPR.newMGPR("r23", 23, 7);

        public int getEncodingValue() {
            return this.encoding;
        }

        private static MGPR newMGPR(String n, int v, int ev) {
            MGPR obj = new MGPR(n, v, ev);
            set.put(n, obj);
            return obj;
        }

        MGPR(String sym, int v, int ev) {
            super(sym, v);
            this.encoding = ev;
        }
    }

    public static class EGPR
    extends GPR {
        public final int encoding;
        private static HashMap set = new HashMap();
        public static final EGPR R0 = EGPR.newEGPR("r0", 0, 0);
        public static final EGPR R2 = EGPR.newEGPR("r2", 2, 1);
        public static final EGPR R4 = EGPR.newEGPR("r4", 4, 2);
        public static final EGPR R6 = EGPR.newEGPR("r6", 6, 3);
        public static final EGPR R8 = EGPR.newEGPR("r8", 8, 4);
        public static final EGPR R10 = EGPR.newEGPR("r10", 10, 5);
        public static final EGPR R12 = EGPR.newEGPR("r12", 12, 6);
        public static final EGPR R14 = EGPR.newEGPR("r14", 14, 7);
        public static final EGPR R16 = EGPR.newEGPR("r16", 16, 8);
        public static final EGPR R18 = EGPR.newEGPR("r18", 18, 9);
        public static final EGPR R20 = EGPR.newEGPR("r20", 20, 10);
        public static final EGPR R22 = EGPR.newEGPR("r22", 22, 11);
        public static final EGPR R24 = EGPR.newEGPR("r24", 24, 12);
        public static final EGPR R26 = EGPR.newEGPR("r26", 26, 13);
        public static final EGPR R28 = EGPR.newEGPR("r28", 28, 14);
        public static final EGPR R30 = EGPR.newEGPR("r30", 30, 15);

        public int getEncodingValue() {
            return this.encoding;
        }

        private static EGPR newEGPR(String n, int v, int ev) {
            EGPR obj = new EGPR(n, v, ev);
            set.put(n, obj);
            return obj;
        }

        EGPR(String sym, int v, int ev) {
            super(sym, v);
            this.encoding = ev;
        }
    }

    public static class HGPR
    extends GPR {
        public final int encoding;
        private static HashMap set = new HashMap();
        public static final HGPR R16 = HGPR.newHGPR("r16", 16, 0);
        public static final HGPR R17 = HGPR.newHGPR("r17", 17, 1);
        public static final HGPR R18 = HGPR.newHGPR("r18", 18, 2);
        public static final HGPR R19 = HGPR.newHGPR("r19", 19, 3);
        public static final HGPR R20 = HGPR.newHGPR("r20", 20, 4);
        public static final HGPR R21 = HGPR.newHGPR("r21", 21, 5);
        public static final HGPR R22 = HGPR.newHGPR("r22", 22, 6);
        public static final HGPR R23 = HGPR.newHGPR("r23", 23, 7);
        public static final HGPR R24 = HGPR.newHGPR("r24", 24, 8);
        public static final HGPR R25 = HGPR.newHGPR("r25", 25, 9);
        public static final HGPR R26 = HGPR.newHGPR("r26", 26, 10);
        public static final HGPR R27 = HGPR.newHGPR("r27", 27, 11);
        public static final HGPR R28 = HGPR.newHGPR("r28", 28, 12);
        public static final HGPR R29 = HGPR.newHGPR("r29", 29, 13);
        public static final HGPR R30 = HGPR.newHGPR("r30", 30, 14);
        public static final HGPR R31 = HGPR.newHGPR("r31", 31, 15);

        public int getEncodingValue() {
            return this.encoding;
        }

        private static HGPR newHGPR(String n, int v, int ev) {
            HGPR obj = new HGPR(n, v, ev);
            set.put(n, obj);
            return obj;
        }

        HGPR(String sym, int v, int ev) {
            super(sym, v);
            this.encoding = ev;
        }
    }

    public static class ADR
    extends AVRSymbol {
        private static HashMap set = new HashMap();
        public static final ADR X = ADR.newADR("X", 26);
        public static final ADR Y = ADR.newADR("Y", 28);
        public static final ADR Z = ADR.newADR("Z", 30);

        private static ADR newADR(String n, int v) {
            ADR obj = new ADR(n, v);
            set.put(n, obj);
            return obj;
        }

        ADR(String sym, int v) {
            super(sym, v);
        }
    }

    public static class GPR
    extends AVRSymbol {
        private static HashMap set = new HashMap();
        public static final GPR R0 = GPR.newGPR("r0", 0);
        public static final GPR R1 = GPR.newGPR("r1", 1);
        public static final GPR R2 = GPR.newGPR("r2", 2);
        public static final GPR R3 = GPR.newGPR("r3", 3);
        public static final GPR R4 = GPR.newGPR("r4", 4);
        public static final GPR R5 = GPR.newGPR("r5", 5);
        public static final GPR R6 = GPR.newGPR("r6", 6);
        public static final GPR R7 = GPR.newGPR("r7", 7);
        public static final GPR R8 = GPR.newGPR("r8", 8);
        public static final GPR R9 = GPR.newGPR("r9", 9);
        public static final GPR R10 = GPR.newGPR("r10", 10);
        public static final GPR R11 = GPR.newGPR("r11", 11);
        public static final GPR R12 = GPR.newGPR("r12", 12);
        public static final GPR R13 = GPR.newGPR("r13", 13);
        public static final GPR R14 = GPR.newGPR("r14", 14);
        public static final GPR R15 = GPR.newGPR("r15", 15);
        public static final GPR R16 = GPR.newGPR("r16", 16);
        public static final GPR R17 = GPR.newGPR("r17", 17);
        public static final GPR R18 = GPR.newGPR("r18", 18);
        public static final GPR R19 = GPR.newGPR("r19", 19);
        public static final GPR R20 = GPR.newGPR("r20", 20);
        public static final GPR R21 = GPR.newGPR("r21", 21);
        public static final GPR R22 = GPR.newGPR("r22", 22);
        public static final GPR R23 = GPR.newGPR("r23", 23);
        public static final GPR R24 = GPR.newGPR("r24", 24);
        public static final GPR R25 = GPR.newGPR("r25", 25);
        public static final GPR R26 = GPR.newGPR("r26", 26);
        public static final GPR R27 = GPR.newGPR("r27", 27);
        public static final GPR R28 = GPR.newGPR("r28", 28);
        public static final GPR R29 = GPR.newGPR("r29", 29);
        public static final GPR R30 = GPR.newGPR("r30", 30);
        public static final GPR R31 = GPR.newGPR("r31", 31);

        private static GPR newGPR(String n, int v) {
            GPR obj = new GPR(n, v);
            set.put(n, obj);
            return obj;
        }

        GPR(String sym, int v) {
            super(sym, v);
        }
    }
}

