/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import avrora.arch.avr.AVRDataSegment;
import avrora.arch.avr.AVRSymbol;
import avrora.sim.ActiveRegister;
import avrora.sim.CodeSegment;
import avrora.sim.InterruptTable;
import avrora.sim.Segment;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.clock.DeltaQueue;

public abstract class AVRState
implements State {
    public static int NUM_REGS = 32;
    protected Simulator simulator;
    protected InterruptTable interrupts;
    protected int pc;
    protected int nextpc;
    protected boolean I;
    protected boolean T;
    protected boolean H;
    protected boolean V;
    protected boolean S;
    protected boolean N;
    protected boolean Z;
    protected boolean C;
    protected AVRDataSegment sram;
    protected byte[] regs;
    protected CodeSegment flash;
    protected ActiveRegister[] ioregs;
    protected DeltaQueue queue;
    protected ActiveRegister SREG_reg;
    protected int SREG;
    protected int cycles;
    protected boolean justReturnedFromInterrupt;

    public int getPC() {
        return this.pc;
    }

    public abstract int getSP();

    public byte getSRAM(int address) {
        return this.sram.get(address);
    }

    public byte getFlash(int address) {
        return this.flash.get(address);
    }

    public byte getIOReg(int ior) {
        return this.ioregs[ior].read();
    }

    public byte getRegister(AVRSymbol.GPR reg) {
        return this.regs[reg.value];
    }

    public long getCycles() {
        return this.queue.getCount();
    }

    public byte getSREG() {
        return this.SREG_reg.read();
    }

    public boolean isEnabled(int inum) {
        return this.interrupts.isEnabled(inum);
    }

    public boolean isPosted(int inum) {
        return this.interrupts.isPosted(inum);
    }

    public boolean isPending(int inum) {
        return this.interrupts.isPending(inum);
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    protected static int map_get(byte[] a, int indx) {
        return a[indx];
    }

    protected static void map_set(byte[] a, int indx, int val) {
        a[indx] = (byte)val;
    }

    protected static int map_get(Segment s, int addr) {
        return s.read(addr);
    }

    protected static void map_set(Segment s, int addr, int val) {
        s.write(addr, (byte)val);
    }

    protected static int map_get(ActiveRegister[] s, int addr) {
        return s[addr].read();
    }

    protected static void map_set(ActiveRegister[] s, int addr, int val) {
        s[addr].write((byte)val);
    }
}

