/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import avrora.arch.avr.AVRInstrBuilder;
import avrora.arch.avr.AVROperandVisitor;
import avrora.arch.avr.AVRSymbol;

public abstract class AVROperand {
    public static final byte op_GPR_val = 1;
    public static final byte op_HGPR_val = 2;
    public static final byte op_MGPR_val = 3;
    public static final byte op_YZ_val = 4;
    public static final byte op_EGPR_val = 5;
    public static final byte op_RDL_val = 6;
    public static final byte IMM3_val = 7;
    public static final byte IMM5_val = 8;
    public static final byte IMM6_val = 9;
    public static final byte IMM7_val = 10;
    public static final byte IMM8_val = 11;
    public static final byte SREL_val = 12;
    public static final byte LREL_val = 13;
    public static final byte PADDR_val = 14;
    public static final byte DADDR_val = 15;
    public static final byte R0_B_val = 16;
    public static final byte RZ_W_val = 17;
    public static final byte AI_RZ_W_val = 18;
    public static final byte XYZ_val = 19;
    public static final byte AI_XYZ_val = 20;
    public static final byte PD_XYZ_val = 21;
    public final byte op_type;

    public abstract void accept(AVROperandVisitor var1);

    protected AVROperand(byte t) {
        this.op_type = t;
    }

    public static class PD_XYZ
    extends Sym {
        PD_XYZ(String s) {
            super((byte)21, AVRSymbol.get_ADR(s));
        }

        PD_XYZ(AVRSymbol.ADR sym) {
            super((byte)21, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class AI_XYZ
    extends Sym {
        AI_XYZ(String s) {
            super((byte)20, AVRSymbol.get_ADR(s));
        }

        AI_XYZ(AVRSymbol.ADR sym) {
            super((byte)20, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class XYZ
    extends Sym {
        XYZ(String s) {
            super((byte)19, AVRSymbol.get_ADR(s));
        }

        XYZ(AVRSymbol.ADR sym) {
            super((byte)19, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class AI_RZ_W
    extends Sym {
        AI_RZ_W(String s) {
            super((byte)18, AVRSymbol.get_RZ(s));
        }

        AI_RZ_W(AVRSymbol.RZ sym) {
            super((byte)18, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class RZ_W
    extends Sym {
        RZ_W(String s) {
            super((byte)17, AVRSymbol.get_RZ(s));
        }

        RZ_W(AVRSymbol.RZ sym) {
            super((byte)17, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class R0_B
    extends Sym {
        R0_B(String s) {
            super((byte)16, AVRSymbol.get_R0(s));
        }

        R0_B(AVRSymbol.R0 sym) {
            super((byte)16, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class DADDR
    extends Int {
        public static final int low = 0;
        public static final int high = 65536;

        DADDR(int val) {
            super((byte)15, AVRInstrBuilder.checkValue(val, 0, 65536));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class PADDR
    extends Int {
        public static final int low = 0;
        public static final int high = 65536;

        PADDR(int val) {
            super((byte)14, AVRInstrBuilder.checkValue(val, 0, 65536));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class LREL
    extends Int {
        public static final int low = -1024;
        public static final int high = 1023;

        LREL(int val) {
            super((byte)13, AVRInstrBuilder.checkValue(val, -1024, 1023));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class SREL
    extends Int {
        public static final int low = -64;
        public static final int high = 63;

        SREL(int val) {
            super((byte)12, AVRInstrBuilder.checkValue(val, -64, 63));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IMM8
    extends Int {
        public static final int low = 0;
        public static final int high = 255;

        IMM8(int val) {
            super((byte)11, AVRInstrBuilder.checkValue(val, 0, 255));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IMM7
    extends Int {
        public static final int low = 0;
        public static final int high = 127;

        IMM7(int val) {
            super((byte)10, AVRInstrBuilder.checkValue(val, 0, 127));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IMM6
    extends Int {
        public static final int low = 0;
        public static final int high = 63;

        IMM6(int val) {
            super((byte)9, AVRInstrBuilder.checkValue(val, 0, 63));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IMM5
    extends Int {
        public static final int low = 0;
        public static final int high = 31;

        IMM5(int val) {
            super((byte)8, AVRInstrBuilder.checkValue(val, 0, 31));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class IMM3
    extends Int {
        public static final int low = 0;
        public static final int high = 7;

        IMM3(int val) {
            super((byte)7, AVRInstrBuilder.checkValue(val, 0, 7));
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class op_RDL
    extends Sym {
        op_RDL(String s) {
            super((byte)6, AVRSymbol.get_RDL(s));
        }

        op_RDL(AVRSymbol.RDL sym) {
            super((byte)6, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class op_EGPR
    extends Sym {
        op_EGPR(String s) {
            super((byte)5, AVRSymbol.get_EGPR(s));
        }

        op_EGPR(AVRSymbol.EGPR sym) {
            super((byte)5, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class op_YZ
    extends Sym {
        op_YZ(String s) {
            super((byte)4, AVRSymbol.get_YZ(s));
        }

        op_YZ(AVRSymbol.YZ sym) {
            super((byte)4, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class op_MGPR
    extends Sym {
        op_MGPR(String s) {
            super((byte)3, AVRSymbol.get_MGPR(s));
        }

        op_MGPR(AVRSymbol.MGPR sym) {
            super((byte)3, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class op_HGPR
    extends Sym {
        op_HGPR(String s) {
            super((byte)2, AVRSymbol.get_HGPR(s));
        }

        op_HGPR(AVRSymbol.HGPR sym) {
            super((byte)2, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    public static class op_GPR
    extends Sym {
        op_GPR(String s) {
            super((byte)1, AVRSymbol.get_GPR(s));
        }

        op_GPR(AVRSymbol.GPR sym) {
            super((byte)1, sym);
        }

        public void accept(AVROperandVisitor v) {
            v.visit(this);
        }
    }

    static abstract class Rel
    extends AVROperand {
        public final int value;
        public final int relative;

        Rel(byte t, int addr, int rel) {
            super(t);
            this.value = addr;
            this.relative = rel;
        }

        public String toString() {
            if (this.relative >= 0) {
                return ".+" + this.relative;
            }
            return "." + this.relative;
        }
    }

    static abstract class Addr
    extends AVROperand {
        public final int value;

        Addr(byte t, int addr) {
            super(t);
            this.value = addr;
        }

        public String toString() {
            String hs = Integer.toHexString(this.value);
            StringBuffer buf = new StringBuffer("0x");
            for (int cntr = hs.length(); cntr < 4; ++cntr) {
                buf.append('0');
            }
            buf.append(hs);
            return buf.toString();
        }
    }

    static abstract class Sym
    extends AVROperand {
        public final AVRSymbol value;

        Sym(byte t, AVRSymbol sym) {
            super(t);
            if (sym == null) {
                throw new Error();
            }
            this.value = sym;
        }

        public String toString() {
            return this.value.symbol;
        }
    }

    static abstract class Int
    extends AVROperand {
        public final int value;

        Int(byte t, int val) {
            super(t);
            this.value = val;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

