/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import avrora.arch.AbstractInstr;
import avrora.arch.avr.AVRDataSegment;
import avrora.arch.avr.AVRInstr;
import avrora.arch.avr.AVRInstrInterpreter;
import avrora.arch.avr.AVRProperties;
import avrora.core.Program;
import avrora.sim.ActiveRegister;
import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.clock.MainClock;
import avrora.sim.mcu.RegisterSet;
import cck.util.Arithmetic;
import cck.util.Util;

public class AVRInterpreter
extends AVRInstrInterpreter {
    public static final int SREG_I = 7;
    public static final int SREG_T = 6;
    public static final int SREG_H = 5;
    public static final int SREG_S = 4;
    public static final int SREG_V = 3;
    public static final int SREG_N = 2;
    public static final int SREG_Z = 1;
    public static final int SREG_C = 0;
    private static final int SREG_I_MASK = 128;
    private static final int SREG_T_MASK = 64;
    private static final int SREG_H_MASK = 32;
    private static final int SREG_S_MASK = 16;
    private static final int SREG_V_MASK = 8;
    private static final int SREG_N_MASK = 4;
    private static final int SREG_Z_MASK = 2;
    private static final int SREG_C_MASK = 1;
    protected int RAMPZ;
    protected final MainClock clock;
    protected final RegisterSet registers;
    protected final AVRInstr[] shared_instr;
    protected final RWRegister SPL_reg;
    protected final RWRegister SPH_reg;
    protected boolean innerLoop;
    protected boolean shouldRun;
    protected boolean sleeping;

    public AVRInterpreter(Simulator simulator, Program p, AVRProperties pr) {
        Compiler.compileClass(this.getClass());
        this.simulator = simulator;
        this.clock = simulator.getClock();
        this.SREG = pr.getIOReg("SREG");
        this.RAMPZ = pr.hasIOReg("RAMPZ") ? pr.getIOReg("RAMPZ") : -1;
        if (p.program_end > pr.flash_size) {
            throw Util.failure("program will not fit into " + pr.flash_size + " bytes");
        }
        this.registers = simulator.getMicrocontroller().getRegisterSet();
        this.ioregs = this.registers.share();
        int sram_total = NUM_REGS + pr.ioreg_size + pr.sram_size;
        this.sram = new AVRDataSegment(sram_total, this.ioregs, this);
        this.regs = this.sram.exposeRegisters();
        this.SREG_reg = this.ioregs[this.SREG] = new SREG_reg();
        this.SPL_reg = (RWRegister)this.ioregs[pr.getIOReg("SPL")];
        this.SPH_reg = (RWRegister)this.ioregs[pr.getIOReg("SPH")];
        this.shared_instr = null;
    }

    public int getSP() {
        byte low = this.SPL_reg.value;
        byte high = this.SPH_reg.value;
        return Arithmetic.uword(low, high);
    }

    public AbstractInstr getInstr(int address) {
        throw Util.unimplemented();
    }

    protected void setSP(int val) {
        this.SPL_reg.value = Arithmetic.low(val);
        this.SPH_reg.value = Arithmetic.high(val);
    }

    protected int popByte() {
        int address = this.getSP() + 1;
        this.setSP(address);
        return this.sram.read(address);
    }

    protected void pushByte(int val) {
        int address = this.getSP();
        this.setSP(address - 1);
        this.sram.write(address, (byte)val);
    }

    protected int extended(int addr) {
        if (this.RAMPZ > 0) {
            return (this.ioregs[this.RAMPZ].read() & 1) << 16 | addr;
        }
        return addr;
    }

    protected void enableInterrupts() {
        this.I = true;
        this.interrupts.enableAll();
    }

    protected void disableInterrupts() {
        this.I = true;
        this.interrupts.disableAll();
    }

    protected void enterSleepMode() {
        this.sleeping = true;
        this.innerLoop = false;
        this.simulator.getMicrocontroller().sleep();
    }

    protected void storeProgramMemory() {
        this.flash.update();
    }

    protected void stop() {
        this.shouldRun = false;
        this.innerLoop = false;
    }

    protected void skip() {
        AVRInstr i = null;
        int size = i.getSize();
        this.cycles = size == 2 ? ++this.cycles : (this.cycles += 2);
        this.nextpc += size;
    }

    protected boolean getIORbit(int ior, int bit) {
        return Arithmetic.getBit(this.ioregs[ior].read(), bit);
    }

    protected void setIORbit(int ior, int bit, boolean v) {
        byte val = this.ioregs[ior].read();
        this.ioregs[ior].write(Arithmetic.setBit(val, bit, v));
    }

    private class SREG_reg
    implements ActiveRegister {
        private SREG_reg() {
        }

        public byte read() {
            int value = 0;
            if (AVRInterpreter.this.I) {
                value |= 0x80;
            }
            if (AVRInterpreter.this.T) {
                value |= 0x40;
            }
            if (AVRInterpreter.this.H) {
                value |= 0x20;
            }
            if (AVRInterpreter.this.S) {
                value |= 0x10;
            }
            if (AVRInterpreter.this.V) {
                value |= 8;
            }
            if (AVRInterpreter.this.N) {
                value |= 4;
            }
            if (AVRInterpreter.this.Z) {
                value |= 2;
            }
            if (AVRInterpreter.this.C) {
                value |= 1;
            }
            return (byte)value;
        }

        public void write(byte val) {
            if ((val & 0x80) != 0) {
                AVRInterpreter.this.enableInterrupts();
            } else {
                AVRInterpreter.this.disableInterrupts();
            }
            AVRInterpreter.this.T = (val & 0x40) != 0;
            AVRInterpreter.this.H = (val & 0x20) != 0;
            AVRInterpreter.this.S = (val & 0x10) != 0;
            AVRInterpreter.this.V = (val & 8) != 0;
            AVRInterpreter.this.N = (val & 4) != 0;
            AVRInterpreter.this.Z = (val & 2) != 0;
            AVRInterpreter.this.C = (val & 1) != 0;
        }
    }
}

