/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import avrora.arch.avr.AVRInstr;
import avrora.arch.avr.AVRInstrVisitor;
import avrora.arch.avr.AVROperand;
import avrora.arch.avr.AVRState;
import cck.util.Util;

public abstract class AVRInstrInterpreter
extends AVRState
implements AVRInstrVisitor {
    boolean bit_get(int v, int bit) {
        return (v & 1 << bit) != 0;
    }

    int bit_set(int v, int bit, boolean value) {
        if (value) {
            return v | 1 << bit;
        }
        return v & ~(1 << bit);
    }

    int bit_update(int v, int mask, int e) {
        return v & ~mask | e & mask;
    }

    int b2i(boolean v, int val) {
        if (v) {
            return val;
        }
        return 0;
    }

    int $read_poly_int8(AVROperand o) {
        switch (o.op_type) {
            case 16: {
                return this.$read_int8((AVROperand.R0_B)o);
            }
            case 1: {
                return this.$read_int8((AVROperand.op_GPR)o);
            }
        }
        throw Util.failure("invalid operand type in read");
    }

    int $read_poly_uint16(AVROperand o) {
        switch (o.op_type) {
            case 20: {
                return this.$read_uint16((AVROperand.AI_XYZ)o);
            }
            case 17: {
                return this.$read_uint16((AVROperand.RZ_W)o);
            }
            case 21: {
                return this.$read_uint16((AVROperand.PD_XYZ)o);
            }
            case 18: {
                return this.$read_uint16((AVROperand.AI_RZ_W)o);
            }
            case 19: {
                return this.$read_uint16((AVROperand.XYZ)o);
            }
        }
        throw Util.failure("invalid operand type in read");
    }

    void $write_poly_int8(AVROperand o, int value) {
        switch (o.op_type) {
            case 16: {
                this.$write_int8((AVROperand.R0_B)o, value);
                return;
            }
            case 1: {
                this.$write_int8((AVROperand.op_GPR)o, value);
                return;
            }
        }
        throw Util.failure("invalid operand type in write");
    }

    public int get_reg(int r) {
        return AVRInstrInterpreter.map_get(this.regs, r);
    }

    public int get_wreg(int r) {
        return this.uword(AVRInstrInterpreter.map_get(this.regs, r), AVRInstrInterpreter.map_get(this.regs, r + 1));
    }

    public void set_reg(int r, int v) {
        AVRInstrInterpreter.map_set(this.regs, r, v);
    }

    public void set_wreg(int r, int v) {
        AVRInstrInterpreter.map_set(this.regs, r, this.low(v));
        AVRInstrInterpreter.map_set(this.regs, r + 1, this.high(v));
    }

    protected abstract int popByte();

    protected abstract void pushByte(int var1);

    protected abstract int extended(int var1);

    protected abstract void enableInterrupts();

    protected abstract void disableInterrupts();

    protected abstract void enterSleepMode();

    protected abstract void storeProgramMemory();

    protected abstract void stop();

    protected abstract void skip();

    protected abstract boolean getIORbit(int var1, int var2);

    protected abstract void setIORbit(int var1, int var2, boolean var3);

    public int bit(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public int performAddition(int r1, int r2, int carry) {
        int result = r1 + r2 + carry;
        int ral = r1 & 0xF;
        int rbl = r2 & 0xF;
        boolean Rd7 = this.bit_get(r1, 7);
        boolean Rr7 = this.bit_get(r2, 7);
        boolean R7 = this.bit_get(result, 7);
        this.H = this.bit_get(ral + rbl + carry, 4);
        this.C = this.bit_get(result, 8);
        this.N = R7;
        this.Z = this.low(result) == 0;
        this.V = Rd7 && Rr7 && !R7 || !Rd7 && !Rr7 && R7;
        this.S = this.N != this.V;
        return this.low(result);
    }

    public int performSubtraction(int r1, int r2, int carry) {
        int result = r1 - r2 - carry;
        boolean Rd7 = this.bit_get(r1, 7);
        boolean Rr7 = this.bit_get(r2, 7);
        boolean R7 = this.bit_get(result, 7);
        boolean Rd3 = this.bit_get(r1, 3);
        boolean Rr3 = this.bit_get(r2, 3);
        boolean R3 = this.bit_get(result, 3);
        this.H = !Rd3 && Rr3 || Rr3 && R3 || R3 && !Rd3;
        this.C = !Rd7 && Rr7 || Rr7 && R7 || R7 && !Rd7;
        this.N = R7;
        this.Z = this.low(result) == 0;
        this.V = Rd7 && !Rr7 && !R7 || !Rd7 && Rr7 && R7;
        this.S = this.N != this.V;
        return this.low(result);
    }

    public int performSubtractionPZ(int r1, int r2, int carry) {
        int result = r1 - r2 - carry;
        boolean Rd7 = this.bit_get(r1, 7);
        boolean Rr7 = this.bit_get(r2, 7);
        boolean R7 = this.bit_get(result, 7);
        boolean Rd3 = this.bit_get(r1, 3);
        boolean Rr3 = this.bit_get(r2, 3);
        boolean R3 = this.bit_get(result, 3);
        this.H = !Rd3 && Rr3 || Rr3 && R3 || R3 && !Rd3;
        this.C = !Rd7 && Rr7 || Rr7 && R7 || R7 && !Rd7;
        this.N = R7;
        this.Z = this.low(result) == 0 && this.Z;
        this.V = Rd7 && !Rr7 && !R7 || !Rd7 && Rr7 && R7;
        this.S = this.N != this.V;
        return this.low(result);
    }

    public int performLeftShift(int r1, boolean lowbit) {
        int result = r1 << 1;
        result = this.bit_update(result, 1, this.b2i(lowbit, 1));
        this.H = this.bit_get(result, 4);
        this.C = this.bit_get(result, 8);
        this.N = this.bit_get(result, 7);
        this.Z = this.low(result) == 0;
        this.V = this.N != this.C;
        this.S = this.N != this.V;
        return this.low(result);
    }

    public int performRightShift(int r1, boolean highbit) {
        int result = (r1 & 0xFF) >> 1;
        result = this.bit_update(result, 128, this.b2i(highbit, 128));
        this.C = this.bit_get(r1, 0);
        this.N = highbit;
        this.Z = this.low(result) == 0;
        this.V = this.N != this.C;
        this.S = this.N != this.V;
        return this.low(result);
    }

    public int performOr(int r1, int r2) {
        int result = r1 | r2;
        this.N = this.bit_get(result, 7);
        this.Z = this.low(result) == 0;
        this.V = false;
        this.S = this.N != this.V;
        return this.low(result);
    }

    public int performAnd(int r1, int r2) {
        int result = r1 & r2;
        this.N = this.bit_get(result, 7);
        this.Z = this.low(result) == 0;
        this.V = false;
        this.S = this.N != this.V;
        return this.low(result);
    }

    public void relativeBranch(AVROperand.SREL target) {
        this.nextpc = this.relative(target.value);
        ++this.cycles;
    }

    public int relative(int target) {
        return target * 2 + this.nextpc;
    }

    public int absolute(int target) {
        return target * 2;
    }

    public void pushPC(int npc) {
        this.pushByte(this.low(npc /= 2));
        this.pushByte(this.high(npc));
    }

    public int popPC() {
        int high = this.popByte();
        int low = this.popByte();
        return this.uword(low, high) * 2;
    }

    public int low(int v) {
        return v << 24 >> 24;
    }

    public int high(int v) {
        return v >> 8 << 24 >> 24;
    }

    public int uword(int low, int high) {
        return (high << 8 | low) & 0xFFFF;
    }

    public int $read_int8(AVROperand.op_GPR _this) {
        return this.get_reg(_this.value.value);
    }

    public void $write_int8(AVROperand.op_GPR _this, int value) {
        this.set_reg(_this.value.value, value);
    }

    public int $read_int8(AVROperand.op_HGPR _this) {
        return this.get_reg(_this.value.value);
    }

    public void $write_int8(AVROperand.op_HGPR _this, int value) {
        this.set_reg(_this.value.value, value);
    }

    public int $read_int8(AVROperand.op_MGPR _this) {
        return this.get_reg(_this.value.value);
    }

    public void $write_int8(AVROperand.op_MGPR _this, int value) {
        this.set_reg(_this.value.value, value);
    }

    public int $read_uint16(AVROperand.op_YZ _this) {
        return this.get_wreg(_this.value.value);
    }

    public void $write_uint16(AVROperand.op_YZ _this, int value) {
        this.set_wreg(_this.value.value, value);
    }

    public int $read_uint16(AVROperand.op_EGPR _this) {
        return this.get_wreg(_this.value.value);
    }

    public void $write_uint16(AVROperand.op_EGPR _this, int value) {
        this.set_wreg(_this.value.value, value);
    }

    public int $read_uint16(AVROperand.op_RDL _this) {
        return this.get_wreg(_this.value.value);
    }

    public void $write_uint16(AVROperand.op_RDL _this, int value) {
        this.set_wreg(_this.value.value, value);
    }

    public int $read_int8(AVROperand.R0_B _this) {
        return this.get_reg(0);
    }

    public void $write_int8(AVROperand.R0_B _this, int value) {
        this.set_reg(0, value);
    }

    public int $read_uint16(AVROperand.RZ_W _this) {
        return this.get_wreg(30);
    }

    public int $read_uint16(AVROperand.AI_RZ_W _this) {
        int temp = this.get_wreg(30);
        this.set_wreg(30, temp + 1);
        return temp;
    }

    public int $read_uint16(AVROperand.XYZ _this) {
        return this.get_wreg(_this.value.value);
    }

    public int $read_uint16(AVROperand.AI_XYZ _this) {
        int tmp = this.get_wreg(_this.value.value);
        this.set_wreg(_this.value.value, tmp + 1);
        return tmp;
    }

    public int $read_uint16(AVROperand.PD_XYZ _this) {
        int tmp = this.get_wreg(_this.value.value) - 1 & 0xFFFF;
        this.set_wreg(_this.value.value, tmp);
        return tmp;
    }

    public void visit(AVRInstr.ADC i) {
        this.$write_int8(i.rd, this.performAddition(this.$read_int8(i.rd) & 0xFF, this.$read_int8(i.rr) & 0xFF, this.bit(this.C)));
    }

    public void visit(AVRInstr.ADD i) {
        this.$write_int8(i.rd, this.performAddition(this.$read_int8(i.rd) & 0xFF, this.$read_int8(i.rr) & 0xFF, 0));
    }

    public void visit(AVRInstr.ADIW i) {
        int r1 = this.$read_uint16(i.rd);
        int result = r1 + i.imm.value;
        boolean R15 = this.bit_get(result, 15);
        boolean Rdh7 = this.bit_get(r1, 15);
        this.C = !R15 && Rdh7;
        this.N = R15;
        this.V = !Rdh7 && R15;
        this.Z = (result & 0xFFFF) == 0;
        this.S = this.N != this.V;
        this.$write_uint16(i.rd, result);
    }

    public void visit(AVRInstr.AND i) {
        this.$write_int8(i.rd, this.performAnd(this.$read_int8(i.rd), this.$read_int8(i.rr)));
    }

    public void visit(AVRInstr.ANDI i) {
        this.$write_int8(i.rd, this.performAnd(this.$read_int8(i.rd), i.imm.value));
    }

    public void visit(AVRInstr.ASR i) {
        int r1 = this.$read_int8(i.rd);
        this.$write_int8(i.rd, this.performRightShift(r1, this.bit_get(r1, 7)));
    }

    public void visit(AVRInstr.BCLR i) {
        this.setIORbit(this.SREG, i.bit.value, false);
    }

    public void visit(AVRInstr.BLD i) {
        int val = this.$read_int8(i.rr);
        val = this.bit_set(val, i.bit.value, this.T);
        this.$write_int8(i.rr, val);
    }

    public void visit(AVRInstr.BRBC i) {
        if (!this.getIORbit(this.SREG, i.bit.value)) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRBS i) {
        if (this.getIORbit(this.SREG, i.bit.value)) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRCC i) {
        if (!this.C) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRCS i) {
        if (this.C) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BREAK i) {
        this.stop();
    }

    public void visit(AVRInstr.BREQ i) {
        if (this.Z) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRGE i) {
        if (!this.S) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRHC i) {
        if (!this.H) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRHS i) {
        if (this.H) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRID i) {
        if (!this.I) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRIE i) {
        if (this.I) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRLO i) {
        if (this.C) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRLT i) {
        if (this.S) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRMI i) {
        if (this.N) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRNE i) {
        if (!this.Z) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRPL i) {
        if (!this.N) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRSH i) {
        if (!this.C) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRTC i) {
        if (!this.T) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRTS i) {
        if (this.T) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRVC i) {
        if (!this.V) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BRVS i) {
        if (this.V) {
            this.relativeBranch(i.target);
        }
    }

    public void visit(AVRInstr.BSET i) {
        this.setIORbit(this.SREG, i.bit.value, true);
    }

    public void visit(AVRInstr.BST i) {
        this.T = this.bit_get(this.$read_int8(i.rr), i.bit.value);
    }

    public void visit(AVRInstr.CALL i) {
        this.pushPC(this.nextpc);
        this.nextpc = this.absolute(i.target.value);
    }

    public void visit(AVRInstr.CBI i) {
        this.setIORbit(i.ior.value, i.bit.value, false);
    }

    public void visit(AVRInstr.CBR i) {
        this.$write_int8(i.rd, this.performAnd(this.$read_int8(i.rd), ~i.imm.value));
    }

    public void visit(AVRInstr.CLC i) {
        this.C = false;
    }

    public void visit(AVRInstr.CLH i) {
        this.H = false;
    }

    public void visit(AVRInstr.CLI i) {
        this.disableInterrupts();
    }

    public void visit(AVRInstr.CLN i) {
        this.N = false;
    }

    public void visit(AVRInstr.CLR i) {
        this.S = false;
        this.V = false;
        this.N = false;
        this.Z = true;
        this.$write_int8(i.rd, this.low(0));
    }

    public void visit(AVRInstr.CLS i) {
        this.S = false;
    }

    public void visit(AVRInstr.CLT i) {
        this.T = false;
    }

    public void visit(AVRInstr.CLV i) {
        this.V = false;
    }

    public void visit(AVRInstr.CLZ i) {
        this.Z = false;
    }

    public void visit(AVRInstr.COM i) {
        int result = 255 - this.$read_int8(i.rd);
        this.C = true;
        this.N = this.bit_get(result, 7);
        this.Z = this.low(result) == 0;
        this.V = false;
        this.S = this.N != this.V;
        this.$write_int8(i.rd, this.low(result));
    }

    public void visit(AVRInstr.CP i) {
        this.performSubtraction(this.$read_int8(i.rd), this.$read_int8(i.rr), 0);
    }

    public void visit(AVRInstr.CPC i) {
        this.performSubtractionPZ(this.$read_int8(i.rd), this.$read_int8(i.rr), this.bit(this.C));
    }

    public void visit(AVRInstr.CPI i) {
        this.performSubtraction(this.$read_int8(i.rd), i.imm.value, 0);
    }

    public void visit(AVRInstr.CPSE i) {
        int r1 = this.$read_int8(i.rd);
        int r2 = this.$read_int8(i.rr);
        this.performSubtraction(r1, r2, 0);
        if (r1 == r2) {
            this.skip();
        }
    }

    public void visit(AVRInstr.DEC i) {
        int r1 = this.$read_int8(i.rd) & 0xFF;
        int result = this.low(r1 - 1);
        this.N = this.bit_get(result, 7);
        this.Z = result == 0;
        this.V = r1 == 128;
        this.S = this.N != this.V;
        this.$write_int8(i.rd, result);
    }

    public void visit(AVRInstr.EICALL i) {
    }

    public void visit(AVRInstr.EIJMP i) {
    }

    public void visit(AVRInstr.EOR i) {
        int result = this.$read_int8(i.rd) ^ this.$read_int8(i.rr);
        this.N = this.bit_get(result, 7);
        this.Z = result == 0;
        this.V = false;
        this.S = this.N != this.V;
        this.$write_int8(i.rd, result);
    }

    public void visit(AVRInstr.FMUL i) {
        int result = (this.$read_int8(i.rd) & 0xFF) * (this.$read_int8(i.rr) & 0xFF) << 1;
        this.Z = (result & 0xFFFF) == 0;
        this.C = this.bit_get(result, 16);
        this.set_wreg(0, result);
    }

    public void visit(AVRInstr.FMULS i) {
        int result = this.$read_int8(i.rd) * this.$read_int8(i.rr) << 1;
        this.Z = (result & 0xFFFF) == 0;
        this.C = this.bit_get(result, 16);
        this.set_wreg(0, result);
    }

    public void visit(AVRInstr.FMULSU i) {
        int result = this.$read_int8(i.rd) * (this.$read_int8(i.rr) & 0xFF) << 1;
        this.Z = (result & 0xFFFF) == 0;
        this.C = this.bit_get(result, 16);
        this.set_wreg(0, result);
    }

    public void visit(AVRInstr.ICALL i) {
        this.pushPC(this.nextpc);
        this.nextpc = this.absolute(this.get_wreg(30));
    }

    public void visit(AVRInstr.IJMP i) {
        this.nextpc = this.absolute(this.get_wreg(30));
    }

    public void visit(AVRInstr.IN i) {
        this.$write_int8(i.rd, AVRInstrInterpreter.map_get(this.ioregs, i.imm.value));
    }

    public void visit(AVRInstr.INC i) {
        int r1 = this.$read_int8(i.rd) & 0xFF;
        int result = this.low(r1 + 1);
        this.N = this.bit_get(result, 7);
        this.Z = result == 0;
        this.V = r1 == 127;
        this.S = this.N != this.V;
        this.$write_int8(i.rd, result);
    }

    public void visit(AVRInstr.JMP i) {
        this.nextpc = this.absolute(i.target.value);
    }

    public void visit(AVRInstr.LDD i) {
        this.$write_int8(i.rd, AVRInstrInterpreter.map_get(this.sram, this.$read_uint16(i.ar) + i.imm.value));
    }

    public void visit(AVRInstr.LDI i) {
        this.$write_int8(i.rd, i.imm.value);
    }

    public void visit(AVRInstr.LDS i) {
        this.$write_int8(i.rd, AVRInstrInterpreter.map_get(this.sram, i.addr.value));
    }

    public void visit(AVRInstr.LSL i) {
        this.$write_int8(i.rd, this.performLeftShift(this.$read_int8(i.rd), false));
    }

    public void visit(AVRInstr.LSR i) {
        this.$write_int8(i.rd, this.performRightShift(this.$read_int8(i.rd), false));
    }

    public void visit(AVRInstr.MOV i) {
        this.$write_int8(i.rd, this.$read_int8(i.rr));
    }

    public void visit(AVRInstr.MOVW i) {
        this.$write_uint16(i.rd, this.$read_uint16(i.rr));
    }

    public void visit(AVRInstr.MUL i) {
        int result = (this.$read_int8(i.rd) & 0xFF) * (this.$read_int8(i.rr) & 0xFF);
        this.C = this.bit_get(result, 15);
        this.Z = (result & 0xFFFF) == 0;
        this.set_wreg(0, result);
    }

    public void visit(AVRInstr.MULS i) {
        int result = this.$read_int8(i.rd) * this.$read_int8(i.rr);
        this.C = this.bit_get(result, 15);
        this.Z = (result & 0xFFFF) == 0;
        this.set_wreg(0, result);
    }

    public void visit(AVRInstr.MULSU i) {
        int result = this.$read_int8(i.rd) * (this.$read_int8(i.rr) & 0xFF);
        this.C = this.bit_get(result, 15);
        this.Z = (result & 0xFFFF) == 0;
        this.set_wreg(0, result);
    }

    public void visit(AVRInstr.NEG i) {
        this.$write_int8(i.rd, this.performSubtraction(0, this.$read_int8(i.rd), 0));
    }

    public void visit(AVRInstr.NOP i) {
    }

    public void visit(AVRInstr.OR i) {
        this.$write_int8(i.rd, this.performOr(this.$read_int8(i.rd), this.$read_int8(i.rr)));
    }

    public void visit(AVRInstr.ORI i) {
        this.$write_int8(i.rd, this.performOr(this.$read_int8(i.rd), i.imm.value));
    }

    public void visit(AVRInstr.OUT i) {
        AVRInstrInterpreter.map_set(this.ioregs, i.ior.value, this.$read_int8(i.rr));
    }

    public void visit(AVRInstr.POP i) {
        this.$write_int8(i.rd, this.popByte());
    }

    public void visit(AVRInstr.PUSH i) {
        this.pushByte(this.$read_int8(i.rd));
    }

    public void visit(AVRInstr.RCALL i) {
        this.pushPC(this.nextpc);
        this.nextpc = this.relative(i.target.value);
    }

    public void visit(AVRInstr.RET i) {
        this.nextpc = this.popPC();
    }

    public void visit(AVRInstr.RETI i) {
        this.nextpc = this.popPC();
        this.enableInterrupts();
        this.justReturnedFromInterrupt = true;
    }

    public void visit(AVRInstr.RJMP i) {
        this.nextpc = this.relative(i.target.value);
    }

    public void visit(AVRInstr.ROL i) {
        this.$write_int8(i.rd, this.performLeftShift(this.$read_int8(i.rd) & 0xFF, this.C));
    }

    public void visit(AVRInstr.ROR i) {
        this.$write_int8(i.rd, this.performRightShift(this.$read_int8(i.rd), this.C));
    }

    public void visit(AVRInstr.SBC i) {
        this.$write_int8(i.rd, this.performSubtractionPZ(this.$read_int8(i.rd), this.$read_int8(i.rr), this.bit(this.C)));
    }

    public void visit(AVRInstr.SBCI i) {
        this.$write_int8(i.rd, this.performSubtractionPZ(this.$read_int8(i.rd), i.imm.value, this.bit(this.C)));
    }

    public void visit(AVRInstr.SBI i) {
        this.setIORbit(i.ior.value, i.bit.value, true);
    }

    public void visit(AVRInstr.SBIC i) {
        if (!this.getIORbit(i.ior.value, i.bit.value)) {
            this.skip();
        }
    }

    public void visit(AVRInstr.SBIS i) {
        if (this.getIORbit(i.ior.value, i.bit.value)) {
            this.skip();
        }
    }

    public void visit(AVRInstr.SBIW i) {
        int val = this.$read_uint16(i.rd);
        int result = val - i.imm.value;
        boolean Rdh7 = this.bit_get(val, 15);
        boolean R15 = this.bit_get(result, 15);
        this.V = Rdh7 && !R15;
        this.N = R15;
        this.Z = (result & 0xFFFF) == 0;
        this.C = R15 && !Rdh7;
        this.S = this.N != this.V;
        this.$write_uint16(i.rd, result);
    }

    public void visit(AVRInstr.SBR i) {
        this.$write_int8(i.rd, this.performOr(this.$read_int8(i.rd), i.imm.value));
    }

    public void visit(AVRInstr.SBRC i) {
        if (!this.bit_get(this.$read_int8(i.rr), i.bit.value)) {
            this.skip();
        }
    }

    public void visit(AVRInstr.SBRS i) {
        if (this.bit_get(this.$read_int8(i.rr), i.bit.value)) {
            this.skip();
        }
    }

    public void visit(AVRInstr.SEC i) {
        this.C = true;
    }

    public void visit(AVRInstr.SEH i) {
        this.H = true;
    }

    public void visit(AVRInstr.SEI i) {
        this.enableInterrupts();
    }

    public void visit(AVRInstr.SEN i) {
        this.N = true;
    }

    public void visit(AVRInstr.SER i) {
        this.$write_int8(i.rd, this.low(255));
    }

    public void visit(AVRInstr.SES i) {
        this.S = true;
    }

    public void visit(AVRInstr.SET i) {
        this.T = true;
    }

    public void visit(AVRInstr.SEV i) {
        this.V = true;
    }

    public void visit(AVRInstr.SEZ i) {
        this.Z = true;
    }

    public void visit(AVRInstr.SLEEP i) {
        this.enterSleepMode();
    }

    public void visit(AVRInstr.SPM i) {
        this.storeProgramMemory();
    }

    public void visit(AVRInstr.STD i) {
        AVRInstrInterpreter.map_set(this.sram, this.$read_uint16(i.ar) + i.imm.value, this.$read_int8(i.rr));
    }

    public void visit(AVRInstr.STS i) {
        AVRInstrInterpreter.map_set(this.sram, i.addr.value, this.$read_int8(i.rr));
    }

    public void visit(AVRInstr.SUB i) {
        this.$write_int8(i.rd, this.performSubtraction(this.$read_int8(i.rd), this.$read_int8(i.rr), 0));
    }

    public void visit(AVRInstr.SUBI i) {
        this.$write_int8(i.rd, this.performSubtraction(this.$read_int8(i.rd), i.imm.value, 0));
    }

    public void visit(AVRInstr.SWAP i) {
        int val = this.$read_int8(i.rd) & 0xFF;
        int result = 0;
        result = this.bit_update(result, 15, val << 4 & 0xF);
        result = this.bit_update(result, 240, val >> 4 & 0xF0);
        this.$write_int8(i.rd, this.low(result));
    }

    public void visit(AVRInstr.TST i) {
        int r1 = this.$read_int8(i.rd);
        this.V = false;
        this.Z = this.low(r1) == 0;
        this.N = this.bit_get(r1, 7);
        this.S = this.N != this.V;
    }

    public void visit(AVRInstr.WDR i) {
    }

    public void visit(AVRInstr.ELPM i) {
        int addr = this.extended(this.$read_poly_uint16(i.source));
        this.$write_poly_int8(i.dest, AVRInstrInterpreter.map_get(this.flash, addr));
    }

    public void visit(AVRInstr.LPM i) {
        int addr = this.$read_poly_uint16(i.source);
        this.$write_poly_int8(i.dest, AVRInstrInterpreter.map_get(this.flash, addr));
    }

    public void visit(AVRInstr.LD i) {
        int addr = this.$read_poly_uint16(i.ar);
        this.$write_poly_int8(i.rd, AVRInstrInterpreter.map_get(this.sram, addr));
    }

    public void visit(AVRInstr.ST i) {
        int addr = this.$read_poly_uint16(i.ar);
        int val = this.$read_poly_int8(i.rd);
        AVRInstrInterpreter.map_set(this.sram, addr, val);
    }
}

