/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import avrora.arch.AbstractDisassembler;
import avrora.arch.AbstractInstr;
import avrora.arch.avr.AVRAddrMode;
import avrora.arch.avr.AVRDisassembler$;
import avrora.arch.avr.AVRInstr;
import avrora.arch.avr.AVRInstrBuilder;
import avrora.arch.avr.AVROperand;
import avrora.arch.avr.AVRSymbol;
import java.util.Arrays;

public class AVRDisassembler
implements AbstractDisassembler {
    static final AVRSymbol.GPR[] GPR_table = new AVRSymbol.GPR[]{AVRSymbol.GPR.R0, AVRSymbol.GPR.R1, AVRSymbol.GPR.R2, AVRSymbol.GPR.R3, AVRSymbol.GPR.R4, AVRSymbol.GPR.R5, AVRSymbol.GPR.R6, AVRSymbol.GPR.R7, AVRSymbol.GPR.R8, AVRSymbol.GPR.R9, AVRSymbol.GPR.R10, AVRSymbol.GPR.R11, AVRSymbol.GPR.R12, AVRSymbol.GPR.R13, AVRSymbol.GPR.R14, AVRSymbol.GPR.R15, AVRSymbol.GPR.R16, AVRSymbol.GPR.R17, AVRSymbol.GPR.R18, AVRSymbol.GPR.R19, AVRSymbol.GPR.R20, AVRSymbol.GPR.R21, AVRSymbol.GPR.R22, AVRSymbol.GPR.R23, AVRSymbol.GPR.R24, AVRSymbol.GPR.R25, AVRSymbol.GPR.R26, AVRSymbol.GPR.R27, AVRSymbol.GPR.R28, AVRSymbol.GPR.R29, AVRSymbol.GPR.R30, AVRSymbol.GPR.R31};
    static final AVRSymbol.ADR[] ADR_table = new AVRSymbol.ADR[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, AVRSymbol.ADR.X, null, AVRSymbol.ADR.Y, null, AVRSymbol.ADR.Z};
    static final AVRSymbol.HGPR[] HGPR_table = new AVRSymbol.HGPR[]{AVRSymbol.HGPR.R16, AVRSymbol.HGPR.R17, AVRSymbol.HGPR.R18, AVRSymbol.HGPR.R19, AVRSymbol.HGPR.R20, AVRSymbol.HGPR.R21, AVRSymbol.HGPR.R22, AVRSymbol.HGPR.R23, AVRSymbol.HGPR.R24, AVRSymbol.HGPR.R25, AVRSymbol.HGPR.R26, AVRSymbol.HGPR.R27, AVRSymbol.HGPR.R28, AVRSymbol.HGPR.R29, AVRSymbol.HGPR.R30, AVRSymbol.HGPR.R31};
    static final AVRSymbol.EGPR[] EGPR_table = new AVRSymbol.EGPR[]{AVRSymbol.EGPR.R0, AVRSymbol.EGPR.R2, AVRSymbol.EGPR.R4, AVRSymbol.EGPR.R6, AVRSymbol.EGPR.R8, AVRSymbol.EGPR.R10, AVRSymbol.EGPR.R12, AVRSymbol.EGPR.R14, AVRSymbol.EGPR.R16, AVRSymbol.EGPR.R18, AVRSymbol.EGPR.R20, AVRSymbol.EGPR.R22, AVRSymbol.EGPR.R24, AVRSymbol.EGPR.R26, AVRSymbol.EGPR.R28, AVRSymbol.EGPR.R30};
    static final AVRSymbol.MGPR[] MGPR_table = new AVRSymbol.MGPR[]{AVRSymbol.MGPR.R16, AVRSymbol.MGPR.R17, AVRSymbol.MGPR.R18, AVRSymbol.MGPR.R19, AVRSymbol.MGPR.R20, AVRSymbol.MGPR.R21, AVRSymbol.MGPR.R22, AVRSymbol.MGPR.R23};
    static final AVRSymbol.YZ[] YZ_table = new AVRSymbol.YZ[]{AVRSymbol.YZ.Z, AVRSymbol.YZ.Y};
    static final AVRSymbol.RDL[] RDL_table = new AVRSymbol.RDL[]{AVRSymbol.RDL.R24, AVRSymbol.RDL.R26, AVRSymbol.RDL.R28, AVRSymbol.RDL.R30};
    static final AVRSymbol.R0[] R0_table = new AVRSymbol.R0[]{AVRSymbol.R0.R0};
    static final AVRSymbol.RZ[] RZ_table = new AVRSymbol.RZ[]{AVRSymbol.RZ.Z};
    public static final DTErrorTerm ERROR = new DTErrorTerm();
    private int size;
    private AVRInstrBuilder builder;
    private AVRAddrMode addrMode;
    private int state;
    private int pc;
    private static final int MOVE = 0;
    private static final int OK = 1;
    private static final int ERR = -1;
    private int word0;
    private int word1;
    private static final DTNode root1 = AVRDisassembler.make_root1();
    private static final DTNode root0 = AVRDisassembler.make_root0();

    static int readop_14(AVRDisassembler d) {
        int result = d.word0 >>> 4 & 3;
        return result;
    }

    static int readop_11(AVRDisassembler d) {
        int result = d.word0 >>> 4 & 0xF;
        return result;
    }

    static int readop_17(AVRDisassembler d) {
        int result = d.word1 & 0xFFFF;
        return result;
    }

    static int readop_13(AVRDisassembler d) {
        int result = d.word0 & 0xF;
        return result |= (d.word0 >>> 9 & 1) << 4;
    }

    static int readop_12(AVRDisassembler d) {
        int result = d.word0 & 0xF;
        return result;
    }

    static int readop_10(AVRDisassembler d) {
        int result = d.word0 >>> 3 & 0x7F;
        return result;
    }

    static int readop_3(AVRDisassembler d) {
        int result = d.word0 & 7;
        result |= (d.word0 >>> 10 & 3) << 3;
        return result |= (d.word0 >>> 13 & 1) << 5;
    }

    static int readop_18(AVRDisassembler d) {
        int result = d.word0 & 0xF;
        return result |= (d.word0 >>> 8 & 0xF) << 4;
    }

    static int readop_7(AVRDisassembler d) {
        int result = d.word0 >>> 4 & 0xF;
        return result |= (d.word0 >>> 8 & 1) << 4;
    }

    static int readop_16(AVRDisassembler d) {
        int result = d.word0 & 0xF;
        return result |= (d.word0 >>> 9 & 3) << 4;
    }

    static int readop_2(AVRDisassembler d) {
        int result = d.word0 >>> 3 & 1;
        return result;
    }

    static int readop_6(AVRDisassembler d) {
        int result = d.word0 >>> 4 & 7;
        return result;
    }

    static int readop_5(AVRDisassembler d) {
        int result = d.word0 & 7;
        return result;
    }

    static int readop_0(AVRDisassembler d) {
        int result = d.word0 >>> 4 & 0x1F;
        return result;
    }

    static int readop_15(AVRDisassembler d) {
        int result = d.word0 & 0xF;
        return result |= (d.word0 >>> 6 & 3) << 4;
    }

    static int readop_4(AVRDisassembler d) {
        int result = d.word0 & 1;
        return result |= (d.word1 >>> -15 & Short.MAX_VALUE) << 1;
    }

    static int readop_8(AVRDisassembler d) {
        int result = d.word0 >>> 3 & 0x1F;
        return result;
    }

    static int readop_1(AVRDisassembler d) {
        int result = d.word0 >>> 1 & 0x7FF;
        return result;
    }

    static int readop_9(AVRDisassembler d) {
        return 0;
    }

    private static int signExtend(int val, int size) {
        int shift = 32 - size;
        return val << shift >> shift;
    }

    static DTNode make_root1() {
        DTTerminal T1 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.STD, new $std$_0_reader()));
        DTTerminal T2 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LDD, new $ldd$_0_reader()));
        DTArrayNode N3 = new DTArrayNode(null, 9, 1, new DTNode[]{T2, T1});
        DTArrayNode N4 = new DTArrayNode(null, 12, 1, new DTNode[]{N3, ERROR});
        DTArrayNode N0 = new DTArrayNode(null, 14, 3, new DTNode[]{ERROR, ERROR, N4, ERROR});
        return N0;
    }

    static DTNode make_root0() {
        DTTerminal T1 = new DTTerminal(null);
        DTArrayNode N2 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.BST, new $bst$_0_reader()), 3, 1, new DTNode[]{T1, root1});
        DTArrayNode N3 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.BLD, new $bld$_0_reader()), 3, 1, new DTNode[]{T1, root1});
        DTArrayNode N4 = new DTArrayNode(null, 9, 1, new DTNode[]{N3, N2});
        DTTerminal T5 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRPL, new BRANCH_0_reader()));
        DTTerminal T6 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRGE, new BRANCH_0_reader()));
        DTTerminal T7 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRTC, new BRANCH_0_reader()));
        DTTerminal T8 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRNE, new BRANCH_0_reader()));
        DTTerminal T9 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRVC, new BRANCH_0_reader()));
        DTTerminal T10 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRID, new BRANCH_0_reader()));
        DTTerminal T11 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRHC, new BRANCH_0_reader()));
        DTTerminal T12 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRCC, new BRANCH_0_reader()));
        DTArrayNode N13 = new DTArrayNode(null, 0, 7, new DTNode[]{T12, T8, T5, T9, T6, T11, T7, T10});
        DTArrayNode N14 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SBRS, new $sbrs$_0_reader()), 3, 1, new DTNode[]{T1, root1});
        DTArrayNode N15 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SBRC, new $sbrc$_0_reader()), 3, 1, new DTNode[]{T1, root1});
        DTArrayNode N16 = new DTArrayNode(null, 9, 1, new DTNode[]{N15, N14});
        DTTerminal T17 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRMI, new BRANCH_0_reader()));
        DTTerminal T18 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRLT, new BRANCH_0_reader()));
        DTTerminal T19 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRTS, new BRANCH_0_reader()));
        DTTerminal T20 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BREQ, new BRANCH_0_reader()));
        DTTerminal T21 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRVS, new BRANCH_0_reader()));
        DTTerminal T22 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRIE, new BRANCH_0_reader()));
        DTTerminal T23 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRHS, new BRANCH_0_reader()));
        DTTerminal T24 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.BRCS, new BRANCH_0_reader()));
        DTArrayNode N25 = new DTArrayNode(null, 0, 7, new DTNode[]{T24, T20, T17, T21, T18, T23, T19, T22});
        DTArrayNode N26 = new DTArrayNode(null, 10, 3, new DTNode[]{N25, N13, N4, N16});
        DTTerminal T27 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SBCI, new HGPRIMM8_0_reader()));
        DTTerminal T28 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_XYZ_1_reader()));
        DTTerminal T29 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_XYZ_2_reader()));
        DTArrayNode N30 = new DTArrayNode(null, 0, 15, new DTNode[]{T29, root1, root1, root1, root1, root1, root1, root1, T28, root1, root1, root1, root1, root1, root1, root1});
        DTTerminal T31 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_XYZ_1_reader()));
        DTTerminal T32 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_XYZ_2_reader()));
        DTArrayNode N33 = new DTArrayNode(null, 0, 15, new DTNode[]{T32, root1, root1, root1, root1, root1, root1, root1, T31, root1, root1, root1, root1, root1, root1, root1});
        DTArrayNode N34 = new DTArrayNode(null, 9, 7, new DTNode[]{N33, N30, root1, root1, root1, root1, root1, root1});
        DTTerminal T35 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.OUT, new $out$_0_reader()));
        DTTerminal T36 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.IN, new $in$_0_reader()));
        DTArrayNode N37 = new DTArrayNode(null, 11, 1, new DTNode[]{T36, T35});
        DTTerminal T38 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.CPI, new HGPRIMM8_0_reader()));
        DTTerminal T39 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ANDI, new HGPRIMM8_0_reader()));
        DTTerminal T40 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.RJMP, new $rjmp$_0_reader()));
        DTTerminal T41 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.OR, new GPRGPR_0_reader()));
        DTTerminal T42 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.EOR, new GPRGPR_0_reader()));
        DTTerminal T43 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.MOV, new GPRGPR_0_reader()));
        DTTerminal T44 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.AND, new GPRGPR_0_reader()));
        DTArrayNode N45 = new DTArrayNode(null, 10, 3, new DTNode[]{T44, T42, T41, T43});
        DTTerminal T46 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.RCALL, new $rcall$_0_reader()));
        DTTerminal T47 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SBI, new $sbi$_0_reader()));
        DTTerminal T48 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SBIC, new $sbic$_0_reader()));
        DTTerminal T49 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SBIS, new $sbis$_0_reader()));
        DTTerminal T50 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.CBI, new $cbi$_0_reader()));
        DTArrayNode N51 = new DTArrayNode(null, 8, 3, new DTNode[]{T50, T48, T47, T49});
        DTTerminal T52 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SBIW, new $sbiw$_0_reader()));
        DTTerminal T53 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ADIW, new $adiw$_0_reader()));
        DTArrayNode N54 = new DTArrayNode(null, 8, 1, new DTNode[]{T53, T52});
        DTTerminal T55 = new DTTerminal(null);
        DTArrayNode N56 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.ASR, new GPR_0_reader()), 0, 1, new DTNode[]{root1, T55});
        DTTerminal T57 = new DTTerminal(null);
        DTArrayNode N58 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLI, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N59 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SES, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N60 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SPM, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N61 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLC, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N62 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.WDR, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N63 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLV, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTTerminal T64 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ICALL, new NULL_reader(2)));
        DTTerminal T65 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.RET, new NULL_reader(2)));
        DTArrayNode N66 = new DTArrayNode(null, 0, 1, new DTNode[]{T65, T64});
        DTArrayNode N67 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SEV, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N68 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SEI, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N69 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLS, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTTerminal T70 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.EICALL, new NULL_reader(2)));
        DTTerminal T71 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.RETI, new NULL_reader(2)));
        DTArrayNode N72 = new DTArrayNode(null, 0, 1, new DTNode[]{T71, T70});
        DTArrayNode N73 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SEN, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N74 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLH, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N75 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLZ, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N76 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.LPM, new XLPM_REG_0_reader()), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N77 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SET, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTTerminal T78 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.EIJMP, new NULL_reader(2)));
        DTTerminal T79 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SEZ, new NULL_reader(2)));
        DTArrayNode N80 = new DTArrayNode(null, 0, 1, new DTNode[]{T79, T78});
        DTArrayNode N81 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.ELPM, new XLPM_REG_0_reader()), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N82 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLT, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N83 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.BREAK, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N84 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SLEEP, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N85 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.CLN, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTArrayNode N86 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.SEH, new NULL_reader(2)), 0, 1, new DTNode[]{T57, root1});
        DTTerminal T87 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.IJMP, new NULL_reader(2)));
        DTTerminal T88 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SEC, new NULL_reader(2)));
        DTArrayNode N89 = new DTArrayNode(null, 0, 1, new DTNode[]{T88, T87});
        DTArrayNode N90 = new DTArrayNode(null, 4, 31, new DTNode[]{N89, N80, N73, N67, N59, N86, N77, N68, N61, N75, N85, N63, N69, N74, N82, N58, N66, N72, root1, root1, root1, root1, root1, root1, N84, N83, N62, root1, N76, N81, N60, root1});
        DTTerminal T91 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.JMP, new $jmp$_0_reader()));
        DTTerminal T92 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.INC, new GPR_0_reader()));
        DTTerminal T93 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SWAP, new GPR_0_reader()));
        DTArrayNode N94 = new DTArrayNode(null, 0, 1, new DTNode[]{T93, T92});
        DTTerminal T95 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ROR, new GPR_0_reader()));
        DTTerminal T96 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LSR, new GPR_0_reader()));
        DTArrayNode N97 = new DTArrayNode(null, 0, 1, new DTNode[]{T96, T95});
        DTTerminal T98 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.CALL, new $call$_0_reader()));
        DTArrayNode N99 = new DTArrayNode(new SetBuilderAndRead(AVRInstrBuilder.DEC, new GPR_0_reader()), 0, 1, new DTNode[]{T55, root1});
        DTTerminal T100 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.NEG, new GPR_0_reader()));
        DTTerminal T101 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.COM, new GPR_0_reader()));
        DTArrayNode N102 = new DTArrayNode(null, 0, 1, new DTNode[]{T101, T100});
        DTArrayNode N103 = new DTArrayNode(null, 1, 7, new DTNode[]{N102, N94, N56, N97, N90, N99, T91, T98});
        DTArrayNode N104 = new DTArrayNode(null, 9, 1, new DTNode[]{N103, N54});
        DTTerminal T105 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.MUL, new GPRGPR_0_reader()));
        DTTerminal T106 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_PD_XYZ_2_reader()));
        DTTerminal T107 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.PUSH, new GPR_0_reader()));
        DTTerminal T108 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_AI_XYZ_0_reader()));
        DTTerminal T109 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_AI_XYZ_1_reader()));
        DTTerminal T110 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_AI_XYZ_2_reader()));
        DTTerminal T111 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_PD_XYZ_0_reader()));
        DTTerminal T112 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_PD_XYZ_1_reader()));
        DTTerminal T113 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ST, new LD_ST_XYZ_0_reader()));
        DTTerminal T114 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.STS, new $sts$_0_reader()));
        DTArrayNode N115 = new DTArrayNode(null, 0, 15, new DTNode[]{T114, T110, T106, root1, root1, root1, root1, root1, root1, T109, T112, root1, T113, T108, T111, T107});
        DTTerminal T116 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.POP, new GPR_0_reader()));
        DTTerminal T117 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LPM, new XLPM_D_0_reader()));
        DTTerminal T118 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ELPM, new XLPM_INC_0_reader()));
        DTTerminal T119 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_XYZ_0_reader()));
        DTTerminal T120 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_PD_XYZ_2_reader()));
        DTTerminal T121 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_AI_XYZ_0_reader()));
        DTTerminal T122 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_AI_XYZ_1_reader()));
        DTTerminal T123 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ELPM, new XLPM_D_0_reader()));
        DTTerminal T124 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_AI_XYZ_2_reader()));
        DTTerminal T125 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_PD_XYZ_0_reader()));
        DTTerminal T126 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LD, new LD_ST_PD_XYZ_1_reader()));
        DTTerminal T127 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LPM, new XLPM_INC_0_reader()));
        DTTerminal T128 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LDS, new $lds$_0_reader()));
        DTArrayNode N129 = new DTArrayNode(null, 0, 15, new DTNode[]{T128, T124, T120, root1, T117, T127, T123, T118, root1, T122, T126, root1, T119, T121, T125, T116});
        DTArrayNode N130 = new DTArrayNode(null, 9, 1, new DTNode[]{N129, N115});
        DTArrayNode N131 = new DTArrayNode(null, 10, 3, new DTNode[]{N130, N104, N51, T105});
        DTTerminal T132 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ORI, new HGPRIMM8_0_reader()));
        DTTerminal T133 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SUB, new GPRGPR_0_reader()));
        DTTerminal T134 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.CP, new GPRGPR_0_reader()));
        DTTerminal T135 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ADC, new GPRGPR_0_reader()));
        DTTerminal T136 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.CPSE, new GPRGPR_0_reader()));
        DTArrayNode N137 = new DTArrayNode(null, 10, 3, new DTNode[]{T136, T134, T133, T135});
        DTTerminal T138 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.LDI, new HGPRIMM8_0_reader()));
        DTTerminal T139 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SUBI, new HGPRIMM8_0_reader()));
        DTTerminal T140 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.SBC, new GPRGPR_0_reader()));
        DTTerminal T141 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.CPC, new GPRGPR_0_reader()));
        DTTerminal T142 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.ADD, new GPRGPR_0_reader()));
        DTTerminal T143 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.MULS, new $muls$_0_reader()));
        DTTerminal T144 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.MOVW, new $movw$_0_reader()));
        DTTerminal T145 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.FMULSU, new $fmulsu$_0_reader()));
        DTTerminal T146 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.FMULS, new $fmuls$_0_reader()));
        DTArrayNode N147 = new DTArrayNode(null, 3, 1, new DTNode[]{T146, T145});
        DTTerminal T148 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.FMUL, new $fmul$_0_reader()));
        DTTerminal T149 = new DTTerminal(new SetBuilderAndRead(AVRInstrBuilder.MULSU, new $mulsu$_0_reader()));
        DTArrayNode N150 = new DTArrayNode(null, 3, 1, new DTNode[]{T149, T148});
        DTArrayNode N151 = new DTArrayNode(null, 7, 1, new DTNode[]{N150, N147});
        DTSortedNode N152 = new DTSortedNode(new SetBuilderAndRead(AVRInstrBuilder.NOP, new NULL_reader(2)), 0, 255, new int[]{0}, new DTNode[]{T57}, root1);
        DTArrayNode N153 = new DTArrayNode(null, 8, 3, new DTNode[]{N152, T144, T143, N151});
        DTArrayNode N154 = new DTArrayNode(null, 10, 3, new DTNode[]{N153, T141, T140, T142});
        DTArrayNode N0 = new DTArrayNode(null, 12, 15, new DTNode[]{N154, N137, N45, T38, T27, T139, T132, T39, N34, N131, root1, N37, T40, T46, T138, N26});
        return N0;
    }

    public AbstractInstr disassemble(int base, int index, byte[] code) {
        return this.decode(base, index, code);
    }

    public AVRInstr decode(int base, int index, byte[] code) {
        this.word0 = code[index] & 0xFF | (code[index + 1] & 0xFF) << 8;
        this.word1 = code[index + 2] & 0xFF | (code[index + 3] & 0xFF) << 8;
        this.pc = base + index;
        return this.decode_root();
    }

    public AVRInstr decode(int base, int index, char[] code) {
        this.word0 = code[index];
        this.word1 = code[index + 1];
        this.pc = base + index * 2;
        return this.decode_root();
    }

    public AVRInstr decode(int base, int index, short[] code) {
        this.word0 = code[index] & 0xFFFF;
        this.word1 = code[index + 1] & 0xFFFF;
        this.pc = base + index * 2;
        return this.decode_root();
    }

    AVRInstr decode_root() {
        this.size = 0;
        this.builder = null;
        this.addrMode = null;
        return this.run_decoder(root0);
    }

    private AVRInstr run_decoder(DTNode node) {
        this.state = 0;
        while (this.state == 0) {
            int bits = this.word0 >> node.left_bit & node.mask;
            node = node.move(this, bits);
        }
        if (this.state == -1) {
            return null;
        }
        return this.builder.build(this.size, this.addrMode);
    }

    static abstract class OperandReader {
        OperandReader() {
        }

        abstract AVRAddrMode read(AVRDisassembler var1);
    }

    static class DTTerminal
    extends DTNode {
        DTTerminal(Action a) {
            super(a, 0, 0);
        }

        DTNode move(AVRDisassembler d, int bits) {
            d.state = 1;
            if (this.action != null) {
                this.action.execute(d);
            }
            return this;
        }
    }

    static class SetBuilderAndRead
    extends Action {
        AVRInstrBuilder builder;
        OperandReader reader;

        SetBuilderAndRead(AVRInstrBuilder b, OperandReader r) {
            this.builder = b;
            this.reader = r;
        }

        void execute(AVRDisassembler d) {
            d.builder = this.builder;
            d.addrMode = this.reader.read(d);
        }
    }

    static class DTTerm
    extends DTNode {
        DTTerm(Action a) {
            super(a, 0, 0);
        }

        DTNode move(AVRDisassembler d, int val) {
            d.state = 1;
            if (this.action != null) {
                this.action.execute(d);
            }
            return this;
        }
    }

    static class ErrorAction
    extends Action {
        ErrorAction() {
        }

        void execute(AVRDisassembler d) {
            d.state = -1;
        }
    }

    static abstract class Action {
        Action() {
        }

        abstract void execute(AVRDisassembler var1);
    }

    static class DTErrorTerm
    extends DTNode {
        DTErrorTerm() {
            super(null, 0, 0);
        }

        DTNode move(AVRDisassembler d, int bits) {
            d.state = -1;
            return this;
        }
    }

    static class DTSortedNode
    extends DTNode {
        final DTNode def;
        final DTNode[] nodes;
        final int[] values;

        DTSortedNode(Action a, int lb, int msk, int[] v, DTNode[] n, DTNode d) {
            super(a, lb, msk);
            this.values = v;
            this.nodes = n;
            this.def = d;
        }

        DTNode move(AVRDisassembler d, int val) {
            int ind;
            if (this.action != null) {
                this.action.execute(d);
            }
            if ((ind = Arrays.binarySearch(this.values, val)) >= 0 && ind < this.values.length && this.values[ind] == val) {
                return this.nodes[ind];
            }
            return this.def;
        }
    }

    static class DTArrayNode
    extends DTNode {
        final DTNode[] nodes;

        DTArrayNode(Action a, int lb, int msk, DTNode[] n) {
            super(a, lb, msk);
            this.nodes = n;
        }

        DTNode move(AVRDisassembler d, int val) {
            if (this.action != null) {
                this.action.execute(d);
            }
            return this.nodes[val];
        }
    }

    static abstract class DTNode {
        final int left_bit;
        final int mask;
        final Action action;

        DTNode(Action a, int lb, int msk) {
            this.action = a;
            this.left_bit = lb;
            this.mask = msk;
        }

        abstract DTNode move(AVRDisassembler var1, int var2);
    }

    static class HGPRIMM8_0_reader
    extends OperandReader {
        HGPRIMM8_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_HGPR rd = new AVROperand.op_HGPR(HGPR_table[AVRDisassembler.readop_11(d)]);
            AVROperand.IMM8 imm = new AVROperand.IMM8(AVRDisassembler.readop_18(d));
            return new AVRAddrMode.HGPRIMM8(rd, imm);
        }
    }

    static class LD_ST_AI_XYZ_2_reader
    extends OperandReader {
        LD_ST_AI_XYZ_2_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.AI_XYZ ar = new AVROperand.AI_XYZ(AVRSymbol.ADR.Z);
            return new AVRAddrMode.LD_ST_AI_XYZ(rd, ar);
        }
    }

    static class GPRGPR_0_reader
    extends OperandReader {
        GPRGPR_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_7(d)]);
            AVROperand.op_GPR rr = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_13(d)]);
            return new AVRAddrMode.GPRGPR(rd, rr);
        }
    }

    static class LD_ST_AI_XYZ_1_reader
    extends OperandReader {
        LD_ST_AI_XYZ_1_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.AI_XYZ ar = new AVROperand.AI_XYZ(AVRSymbol.ADR.Y);
            return new AVRAddrMode.LD_ST_AI_XYZ(rd, ar);
        }
    }

    static class XLPM_D_0_reader
    extends OperandReader {
        XLPM_D_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR dest = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.RZ_W source = new AVROperand.RZ_W(RZ_table[AVRDisassembler.readop_9(d)]);
            return new AVRAddrMode.XLPM_D(dest, source);
        }
    }

    static class LD_ST_XYZ_1_reader
    extends OperandReader {
        LD_ST_XYZ_1_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.XYZ ar = new AVROperand.XYZ(AVRSymbol.ADR.Y);
            return new AVRAddrMode.LD_ST_XYZ(rd, ar);
        }
    }

    static class XLPM_INC_0_reader
    extends OperandReader {
        XLPM_INC_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR dest = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.AI_RZ_W source = new AVROperand.AI_RZ_W(RZ_table[AVRDisassembler.readop_9(d)]);
            return new AVRAddrMode.XLPM_INC(dest, source);
        }
    }

    static class LD_ST_XYZ_2_reader
    extends OperandReader {
        LD_ST_XYZ_2_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.XYZ ar = new AVROperand.XYZ(AVRSymbol.ADR.Z);
            return new AVRAddrMode.LD_ST_XYZ(rd, ar);
        }
    }

    static class LD_ST_PD_XYZ_2_reader
    extends OperandReader {
        LD_ST_PD_XYZ_2_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.PD_XYZ ar = new AVROperand.PD_XYZ(AVRSymbol.ADR.Z);
            return new AVRAddrMode.LD_ST_PD_XYZ(rd, ar);
        }
    }

    static class LD_ST_XYZ_0_reader
    extends OperandReader {
        LD_ST_XYZ_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.XYZ ar = new AVROperand.XYZ(AVRSymbol.ADR.X);
            return new AVRAddrMode.LD_ST_XYZ(rd, ar);
        }
    }

    static class BRANCH_0_reader
    extends OperandReader {
        BRANCH_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.SREL target = new AVROperand.SREL(AVRDisassembler.signExtend(AVRDisassembler.readop_10(d), 7));
            return new AVRAddrMode.BRANCH(target);
        }
    }

    static class XLPM_REG_0_reader
    extends OperandReader {
        XLPM_REG_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.R0_B dest = new AVROperand.R0_B(R0_table[AVRDisassembler.readop_9(d)]);
            AVROperand.RZ_W source = new AVROperand.RZ_W(RZ_table[AVRDisassembler.readop_9(d)]);
            return new AVRAddrMode.XLPM_REG(dest, source);
        }
    }

    static class LD_ST_AI_XYZ_0_reader
    extends OperandReader {
        LD_ST_AI_XYZ_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.AI_XYZ ar = new AVROperand.AI_XYZ(AVRSymbol.ADR.X);
            return new AVRAddrMode.LD_ST_AI_XYZ(rd, ar);
        }
    }

    static class GPR_0_reader
    extends OperandReader {
        GPR_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_7(d)]);
            return new AVRAddrMode.GPR(rd);
        }
    }

    static class LD_ST_PD_XYZ_1_reader
    extends OperandReader {
        LD_ST_PD_XYZ_1_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.PD_XYZ ar = new AVROperand.PD_XYZ(AVRSymbol.ADR.Y);
            return new AVRAddrMode.LD_ST_PD_XYZ(rd, ar);
        }
    }

    static class LD_ST_PD_XYZ_0_reader
    extends OperandReader {
        LD_ST_PD_XYZ_0_reader() {
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = 2;
            AVROperand.op_GPR rd = new AVROperand.op_GPR(GPR_table[AVRDisassembler.readop_0(d)]);
            AVROperand.PD_XYZ ar = new AVROperand.PD_XYZ(AVRSymbol.ADR.X);
            return new AVRAddrMode.LD_ST_PD_XYZ(rd, ar);
        }
    }

    public static class NULL_reader
    extends OperandReader {
        final int size;

        NULL_reader(int sz) {
            this.size = sz;
        }

        AVRAddrMode read(AVRDisassembler d) {
            d.size = this.size;
            return null;
        }
    }

    public static class InvalidInstruction
    extends Exception {
        InvalidInstruction(int pc) {
            super("Invalid instruction at " + pc);
        }
    }
}

