/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import avrora.arch.avr.AVRState;
import avrora.sim.ActiveRegister;
import avrora.sim.Segment;
import avrora.sim.State;

public class AVRDataSegment
extends Segment {
    private final int sram_start;
    private final ActiveRegister[] ioregs;

    public AVRDataSegment(int sz, ActiveRegister[] ior, State st) {
        super("sram", sz, (byte)0, st);
        this.sram_start = AVRState.NUM_REGS + ior.length;
        this.ioregs = ior;
    }

    protected byte direct_read(int address) {
        if (address >= this.sram_start) {
            return this.segment_data[address];
        }
        if (address >= AVRState.NUM_REGS) {
            return this.ioregs[address - AVRState.NUM_REGS].read();
        }
        return this.segment_data[address];
    }

    protected void direct_write(int address, byte val) {
        if (address >= this.sram_start) {
            this.segment_data[address] = val;
        } else if (address >= AVRState.NUM_REGS) {
            this.ioregs[address - AVRState.NUM_REGS].write(val);
        } else {
            this.segment_data[address] = val;
        }
    }

    protected byte[] exposeRegisters() {
        return this.segment_data;
    }
}

