/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch.avr;

import avrora.arch.avr.AVRAddrModeVisitor;
import avrora.arch.avr.AVRInstr;
import avrora.arch.avr.AVROperand;

public interface AVRAddrMode {
    public void accept(AVRInstr var1, AVRAddrModeVisitor var2);

    public static class LD_ST_PD_XYZ
    implements AVRAddrMode,
    LD_ST {
        public final AVROperand.op_GPR rd;
        public final AVROperand.PD_XYZ ar;

        public LD_ST_PD_XYZ(AVROperand.op_GPR rd, AVROperand.PD_XYZ ar) {
            this.rd = rd;
            this.ar = ar;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_LD_ST_PD_XYZ(i, this.rd, this.ar);
        }

        public String toString() {
            return " " + this.rd + ", -" + this.ar;
        }

        public AVROperand get_rd() {
            return this.rd;
        }

        public AVROperand get_ar() {
            return this.ar;
        }
    }

    public static class LD_ST_AI_XYZ
    implements AVRAddrMode,
    LD_ST {
        public final AVROperand.op_GPR rd;
        public final AVROperand.AI_XYZ ar;

        public LD_ST_AI_XYZ(AVROperand.op_GPR rd, AVROperand.AI_XYZ ar) {
            this.rd = rd;
            this.ar = ar;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_LD_ST_AI_XYZ(i, this.rd, this.ar);
        }

        public String toString() {
            return " " + this.rd + ", " + this.ar + "+";
        }

        public AVROperand get_rd() {
            return this.rd;
        }

        public AVROperand get_ar() {
            return this.ar;
        }
    }

    public static class LD_ST_XYZ
    implements AVRAddrMode,
    LD_ST {
        public final AVROperand.op_GPR rd;
        public final AVROperand.XYZ ar;

        public LD_ST_XYZ(AVROperand.op_GPR rd, AVROperand.XYZ ar) {
            this.rd = rd;
            this.ar = ar;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_LD_ST_XYZ(i, this.rd, this.ar);
        }

        public String toString() {
            return " " + this.rd + ", " + this.ar;
        }

        public AVROperand get_rd() {
            return this.rd;
        }

        public AVROperand get_ar() {
            return this.ar;
        }
    }

    public static class XLPM_INC
    implements AVRAddrMode,
    XLPM {
        public final AVROperand.op_GPR dest;
        public final AVROperand.AI_RZ_W source;

        public XLPM_INC(AVROperand.op_GPR dest, AVROperand.AI_RZ_W source) {
            this.dest = dest;
            this.source = source;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_XLPM_INC(i, this.dest, this.source);
        }

        public String toString() {
            return " " + this.dest + ", " + this.source + "+";
        }

        public AVROperand get_dest() {
            return this.dest;
        }

        public AVROperand get_source() {
            return this.source;
        }
    }

    public static class XLPM_D
    implements AVRAddrMode,
    XLPM {
        public final AVROperand.op_GPR dest;
        public final AVROperand.RZ_W source;

        public XLPM_D(AVROperand.op_GPR dest, AVROperand.RZ_W source) {
            this.dest = dest;
            this.source = source;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_XLPM_D(i, this.dest, this.source);
        }

        public String toString() {
            return " " + this.dest + ", " + this.source;
        }

        public AVROperand get_dest() {
            return this.dest;
        }

        public AVROperand get_source() {
            return this.source;
        }
    }

    public static class XLPM_REG
    implements AVRAddrMode,
    XLPM {
        public final AVROperand.R0_B dest;
        public final AVROperand.RZ_W source;

        public XLPM_REG(AVROperand.R0_B dest, AVROperand.RZ_W source) {
            this.dest = dest;
            this.source = source;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_XLPM_REG(i, this.dest, this.source);
        }

        public String toString() {
            return " ";
        }

        public AVROperand get_dest() {
            return this.dest;
        }

        public AVROperand get_source() {
            return this.source;
        }
    }

    public static class WRITEBIT
    implements AVRAddrMode {
        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_WRITEBIT(i);
        }

        public String toString() {
            return "";
        }
    }

    public static class CALL
    implements AVRAddrMode {
        public final AVROperand.LREL target;

        public CALL(AVROperand.LREL target) {
            this.target = target;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_CALL(i, this.target);
        }

        public String toString() {
            return " " + this.target;
        }

        public AVROperand get_target() {
            return this.target;
        }
    }

    public static class BRANCH
    implements AVRAddrMode {
        public final AVROperand.SREL target;

        public BRANCH(AVROperand.SREL target) {
            this.target = target;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_BRANCH(i, this.target);
        }

        public String toString() {
            return " " + this.target;
        }

        public AVROperand get_target() {
            return this.target;
        }
    }

    public static class ABS
    implements AVRAddrMode {
        public final AVROperand.PADDR target;

        public ABS(AVROperand.PADDR target) {
            this.target = target;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_ABS(i, this.target);
        }

        public String toString() {
            return " " + this.target;
        }

        public AVROperand get_target() {
            return this.target;
        }
    }

    public static class HGPRIMM8
    implements AVRAddrMode {
        public final AVROperand.op_HGPR rd;
        public final AVROperand.IMM8 imm;

        public HGPRIMM8(AVROperand.op_HGPR rd, AVROperand.IMM8 imm) {
            this.rd = rd;
            this.imm = imm;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_HGPRIMM8(i, this.rd, this.imm);
        }

        public String toString() {
            return " " + this.rd + ", " + this.imm;
        }

        public AVROperand get_rd() {
            return this.rd;
        }

        public AVROperand get_imm() {
            return this.imm;
        }
    }

    public static class GPR
    implements AVRAddrMode {
        public final AVROperand.op_GPR rd;

        public GPR(AVROperand.op_GPR rd) {
            this.rd = rd;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_GPR(i, this.rd);
        }

        public String toString() {
            return " " + this.rd;
        }

        public AVROperand get_rd() {
            return this.rd;
        }
    }

    public static class MGPRMGPR
    implements AVRAddrMode {
        public final AVROperand.op_MGPR rd;
        public final AVROperand.op_MGPR rr;

        public MGPRMGPR(AVROperand.op_MGPR rd, AVROperand.op_MGPR rr) {
            this.rd = rd;
            this.rr = rr;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_MGPRMGPR(i, this.rd, this.rr);
        }

        public String toString() {
            return " " + this.rd + ", " + this.rr;
        }

        public AVROperand get_rd() {
            return this.rd;
        }

        public AVROperand get_rr() {
            return this.rr;
        }
    }

    public static class GPRGPR
    implements AVRAddrMode {
        public final AVROperand.op_GPR rd;
        public final AVROperand.op_GPR rr;

        public GPRGPR(AVROperand.op_GPR rd, AVROperand.op_GPR rr) {
            this.rd = rd;
            this.rr = rr;
        }

        public void accept(AVRInstr i, AVRAddrModeVisitor v) {
            v.visit_GPRGPR(i, this.rd, this.rr);
        }

        public String toString() {
            return " " + this.rd + ", " + this.rr;
        }

        public AVROperand get_rd() {
            return this.rd;
        }

        public AVROperand get_rr() {
            return this.rr;
        }
    }

    public static interface LD_ST
    extends AVRAddrMode {
        public AVROperand get_rd();

        public AVROperand get_ar();
    }

    public static interface XLPM
    extends AVRAddrMode {
        public AVROperand get_source();

        public AVROperand get_dest();
    }
}

