/*
 * Decompiled with CFR 0.152.
 */
package avrora.arch;

import avrora.Defaults;
import avrora.arch.AbstractArchitecture;
import avrora.arch.avr.AVRArchitecture;
import avrora.arch.legacy.LegacyArchitecture;
import avrora.arch.msp430.MSP430Architecture;
import cck.help.HelpCategory;
import cck.util.ClassMap;

public class ArchitectureRegistry {
    private static ClassMap archMap;

    public static synchronized void addArchitectures() {
        if (archMap == null) {
            archMap = new ClassMap("Architecture", AbstractArchitecture.class);
            archMap.addInstance("avr", LegacyArchitecture.INSTANCE);
            archMap.addInstance("avr-new", AVRArchitecture.INSTANCE);
            archMap.addInstance("msp430", MSP430Architecture.INSTANCE);
            HelpCategory hc = new HelpCategory("architectures", "Help for supported instruction set architectures.");
            hc.addOptionValueSection("ARCHITECTURES", "When running a simulation or other program analysis tool, Avrora derives information about the CPU architecture from an internal specification. In order to select the appropriate architecture, each one is named and can be selected with command line options.", "-arch", archMap);
            Defaults.addMainCategory(hc);
            Defaults.addSubCategories(archMap);
        }
    }

    public static AbstractArchitecture getArchitecture(String s) {
        ArchitectureRegistry.addArchitectures();
        return (AbstractArchitecture)archMap.getObjectOfClass(s);
    }
}

