/*
 * Decompiled with CFR 0.152.
 */
package avrora.actions;

import avrora.Defaults;
import avrora.actions.Action;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.Monitor;
import avrora.sim.Simulation;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import cck.util.TimeUtil;
import cck.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SimAction
extends Action {
    public static final String HELP = "The \"simulate\" action creates a simulation with the specified program(s) for the specified node(s). The simulation type might be as simple as a single node with a single program, or a multiple-node sensor network simulation or robotics simulation.";
    public final Option.Bool REPORT_SECONDS = this.newOption("report-seconds", false, "This option causes all times printed out by the simulator to be reported in seconds rather than clock cycles.");
    public final Option.Long SECONDS_PRECISION = this.newOption("seconds-precision", 6L, "This option sets the precision (number of decimal places) reported for event times in the simulation.");
    public final Option.Str SIMULATION = this.newOption("simulation", "single", "The \"simulation\" option selects from the available simulation types, including a single node simulation, a sensor network simulation, or a robotics simulation.");
    protected Simulation simulation;
    protected long startms;
    protected boolean reported;

    public SimAction() {
        super(HELP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) throws Exception {
        SimUtil.REPORT_SECONDS = this.REPORT_SECONDS.get();
        SimUtil.SECONDS_PRECISION = (int)this.SECONDS_PRECISION.get();
        this.simulation = Defaults.getSimulation(this.SIMULATION.get());
        this.simulation.process(this.options, args);
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        SimAction.printSimHeader();
        try {
            this.startms = System.currentTimeMillis();
            this.simulation.start();
            this.simulation.join();
        }
        catch (Throwable t) {
            this.exitSimulation(t);
        }
        finally {
            this.exitSimulation(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitSimulation(Throwable thrown) {
        SimAction simAction = this;
        synchronized (simAction) {
            if (!this.reported) {
                this.reported = true;
                this.report(thrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(Throwable thrown) {
        long delta = System.currentTimeMillis() - this.startms;
        try {
            if (thrown != null) {
                throw thrown;
            }
        }
        catch (BreakPointException e) {
            Terminal.printYellow("Simulation terminated");
            Terminal.println(": breakpoint at " + StringUtil.addrToString(e.address) + " reached.");
        }
        catch (TimeoutException e) {
            Terminal.printYellow("Simulation terminated");
            Terminal.println(": timeout reached at pc = " + StringUtil.addrToString(e.address) + ", time = " + e.state.getCycles());
        }
        catch (AsynchronousExit e) {
            Terminal.printYellow("Simulation terminated asynchronously");
            Terminal.nextln();
        }
        catch (Util.Error e) {
            Terminal.printRed("Simulation terminated");
            Terminal.print(": ");
            e.report();
        }
        catch (Throwable t) {
            Terminal.printRed("Simulation terminated with unexpected exception");
            Terminal.print(": ");
            t.printStackTrace();
        }
        finally {
            TermUtil.printSeparator();
            SimAction.reportTime(this.simulation, delta);
            SimAction.reportMonitors(this.simulation);
        }
    }

    public static List getLocationList(Program program, List v) {
        HashSet<SourceMapping.Location> locset = new HashSet<SourceMapping.Location>(v.size() * 2);
        SourceMapping lm = program.getSourceMapping();
        for (String val : v) {
            SourceMapping.Location l = lm.getLocation(val);
            if (l == null) {
                Util.userError("Label unknown", val);
            }
            locset.add(l);
        }
        ArrayList loclist = Collections.list(Collections.enumeration(locset));
        Collections.sort(loclist, SourceMapping.LOCATION_COMPARATOR);
        return loclist;
    }

    protected static void printSimHeader() {
        TermUtil.printSeparator(78, "Simulation events");
        Terminal.printGreen("Node          Time   Event");
        Terminal.nextln();
        TermUtil.printThinSeparator(78);
    }

    protected static void reportMonitors(Simulation sim) {
        Iterator i = sim.getNodeIterator();
        while (i.hasNext()) {
            Simulation.Node n = (Simulation.Node)i.next();
            for (Monitor m : n.getMonitors()) {
                m.report();
            }
        }
    }

    protected static void reportTime(Simulation sim, long diff) {
        Iterator i = sim.getNodeIterator();
        long aggCycles = 0L;
        long maxCycles = 0L;
        while (i.hasNext()) {
            Simulation.Node n = (Simulation.Node)i.next();
            Simulator simulator = n.getSimulator();
            if (simulator == null) continue;
            long count = simulator.getClock().getCount();
            aggCycles += count;
            if (count <= maxCycles) continue;
            maxCycles = count;
        }
        TermUtil.reportQuantity("Simulated time", maxCycles, "cycles");
        TermUtil.reportQuantity("Time for simulation", TimeUtil.milliToSecs(diff), "seconds");
        int nn = sim.getNumberOfNodes();
        double thru = (double)aggCycles / (double)(diff * 1000L);
        TermUtil.reportQuantity("Total throughput", (float)thru, "mhz");
        if (nn > 1) {
            TermUtil.reportQuantity("Throughput per node", (float)(thru / (double)nn), "mhz");
        }
    }

    public class ShutdownThread
    extends Thread {
        public void run() {
            SimAction.this.exitSimulation(new AsynchronousExit());
        }
    }

    public static class AsynchronousExit
    extends RuntimeException {
    }

    public static class TimeoutException
    extends RuntimeException {
        public final int address;
        public final State state;
        public final long timeout;

        public TimeoutException(int a, State s, long t, String l) {
            super("timeout @ " + StringUtil.addrToString(a) + " reached after " + t + ' ' + l);
            this.address = a;
            this.state = s;
            this.timeout = t;
        }
    }

    public static class BreakPointException
    extends RuntimeException {
        public final int address;
        public final State state;

        public BreakPointException(int a, State s) {
            super("breakpoint @ " + StringUtil.addrToString(a) + " reached");
            this.address = a;
            this.state = s;
        }
    }
}

