/*
 * Decompiled with CFR 0.152.
 */
package avrora.actions;

import avrora.actions.Action;
import avrora.sim.state.Register;
import avrora.sim.state.RegisterUtil;
import avrora.sim.state.RegisterView;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Arithmetic;
import cck.util.Option;

public class RegisterTestAction
extends Action {
    public static final String HELP = "The \"test\" action invokes the internal automated testing framework that runs test cases supplied at the command line. The test cases are used in regressions for diagnosing bugs.";
    public final Option.Bool DETAIL = this.newOption("detail", false, "This option selects whether the testing framework will report detailed information for failed test cases.");
    protected boolean detail;

    public RegisterTestAction() {
        super(HELP);
    }

    public void run(String[] args) throws Exception {
        this.detail = this.DETAIL.get();
        Register r1 = new Register(16);
        this.writeAndPrint("R1", r1, 137);
        this.writeAndPrint("R1", r1, 4489);
        this.writeAndPrint("R1", r1, 137);
        this.writeAndPrint("R1", r1, 109705);
        RegisterView r2 = RegisterUtil.bitRangeView(r1, 0, 15);
        r1.write(137);
        this.checkRegister("R2", r2, 137);
        r2.setValue(122);
        this.checkRegister("R1", r1, 122);
        Register r3 = new Register(8);
        Register r4 = new Register(8);
        RegisterView r5 = RegisterUtil.stackedView(r3, r4);
        r5.setValue(41911);
        this.checkRegister("R3", r3, 183);
        this.checkRegister("R4", r4, 163);
        RegisterView r6 = RegisterUtil.bitRangeView(r5, 4, 7);
        RegisterView r7 = RegisterUtil.bitRangeView(r5, 10, 15);
        r5.setValue(43981);
        this.checkRegister("R6", r6, 12);
        r6.setValue(7);
        this.checkRegister("R5", r5, 43901);
        this.checkRegister("R7", r7, 42);
        r7.setValue(255);
        this.checkRegister("R5", r5, 65405);
        assert (Arithmetic.getBitMask(16) == 65535);
        assert (Arithmetic.getBitMask(32) == -1);
    }

    private void writeAndPrint(String name, Register r, int val) {
        r.write(val);
        this.checkRegister(name, r, val);
    }

    void checkRegister(String n, RegisterView r, int val) {
        int rw = r.getWidth();
        String rval = StringUtil.toMultirepString(r.getValue(), rw);
        if ((val & Arithmetic.getBitMask(rw)) == r.getValue()) {
            Terminal.printGreen(n);
            Terminal.print(": ");
            Terminal.printCyan(rval);
            Terminal.nextln();
        } else {
            Terminal.printRed(n);
            Terminal.print(": ");
            Terminal.printCyan(rval);
            Terminal.print(" != ");
            Terminal.printCyan(StringUtil.toMultirepString(val, rw));
            Terminal.nextln();
        }
    }
}

