/*
 * Decompiled with CFR 0.152.
 */
package avrora.actions;

import avrora.actions.Action;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.MainClock;
import avrora.sim.radio.Medium;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;

public class MediumTestAction
extends Action {
    public static final String HELP = "The \"test\" action invokes the internal automated testing framework that runs test cases supplied at the command line. The test cases are used in regressions for diagnosing bugs.";
    public final Option.Bool DETAIL = this.newOption("detail", false, "This option selects whether the testing framework will report detailed information for failed test cases.");

    public MediumTestAction() {
        super(HELP);
    }

    public void run(String[] args) throws Exception {
        Medium m = new Medium(null, null, 300, 102, 8, 128);
        MainClock c = new MainClock("main", 3000L);
        final TestTransmitter t = new TestTransmitter(m, c);
        final TestReceiver r = new TestReceiver(m, c);
        Simulator.Event send = new Simulator.Event(){

            public void fire() {
                t.beginTransmit(0.0, 2.4);
            }
        };
        Simulator.Event recv = new Simulator.Event(){

            public void fire() {
                r.beginReceive();
            }
        };
        c.insertEvent(send, 1000L);
        c.insertEvent(send, 45500L);
        c.insertEvent(send, 65500L);
        c.insertEvent(send, 106000L);
        c.insertEvent(recv, 100L);
        for (int i = 0; i < 1000000; ++i) {
            c.advance(1L);
        }
    }

    class TestReceiver
    extends Medium.Receiver {
        TestReceiver(Medium m, Clock c) {
            super(m, c);
        }

        public byte nextByte(boolean lock, byte b) {
            if (lock) {
                Terminal.println(this.clock.getCount() + " " + StringUtil.toMultirepString(b, 8));
            } else {
                Terminal.println(this.clock.getCount() + " lock end");
            }
            return b;
        }

        public void setRssiValid(boolean v) {
        }

        public boolean getRssiValid() {
            return false;
        }

        public void setRSSI(double PRec) {
        }

        public void setBER(double BER) {
        }
    }

    class TestTransmitter
    extends Medium.Transmitter {
        int counter;

        TestTransmitter(Medium m, Clock c) {
            super(m, c);
        }

        public byte nextByte() {
            byte val = (byte)this.counter++;
            if (this.counter % 5 == 0) {
                this.endTransmit();
            }
            return val;
        }
    }
}

