/*
 * Decompiled with CFR 0.152.
 */
package avrora.actions;

import avrora.Main;
import avrora.actions.Action;
import cck.elf.ELFHeader;
import cck.elf.ELFLoader;
import cck.elf.ELFProgramHeaderTable;
import cck.elf.ELFSectionHeaderTable;
import cck.elf.ELFStringTable;
import cck.elf.ELFSymbolTable;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Util;
import java.io.RandomAccessFile;
import java.util.List;

public class ELFDumpAction
extends Action {
    public static final String HELP = "The \"elf-dump\" action loads an ELF executable and produces a listing of many important pieces of information, including the architecture, sections, symbol tables and sizes of various structures.";

    public ELFDumpAction() {
        super(HELP);
    }

    public void run(String[] args) throws Exception {
        String fname = args[0];
        Main.checkFileExists(fname);
        RandomAccessFile fis = new RandomAccessFile(fname, "r");
        try {
            ELFHeader header = ELFLoader.readELFHeader(fis);
            ELFDumpAction.printHeader(header);
            ELFProgramHeaderTable pht = ELFLoader.readPHT(fis, header);
            ELFDumpAction.printPHT(pht);
            ELFSectionHeaderTable sht = ELFLoader.readSHT(fis, header);
            ELFDumpAction.printSHT(sht);
            List symbolTables = ELFLoader.readSymbolTables(fis, header, sht);
            for (ELFSymbolTable stab : symbolTables) {
                ELFDumpAction.printSymbolTable(stab, sht);
            }
        }
        catch (ELFHeader.FormatError e) {
            Util.userError(fname, "invalid ELF header");
        }
    }

    public static void printHeader(ELFHeader header) {
        Terminal.nextln();
        TermUtil.printSeparator();
        Terminal.printGreen("Ver Machine     Arch     Size  Endian");
        Terminal.nextln();
        TermUtil.printThinSeparator();
        Terminal.print(StringUtil.rightJustify(header.e_version, 3));
        Terminal.print(StringUtil.rightJustify(header.e_machine, 8));
        Terminal.print(StringUtil.rightJustify(header.getArchitecture(), 9));
        Terminal.print(StringUtil.rightJustify(header.is64Bit() ? "64 bits" : "32 bits", 9));
        Terminal.print(header.isLittleEndian() ? "  little" : "  big");
        Terminal.nextln();
    }

    public static void printSHT(ELFSectionHeaderTable sht) {
        TermUtil.printSeparator(78, "Section Header Table");
        Terminal.printGreen("Ent  Name                        Type   Address  Offset    Size  Flags");
        Terminal.nextln();
        TermUtil.printThinSeparator();
        for (int cntr = 0; cntr < sht.entries.length; ++cntr) {
            ELFSectionHeaderTable.Entry32 e = sht.entries[cntr];
            Terminal.print(StringUtil.rightJustify(cntr, 3));
            Terminal.print("  " + StringUtil.leftJustify(e.getName(), 24));
            Terminal.print(StringUtil.rightJustify(e.getType(), 8));
            Terminal.print("  " + StringUtil.toHex(e.sh_addr, 8));
            Terminal.print(StringUtil.rightJustify(e.sh_offset, 8));
            Terminal.print(StringUtil.rightJustify(e.sh_size, 8));
            Terminal.print("  " + e.getFlags());
            Terminal.nextln();
        }
    }

    public static String getName(ELFStringTable st, int ind) {
        if (st == null) {
            return "";
        }
        return st.getString(ind);
    }

    public static void printPHT(ELFProgramHeaderTable pht) {
        TermUtil.printSeparator(78, "Program Header Table");
        Terminal.printGreen("Ent     Type  Virtual   Physical  Offset  Filesize  Memsize  Flags");
        Terminal.nextln();
        TermUtil.printThinSeparator();
        for (int cntr = 0; cntr < pht.entries.length; ++cntr) {
            ELFProgramHeaderTable.Entry32 e = pht.entries[cntr];
            Terminal.print(StringUtil.rightJustify(cntr, 3));
            Terminal.print(StringUtil.rightJustify(ELFProgramHeaderTable.getType(e), 9));
            Terminal.print("  " + StringUtil.toHex(e.p_vaddr, 8));
            Terminal.print("  " + StringUtil.toHex(e.p_paddr, 8));
            Terminal.print(StringUtil.rightJustify(e.p_offset, 8));
            Terminal.print(StringUtil.rightJustify(e.p_filesz, 10));
            Terminal.print(StringUtil.rightJustify(e.p_memsz, 9));
            Terminal.print("  " + e.getFlags());
            Terminal.nextln();
        }
    }

    public static void printSymbolTable(ELFSymbolTable stab, ELFSectionHeaderTable sht) {
        TermUtil.printSeparator(78, "Symbol Table");
        Terminal.printGreen("Ent  Type     Section     Bind    Name                     Address      Size");
        Terminal.nextln();
        TermUtil.printThinSeparator();
        ELFStringTable str = stab.getStringTable();
        for (int cntr = 0; cntr < stab.entries.length; ++cntr) {
            ELFSymbolTable.Entry e = stab.entries[cntr];
            Terminal.print(StringUtil.rightJustify(cntr, 3));
            Terminal.print("  " + StringUtil.leftJustify(e.getType(), 7));
            Terminal.print("  " + StringUtil.leftJustify(sht.getSectionName(e.st_shndx), 12));
            Terminal.print(StringUtil.leftJustify(e.getBinding(), 8));
            Terminal.print(StringUtil.leftJustify(ELFDumpAction.getName(str, e.st_name), 22));
            Terminal.print("  " + StringUtil.toHex(e.st_value, 8));
            Terminal.print("  " + StringUtil.rightJustify(e.st_size, 8));
            Terminal.nextln();
        }
    }
}

