/*
 * Decompiled with CFR 0.152.
 */
package avrora.actions;

import avrora.Main;
import avrora.actions.Action;
import avrora.arch.AbstractArchitecture;
import avrora.arch.AbstractDisassembler;
import avrora.arch.AbstractInstr;
import avrora.arch.ArchitectureRegistry;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;
import cck.util.Util;
import java.io.FileInputStream;
import java.io.IOException;

public class DisassembleAction
extends Action {
    Option.Str ARCH = this.newOption("arch", "avr", "This option selects the architecture for the disassembler.");
    Option.Long MAX_LENGTH = this.newOption("max-length", 16L, "This option specifies the maximum length of an instruction in bytes.");
    Option.Bool EXHAUSTIVE = this.newOption("exhaustive", false, "When this option is specified, this action will test the disassembler exhaustively by trying bit patterns systematically.");
    Option.Str FILE = this.newOption("file", "", "When this option is specified, this action will test the disassembler by loading the specified file and disassembling the data contained inside.");

    public DisassembleAction() {
        super("The \"disassemble\" action disassembles a binary file into source level instructions.");
    }

    public void run(String[] args) throws Exception {
        byte[] buf = new byte[128];
        AbstractArchitecture arch = ArchitectureRegistry.getArchitecture(this.ARCH.get());
        AbstractDisassembler da = arch.getDisassembler();
        if (this.EXHAUSTIVE.get()) {
            this.exhaustive(da);
        } else if (!this.FILE.isBlank()) {
            this.disassembleFile(da);
        } else {
            this.disassembleArguments(args, buf, da);
        }
    }

    private void disassembleArguments(String[] args, byte[] buf, AbstractDisassembler da) {
        if (args.length < 1) {
            Util.userError("no input data");
        }
        for (int cntr = 0; cntr < args.length; ++cntr) {
            buf[cntr] = (byte)StringUtil.evaluateIntegerLiteral(args[cntr]);
        }
        this.disassembleAndPrint(buf, 0, da);
    }

    private void disassembleFile(AbstractDisassembler da) throws IOException {
        String fname = this.FILE.get();
        Main.checkFileExists(fname);
        FileInputStream fis = new FileInputStream(fname);
        byte[] buf = new byte[fis.available()];
        fis.read(buf);
        for (int cntr = 0; cntr < buf.length; cntr += this.disassembleAndPrint(buf, cntr, da)) {
        }
    }

    void exhaustive(AbstractDisassembler da) {
        byte[] buf = new byte[(int)this.MAX_LENGTH.get()];
        for (int cntr = 0; cntr < 65536; ++cntr) {
            buf[0] = (byte)cntr;
            buf[1] = (byte)(cntr >> 8);
            try {
                this.disassembleAndPrint(buf, 0, da);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private int disassembleAndPrint(byte[] buf, int off, AbstractDisassembler da) {
        String result;
        int len = 2;
        AbstractInstr instr = da.disassemble(0, off, buf);
        if (instr == null) {
            result = "null";
        } else {
            result = instr.toString();
            len = instr.getSize();
        }
        this.print(buf, off, len, result);
        return len;
    }

    private void print(byte[] buf, int off, int len, String str) {
        int cntr;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(StringUtil.addrToString(off));
        sbuf.append(": ");
        for (cntr = 0; cntr < len; ++cntr) {
            StringUtil.toHex(sbuf, buf[off + cntr], 2);
            sbuf.append(' ');
        }
        for (cntr = sbuf.length(); cntr < 30; ++cntr) {
            sbuf.append(' ');
        }
        sbuf.append(str);
        Terminal.println(sbuf.toString());
    }
}

