/*
 * Decompiled with CFR 0.152.
 */
package avrora.actions;

import avrora.Main;
import avrora.actions.Action;
import avrora.arch.legacy.LegacyInstr;
import avrora.core.ControlFlowGraph;
import avrora.core.ProcedureMap;
import avrora.core.Program;
import avrora.core.SourceMapping;
import cck.text.Printer;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CFGAction
extends Action {
    public static final String HELP = "The \"cfg\" action builds and displays a control flow graph of the given input program. This is useful for better program understanding and for optimizations. The graph can be outputted in a textual format, or the format supported by the \"dot\" graph tool.";
    public final Option.Bool COLOR_PROCEDURES = this.newOption("color-procedures", true, "This option is used when outputting in the \"dot\" output format. When this option is true, the control flow graph utility will attempt to discover procedures and color them in the output.");
    public final Option.Bool GROUP_PROCEDURES = this.newOption("group-procedures", true, "This option is used when outputting in the \"dot\" output format. When this option is true, the control flow graph utility will attempt to discover procedures and group them as subgraphs in the output.");
    public final Option.Bool COLLAPSE_PROCEDURES = this.newOption("collapse-procedures", false, "This option is used when outputting in the \"dot\" output format. When this option is true, the control flow graph utility will attempt to discover procedures within the control flow graph and collapse whole procedures to a single node in the output.");
    public final Option.Str OUTPUT = this.newOption("output", "", "This option selects the output format for the control flow graph. When this option is set to \"dot\", then the control flow graph will be outputted in a format suitable for parsing by the dot graph rendering tool.");
    public final Option.Str FILE = this.newOption("file", "", "This option specifies the output file for the result of generating a\"dot\" format control flow graph. When this option is not set, a textual representation of the graph will be printed to the terminal.");
    protected ProcedureMap pmap;
    protected ControlFlowGraph cfg;
    protected Program program;
    private int colorCounter;
    private final HashMap BLOCK_COLORS = new HashMap();
    private static final String[] palette = new String[]{"aquamarine", "blue2", "brown1", "cadetblue1", "chartreuse1", "cyan4", "darkgoldenrod1", "darkorchid3", "darkslateblue", "deeppink2", "yellow", "seagreen3", "orangered1"};
    private boolean unknownExists;

    public CFGAction() {
        super(HELP);
    }

    public void run(String[] args) throws Exception {
        this.program = Main.loadProgram(args);
        this.cfg = this.program.getCFG();
        if ("dot".equals(this.OUTPUT.get())) {
            this.dumpDotCFG(this.cfg);
        } else {
            this.dumpCFG(this.cfg);
        }
    }

    private void dumpCFG(ControlFlowGraph cfg) {
        Iterator biter = cfg.getSortedBlockIterator();
        SourceMapping sm = this.program.getSourceMapping();
        while (biter.hasNext()) {
            ControlFlowGraph.Block block = (ControlFlowGraph.Block)biter.next();
            Terminal.print("[");
            int address = block.getAddress();
            String s = sm.getName(address);
            Terminal.printBrightCyan(s);
            Terminal.println(":" + block.getSize() + ']');
            Iterator iiter = block.getInstrIterator();
            while (iiter.hasNext()) {
                LegacyInstr instr = (LegacyInstr)iiter.next();
                Terminal.printBrightBlue("    " + instr.getName());
                Terminal.println(' ' + instr.getOperands());
            }
            Terminal.print("    [");
            this.dumpEdges(block.getEdgeIterator());
            Terminal.println("]");
        }
    }

    private void dumpDotCFG(ControlFlowGraph cfg) throws IOException {
        Printer p = this.FILE.isBlank() ? Printer.STDOUT : new Printer(new PrintStream(new FileOutputStream(this.FILE.get())));
        p.startblock("digraph G");
        if (this.COLOR_PROCEDURES.get() || this.GROUP_PROCEDURES.get() || this.COLLAPSE_PROCEDURES.get()) {
            this.pmap = cfg.getProcedureMap();
        }
        this.dumpDotNodes(p);
        this.dumpDotEdges(p);
        p.endblock();
    }

    private void dumpDotNodes(Printer p) {
        if (this.COLOR_PROCEDURES.get()) {
            this.assignProcedureColors();
        }
        if (this.COLLAPSE_PROCEDURES.get()) {
            Iterator blocks = this.cfg.getSortedBlockIterator();
            while (blocks.hasNext()) {
                ControlFlowGraph.Block block = (ControlFlowGraph.Block)blocks.next();
                ControlFlowGraph.Block entry = this.pmap.getProcedureContaining(block);
                if (entry != null && entry != block) continue;
                this.printBlock(block, p);
            }
        } else if (this.GROUP_PROCEDURES.get()) {
            Iterator block_iter = this.cfg.getSortedBlockIterator();
            while (block_iter.hasNext()) {
                ControlFlowGraph.Block block = (ControlFlowGraph.Block)block_iter.next();
                ControlFlowGraph.Block entry = this.pmap.getProcedureContaining(block);
                if (entry != null) continue;
                this.printBlock(block, p);
            }
            int num = 0;
            for (ControlFlowGraph.Block entry : this.pmap.getProcedureEntrypoints()) {
                p.startblock("subgraph cluster" + num++);
                for (ControlFlowGraph.Block block : this.pmap.getProcedureBlocks(entry)) {
                    this.printBlock(block, p);
                }
                p.endblock();
            }
        } else {
            Iterator blocks = this.cfg.getSortedBlockIterator();
            while (blocks.hasNext()) {
                ControlFlowGraph.Block block = (ControlFlowGraph.Block)blocks.next();
                this.printBlock(block, p);
            }
        }
    }

    private void assignProcedureColors() {
        Iterator blocks = this.cfg.getBlockIterator();
        while (blocks.hasNext()) {
            ControlFlowGraph.Block block = (ControlFlowGraph.Block)blocks.next();
            ControlFlowGraph.Block entry = this.pmap.getProcedureContaining(block);
            if (entry == null) continue;
            String c = this.colorize(entry);
            this.BLOCK_COLORS.put(block, c);
        }
    }

    private void printBlock(ControlFlowGraph.Block block, Printer p) {
        String bName = CFGAction.blockName(block);
        String shape = this.getShape(block);
        String color = this.getColor(block);
        p.print(bName + " [shape=" + shape);
        if (!"".equals(color)) {
            p.print(",style=filled,fillcolor=" + color);
        }
        p.println("];");
    }

    private void dumpDotEdges(Printer p) {
        Iterator blocks = this.cfg.getBlockIterator();
        while (blocks.hasNext()) {
            ControlFlowGraph.Block block = (ControlFlowGraph.Block)blocks.next();
            this.dumpDotEdges(block.getEdgeIterator(), p);
        }
    }

    private String getShape(ControlFlowGraph.Block block) {
        ControlFlowGraph.Block entry = this.getEntryOf(block);
        if (entry == block) {
            return "doubleoctagon";
        }
        int addr = block.getAddress();
        if (addr % 4 == 0 && addr < 140) {
            return "box";
        }
        Iterator edges = block.getEdgeIterator();
        while (edges.hasNext()) {
            ControlFlowGraph.Edge e = (ControlFlowGraph.Edge)edges.next();
            String type = e.getType();
            if (!this.isReturnEdge(type)) continue;
            return "hexagon";
        }
        return "ellipse";
    }

    private String colorize(ControlFlowGraph.Block b) {
        String color = (String)this.BLOCK_COLORS.get(b);
        if (color != null) {
            return color;
        }
        color = palette[this.colorCounter];
        this.colorCounter = (this.colorCounter + 1) % palette.length;
        this.BLOCK_COLORS.put(b, color);
        return color;
    }

    private String getColor(ControlFlowGraph.Block block) {
        String color = (String)this.BLOCK_COLORS.get(block);
        if (color == null) {
            return "";
        }
        return color;
    }

    private boolean isReturnEdge(String type) {
        return type != null && ("RET".equals(type) || "RETI".equals(type));
    }

    private void dumpEdges(Iterator edges) {
        SourceMapping sm = this.program.getSourceMapping();
        while (edges.hasNext()) {
            ControlFlowGraph.Edge e = (ControlFlowGraph.Edge)edges.next();
            ControlFlowGraph.Block t = e.getTarget();
            if ("".equals(e.getType())) {
                Terminal.print("--> ");
            } else {
                Terminal.print("--(" + e.getType() + ")--> ");
            }
            if (t != null) {
                String str = sm.getName(e.getTarget().getAddress());
                Terminal.printBrightGreen(str);
            } else {
                Terminal.printRed("UNKNOWN");
            }
            if (!edges.hasNext()) continue;
            Terminal.print(", ");
        }
    }

    private void dumpDotEdges(Iterator edges, Printer p) {
        while (edges.hasNext()) {
            ControlFlowGraph.Edge e = (ControlFlowGraph.Edge)edges.next();
            ControlFlowGraph.Block source = e.getSource();
            ControlFlowGraph.Block target = e.getTarget();
            String type = e.getType();
            if (this.isReturnEdge(type)) continue;
            if (this.COLLAPSE_PROCEDURES.get()) {
                ControlFlowGraph.Block es = this.getEntryOf(source);
                source = es == null ? source : es;
                ControlFlowGraph.Block et = this.getEntryOf(target);
                ControlFlowGraph.Block block = target = et == null ? target : et;
                if (es == et && et != null) continue;
            }
            String sName = CFGAction.blockName(source);
            if (target == null) {
                this.emitIndirectEdge(source, sName, p, type);
                continue;
            }
            this.emitEdge(target, p, sName, type, true);
        }
    }

    private void emitIndirectEdge(ControlFlowGraph.Block source, String sName, Printer p, String type) {
        List l = this.program.getIndirectEdges(source.getLastAddress());
        if (l == null) {
            if (!this.unknownExists) {
                p.println("UNKNOWN [shape=Msquare];");
                this.unknownExists = true;
            }
            p.println(sName + " -> UNKNOWN [style=dotted];");
        } else {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                int taddr = (Integer)i.next();
                ControlFlowGraph.Block target = this.cfg.getBlockStartingAt(taddr);
                this.emitEdge(target, p, sName, type, false);
            }
        }
    }

    private void emitEdge(ControlFlowGraph.Block target, Printer p, String sName, String t, boolean direct) {
        String tName = CFGAction.blockName(target);
        p.print(sName + " -> " + tName);
        p.print(" [headport=n,tailport=s");
        if (!direct) {
            p.print(",style=dotted");
        }
        if ("CALL".equals(t)) {
            p.print(",color=red");
        }
        p.println("];");
    }

    private ControlFlowGraph.Block getEntryOf(ControlFlowGraph.Block b) {
        if (this.pmap == null) {
            return null;
        }
        return this.pmap.getProcedureContaining(b);
    }

    public static String blockName(ControlFlowGraph.Block block) {
        String start = StringUtil.addrToString(block.getAddress());
        String end = StringUtil.addrToString(block.getAddress() + block.getSize());
        return StringUtil.quote(start + " - \\n" + end);
    }
}

