/*
 * Decompiled with CFR 0.152.
 */
package avrora.actions;

import avrora.Main;
import avrora.actions.Action;
import avrora.core.Program;
import avrora.stack.Analyzer;
import cck.util.Option;

public class AnalyzeStackAction
extends Action {
    public static final String HELP = "The \"analyze-stack\" option invokes the built-in stack analysis tool on the specified program. It uses an abstract interpretation of the program to determine the possible interrupt masks at each program point and determines the worst-case stack depth in the presence of interrupts.";
    public final Option.Bool MONITOR_STATES = this.newOption("monitor-states", false, "This option is used to monitor the progress of a long-running stack analysis problem. The analyzer will report the count of states, edges, and propagation information produced every 5 seconds. ");
    public final Option.Bool USE_ISEA = this.newOption("use-isea", false, "This option enables the use of information from inter-procedural side effect analysis that may help in reducing the memory usage during state exploration, without affecting stack analysis precision. When this option is enabled, the stack analyzer will consult the ISEA analysis subsystem for each procedure call that it encounters in the program.");
    public final Option.Bool TRACE_SUMMARY = this.newOption("trace-summary", true, "This option is used to reduce the amount of output by summarizing the error tracethat yields the maximal stack depth. When true, the analysis will shorten the error trace by not reporting edges between states of adjacent instructions that do not change the stack height.");
    public final Option.Bool TRACE = this.newOption("trace", false, "This option causes the stack analyzer to print a trace of each abstract state produced, every edge between states that is inserted, and all propagations performed during the analysis. ");
    public final Option.Bool DUMP_STATE_SPACE = this.newOption("dump-state-space", false, "This option causes the stack analyzer to print a dump of all the reachable abstract states in the state space, as well as all edges between states. This can be used for a post-mortem analysis.");
    public final Option.Bool SHOW_PATH = this.newOption("show-path", false, "This option causes the stack analyzer to print out the execution path corresponding to the maximal stack depth.");
    public final Option.Long RESERVE = this.newOption("reserve", 0L, "This option is used for reserving a small portion of memory before the analysis begins, in case the Java heap space is exhausted. This can happen with very large analyses. By reserving some space up front, there is space left so that post mortem graph analysis can be run. The units given are megabytes.");
    public static final int MEGABYTES = 0x100000;

    public AnalyzeStackAction() {
        super(HELP);
    }

    public void run(String[] args) throws Exception {
        Program p = Main.loadProgram(args);
        Analyzer.TRACE_SUMMARY = this.TRACE_SUMMARY.get();
        Analyzer.MONITOR_STATES = this.MONITOR_STATES.get();
        Analyzer.TRACE = this.TRACE.get();
        Analyzer.USE_ISEA = this.USE_ISEA.get();
        Analyzer.SHOW_PATH = this.SHOW_PATH.get();
        Analyzer.reserve = new byte[(int)(this.RESERVE.get() * 0x100000L)];
        Analyzer a = new Analyzer(p);
        a.run();
        a.report();
        if (this.DUMP_STATE_SPACE.get()) {
            a.dump();
        }
    }
}

