/*
 * Decompiled with CFR 0.152.
 */
package avrora;

import avrora.Defaults;
import avrora.Version;
import avrora.actions.Action;
import avrora.core.Program;
import avrora.core.ProgramReader;
import cck.help.HelpCategory;
import cck.text.Status;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.text.Verbose;
import cck.util.Option;
import cck.util.Options;
import cck.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Main {
    static final Options mainOptions = new Options();
    public static final Option.Str INPUT = mainOptions.newOption("input", "auto", "This option selects among the available program formats as input to Avrora. For example, the default input format, \"atmel\" selects the assembly language format supported by Atmel's assembler.");
    public static final Option.Str ACTION = mainOptions.newOption("action", "simulate", "This option selects the action to perform. For example, an action might be to load a program into the simulator and run it. For more information, see the section on actions.");
    public static final Option.Bool COLORS = mainOptions.newOption("colors", true, "This option is used to enable or disable the terminal colors.");
    public static final Option.Bool BANNER = mainOptions.newOption("banner", true, "This option is used to enable or disable the printing of the banner.");
    public static final Option.Bool STATUS = mainOptions.newOption("status", true, "This option enables and disables printing of status information, for example when the simulator is loading a program.");
    public static final Option.List VERBOSE = mainOptions.newOptionList("verbose", "", "This option allows users to enable verbose printing of individual subsystems within Avrora. A list can be given with individual items separated by commas. For example: -verbose=loader,atmel.flash");
    public static final Option.Bool HELP = mainOptions.newOption("help", false, "Displays this help message.");
    public static final Option.Bool LICENSE = mainOptions.newOption("license", false, "Display the detailed copyright and license text.");
    public static final Option.Bool HTML = mainOptions.newOption("html", false, "For terminal colors. Display terminal colors as HTML tags for easier inclusion in webpages.");
    public static final Option.Str CONFIGFILE = mainOptions.newOption("config-file", "", "This option can be used to specify a file that contains additional command line options to Avrora. Any command-line option can be specified in this file. For repeated runs with similar options, the common options can be stored in this file for use over multiple runs. Options are processed in the following order: \n   1) The .avrora file in your home directory \n   2) A configuration file specified on the command line \n   3) Command line options to Avrora");

    public static void main(String[] args) {
        try {
            Main.loadUserDefaults();
            Main.parseOptions(args);
            if (!CONFIGFILE.isBlank()) {
                Main.loadFile(CONFIGFILE.get());
                Main.parseOptions(args);
            }
            if (args.length == 0 || HELP.get()) {
                Main.printHelp(mainOptions.getArguments());
            } else {
                Main.runAction();
            }
        }
        catch (Util.Error e) {
            e.report();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runAction() throws Exception {
        Main.banner();
        Action a = Defaults.getAction(ACTION.get());
        if (a == null) {
            Util.userError("Unknown Action", StringUtil.quote(ACTION.get()));
        }
        a.options.process(mainOptions);
        a.run(mainOptions.getArguments());
    }

    private static void loadUserDefaults() throws IOException {
        String hdir = System.getProperty("user.home");
        if (hdir == null || "".equals(hdir)) {
            return;
        }
        File f = new File(hdir + "/.avrora");
        if (f.exists()) {
            Properties defs = new Properties();
            defs.load(new FileInputStream(f));
            mainOptions.process(defs);
        }
    }

    private static void loadFile(String fname) throws IOException {
        Main.checkFileExists(fname);
        File f = new File(fname);
        Properties defs = new Properties();
        defs.load(new FileInputStream(f));
        mainOptions.process(defs);
    }

    static HelpCategory buildHelpCategory() {
        HelpCategory hc = new HelpCategory("main", "");
        hc.addSection("OVERVIEW", "Avrora is a tool for working with assembly language programs for the AVR architecture microcontrollers and building simulations of hardward devices based on this microcontroller.It contains tools to read AVR programs in multiple formats, perform actions on them, and generate output in multiple formats.\nTypical usage is to specify a list of files that contain a program in some format supported by Avrora and then specifying the action to perform on that program. For example, giving the name of a file that contains a program written in assembly language and a simulate action might look like: \n\navrora -action=simulate -input=atmel program.asm \n\nOther actions that are available include generating a control flow graph of the program or running one of the analysis tools on the program. See the actions section for more information.");
        hc.addOptionSection("The main options to Avrora specify the action to be performed as well as the input format and any general configuration parameters for Avrora. The available main options are listed below along with their types and default values. Each action also has its own set of options. To access help for the options related to an action, specify the name of the action along with the \"help\" option.", mainOptions);
        hc.addSubcategorySection("ADDITIONAL HELP CATEGORIES", "Additional help is available on a category by category basis. Below is a list of the additional categories available to provide help with actions, input formats, monitors, and more. To access help for a specific category, specify the \"-help\" option followed by the name of category.", Defaults.getMainCategories());
        return hc;
    }

    static void printHelp(String[] args) {
        Main.title();
        Main.printUsage();
        Main.buildAllCategories();
        if (args.length == 0) {
            Main.buildHelpCategory().printHelp();
        } else if (args.length == 1) {
            Main.printHelp(args[0]);
        } else {
            Util.userError("help available for only one category at a time.");
        }
        Main.printFooter();
    }

    private static void buildAllCategories() {
        HelpCategory hc = new HelpCategory("all", "Print a list of all categories for which help is available.");
        hc.addSection("OVERVIEW", "Avrora provides help in many categories that are all accessible from the command line.");
        hc.addSubcategorySection("ALL HELP CATEGORIES", "Below is a listing of all the help categories available.", Defaults.getAllCategories());
        Defaults.addMainCategory(hc);
    }

    private static void printUsage() {
        int[] colors = new int[]{1, -1, 2, -1, 2, -1, 11, -1, 11, -1, 11, -1};
        String[] strs = new String[]{"Usage", ": ", "avrora", " [", "-action", "=", "action", "] [", "options", "] ", "<files>"};
        Terminal.print(colors, strs);
        Terminal.nextln();
        int[] colors2 = new int[]{1, -1, 2, -1, 11, -1};
        String[] strs2 = new String[]{"Usage", ": ", "avrora -help", " [", "category", "]"};
        Terminal.print(colors2, strs2);
        Terminal.println("\n");
    }

    private static void printFooter() {
        Terminal.println("For more information, see the online documentation at ");
        Terminal.printCyan("http://compilers.cs.ucla.edu/avrora");
        Terminal.nextln();
        Terminal.println("To report bugs or seek help, consult the Avrora mailing list: ");
        Terminal.printCyan("http://lists.ucla.edu/cgi-bin/mailman/listinfo/avrora");
        Terminal.nextln();
        Terminal.print("Please include the version number [");
        Terminal.printBrightBlue(Version.TAG.toString());
        Terminal.print("] when posting to the list.");
        Terminal.nextln();
    }

    private static void printHelp(String a) {
        HelpCategory hc = Defaults.getHelpCategory(a);
        hc.printHelp();
    }

    static void banner() {
        if (!BANNER.get()) {
            return;
        }
        Main.title();
        if (LICENSE.get()) {
            String notice = "Copyright (c) 2003-2007, Regents of the University of California \nAll rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:\n\nRedistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.\n\nRedistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.\n\nNeither the name of the University of California, Los Angeles nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.\n\nTHIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\n";
            Terminal.print(StringUtil.formatParagraphs(notice, 0, 0, 78));
        }
    }

    static void title() {
        Terminal.printBrightBlue("Avrora ");
        Terminal.print("[");
        Terminal.printBrightBlue(Version.TAG.toString());
        Terminal.print("]");
        Terminal.print(" - (c) 2003-2007 UCLA Compilers Group\n\n");
    }

    public static void parseOptions(String[] args) {
        mainOptions.parseCommandLine(args);
        Terminal.useColors = COLORS.get();
        Terminal.htmlColors = HTML.get();
        Status.ENABLED = STATUS.get();
        List verbose = VERBOSE.get();
        Iterator i = verbose.iterator();
        while (i.hasNext()) {
            Verbose.setVerbose((String)i.next(), true);
        }
    }

    public static Program loadProgram(String[] args) throws Exception {
        Status.begin("Loading " + args[0]);
        ProgramReader reader = Defaults.getProgramReader(INPUT.get());
        reader.options.process(mainOptions);
        Program program = reader.read(args);
        Status.success();
        return program;
    }

    public static void checkFilesExist(String[] files) {
        for (int cntr = 0; cntr < files.length; ++cntr) {
            Main.checkFileExists(files[cntr]);
        }
    }

    public static void checkFileExists(String fstr) {
        File f = new File(fstr);
        if (!f.exists()) {
            Util.userError("File not found", fstr);
        }
    }
}

