/*
 * Decompiled with CFR 0.152.
 */
package avrora;

import avrora.actions.Action;
import avrora.actions.AnalyzeStackAction;
import avrora.actions.CFGAction;
import avrora.actions.DisassembleAction;
import avrora.actions.ELFDumpAction;
import avrora.actions.GUIAction;
import avrora.actions.ISEAAction;
import avrora.actions.SimAction;
import avrora.actions.TestAction;
import avrora.arch.ArchitectureRegistry;
import avrora.core.Program;
import avrora.core.ProgramReader;
import avrora.monitors.BreakMonitor;
import avrora.monitors.CallMonitor;
import avrora.monitors.CallTimeMonitor;
import avrora.monitors.CallTreeProfiler;
import avrora.monitors.EnergyMonitor;
import avrora.monitors.EnergyProfiler;
import avrora.monitors.GDBServer;
import avrora.monitors.IORegMonitor;
import avrora.monitors.InteractiveMonitor;
import avrora.monitors.InterruptMonitor;
import avrora.monitors.LEDMonitor;
import avrora.monitors.MemoryMonitor;
import avrora.monitors.MonitorFactory;
import avrora.monitors.PacketMonitor;
import avrora.monitors.PrintMonitor;
import avrora.monitors.ProfileMonitor;
import avrora.monitors.RealTimeMonitor;
import avrora.monitors.SPIMonitor;
import avrora.monitors.SerialMonitor;
import avrora.monitors.SimPerfMonitor;
import avrora.monitors.SleepMonitor;
import avrora.monitors.SnifferMonitor;
import avrora.monitors.StackMonitor;
import avrora.monitors.TimerMonitor;
import avrora.monitors.TraceMonitor;
import avrora.monitors.TripTimeMonitor;
import avrora.monitors.VirgilMonitor;
import avrora.sim.Simulation;
import avrora.sim.Simulator;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ATMega128;
import avrora.sim.mcu.ATMega16;
import avrora.sim.mcu.ATMega32;
import avrora.sim.mcu.MicrocontrollerFactory;
import avrora.sim.platform.Mica2;
import avrora.sim.platform.MicaZ;
import avrora.sim.platform.PlatformFactory;
import avrora.sim.platform.Seres;
import avrora.sim.platform.Superbot;
import avrora.sim.platform.Telos;
import avrora.sim.types.SensorSimulation;
import avrora.sim.types.SingleSimulation;
import avrora.sim.types.WiredSimulation;
import avrora.syntax.atmel.AtmelProgramReader;
import avrora.syntax.elf.ELFParser;
import avrora.syntax.objdump.ODPPAction;
import avrora.syntax.objdump.ObjDump2ProgramReader;
import avrora.syntax.objdump.ObjDumpProgramReader;
import avrora.syntax.raw.RAWReader;
import avrora.test.DisassemblerTestHarness;
import avrora.test.InterruptTestHarness;
import avrora.test.ProbeTestHarness;
import avrora.test.SimplifierTestHarness;
import avrora.test.sim.SimTestHarness;
import cck.help.HelpCategory;
import cck.help.HelpSystem;
import cck.test.TestEngine;
import cck.text.StringUtil;
import cck.util.ClassMap;
import cck.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Defaults {
    private static final HashMap mainCategories = new HashMap();
    private static ClassMap microcontrollers;
    private static ClassMap platforms;
    private static ClassMap actions;
    private static ClassMap inputs;
    private static ClassMap harnessMap;
    private static ClassMap monitorMap;
    private static ClassMap simMap;

    private static synchronized void addAll() {
        Defaults.addMicrocontrollers();
        Defaults.addPlatforms();
        Defaults.addActions();
        Defaults.addInputFormats();
        Defaults.addTestHarnesses();
        Defaults.addMonitors();
        Defaults.addSimulations();
        ArchitectureRegistry.addArchitectures();
    }

    private static synchronized void addMonitors() {
        if (monitorMap == null) {
            monitorMap = new ClassMap("Monitor", MonitorFactory.class);
            monitorMap.addClass("calls", CallMonitor.class);
            monitorMap.addClass("break", BreakMonitor.class);
            monitorMap.addClass("c-print", PrintMonitor.class);
            monitorMap.addClass("c-timer", TimerMonitor.class);
            monitorMap.addClass("profile", ProfileMonitor.class);
            monitorMap.addClass("memory", MemoryMonitor.class);
            monitorMap.addClass("sleep", SleepMonitor.class);
            monitorMap.addClass("leds", LEDMonitor.class);
            monitorMap.addClass("stack", StackMonitor.class);
            monitorMap.addClass("energy", EnergyMonitor.class);
            monitorMap.addClass("interrupts", InterruptMonitor.class);
            monitorMap.addClass("interactive", InteractiveMonitor.class);
            monitorMap.addClass("trace", TraceMonitor.class);
            monitorMap.addClass("energy-profile", EnergyProfiler.class);
            monitorMap.addClass("packet", PacketMonitor.class);
            monitorMap.addClass("gdb", GDBServer.class);
            monitorMap.addClass("simperf", SimPerfMonitor.class);
            monitorMap.addClass("serial", SerialMonitor.class);
            monitorMap.addClass("spi", SPIMonitor.class);
            monitorMap.addClass("call-time", CallTimeMonitor.class);
            monitorMap.addClass("call-profile", CallTreeProfiler.class);
            monitorMap.addClass("trip-time", TripTimeMonitor.class);
            monitorMap.addClass("ioregs", IORegMonitor.class);
            monitorMap.addClass("virgil", VirgilMonitor.class);
            monitorMap.addClass("real-time", RealTimeMonitor.class);
            monitorMap.addClass("sniffer", SnifferMonitor.class);
            HelpCategory hc = new HelpCategory("monitors", "Help for the supported simulation monitors.");
            hc.addOptionValueSection("SIMULATION MONITORS", "Avrora's simulator offers the ability to install execution monitors that instrument the program in order to study and analyze its behavior. The \"simulate\" action supports this option that allows a monitor class to be loaded which will instrument the program before it is run and then generate a report after the program has completed execution.", "-monitors", monitorMap);
            Defaults.addMainCategory(hc);
            Defaults.addSubCategories(monitorMap);
        }
    }

    private static synchronized void addTestHarnesses() {
        if (harnessMap == null) {
            harnessMap = new ClassMap("Test Harness", TestEngine.Harness.class);
            harnessMap.addClass("simulator", SimTestHarness.class);
            harnessMap.addClass("simplifier", SimplifierTestHarness.class);
            harnessMap.addClass("probes", ProbeTestHarness.class);
            harnessMap.addClass("disassembler", DisassemblerTestHarness.class);
            harnessMap.addClass("interrupt", InterruptTestHarness.class);
        }
    }

    private static synchronized void addInputFormats() {
        if (inputs == null) {
            inputs = new ClassMap("Input Format", ProgramReader.class);
            inputs.addClass("auto", AutoProgramReader.class);
            inputs.addClass("raw", RAWReader.class);
            inputs.addClass("atmel", AtmelProgramReader.class);
            inputs.addClass("objdump", ObjDumpProgramReader.class);
            inputs.addClass("odpp", ObjDump2ProgramReader.class);
            inputs.addClass("elf", ELFParser.class);
            HelpCategory hc = new HelpCategory("inputs", "Help for the supported program input formats.");
            hc.addOptionValueSection("INPUT FORMATS", "The input format of the program is specified with the \"-input\" option supplied at the command line. This input format is used by actions that operate on programs to determine how to interpret the input and build a program from the files specified. For example, the input format might be Atmel syntax, GAS syntax, or the output of a disassembler such as avr-objdump. Currently no binary formats are supported.", "-input", inputs);
            Defaults.addMainCategory(hc);
            Defaults.addSubCategories(inputs);
        }
    }

    private static synchronized void addActions() {
        if (actions == null) {
            actions = new ClassMap("Action", Action.class);
            actions.addClass("disassemble", DisassembleAction.class);
            actions.addClass("simulate", SimAction.class);
            actions.addClass("analyze-stack", AnalyzeStackAction.class);
            actions.addClass("test", TestAction.class);
            actions.addClass("cfg", CFGAction.class);
            actions.addClass("gui", GUIAction.class);
            actions.addClass("isea", ISEAAction.class);
            actions.addClass("odpp", ODPPAction.class);
            actions.addClass("elf-dump", ELFDumpAction.class);
            HelpCategory hc = new HelpCategory("actions", "Help for Avrora actions.");
            hc.addOptionValueSection("ACTIONS", "Avrora accepts the \"-action\" command line option that you can use to select from the available functionality that Avrora provides. This action might be to assemble the file, print a listing, perform a simulation, or run an analysis tool. This flexibility allows this single frontend to select from multiple useful tools. The currently supported actions are given below.", "-action", actions);
            Defaults.addMainCategory(hc);
            Defaults.addSubCategories(actions);
        }
    }

    private static synchronized void addSimulations() {
        if (simMap == null) {
            simMap = new ClassMap("Simulation", Simulation.class);
            simMap.addClass("single", SingleSimulation.class);
            simMap.addClass("sensor-network", SensorSimulation.class);
            simMap.addClass("wired", WiredSimulation.class);
            HelpCategory hc = new HelpCategory("simulations", "Help for supported simulation types.");
            hc.addOptionValueSection("SIMULATION TYPES", "When running a simulation, Avrora accepts the \"-simulation\" command line option that selects the simulation type from multiple different types provided, or a user-supplied Java class of your own. For example, a simulation might be for a sensor network application, a single node simulation, or a robotics simulation. ", "-simulation", simMap);
            Defaults.addMainCategory(hc);
            Defaults.addSubCategories(simMap);
        }
    }

    private static synchronized void addPlatforms() {
        if (platforms == null) {
            platforms = new ClassMap("Platform", PlatformFactory.class);
            platforms.addClass("mica2", Mica2.Factory.class);
            platforms.addClass("micaz", MicaZ.Factory.class);
            platforms.addClass("seres", Seres.Factory.class);
            platforms.addClass("superbot", Superbot.Factory.class);
            platforms.addClass("telos", Telos.Factory.class);
        }
    }

    private static synchronized void addMicrocontrollers() {
        if (microcontrollers == null) {
            microcontrollers = new ClassMap("Microcontroller", MicrocontrollerFactory.class);
            microcontrollers.addInstance("atmega128", new ATMega128.Factory());
            microcontrollers.addInstance("atmega32", new ATMega32.Factory());
            microcontrollers.addInstance("atmega16", new ATMega16.Factory());
        }
    }

    public static MicrocontrollerFactory getMicrocontroller(String s) {
        Defaults.addMicrocontrollers();
        return (MicrocontrollerFactory)microcontrollers.getObjectOfClass(s);
    }

    public static PlatformFactory getPlatform(String s) {
        Defaults.addPlatforms();
        return (PlatformFactory)platforms.getObjectOfClass(s);
    }

    public static ProgramReader getProgramReader(String s) {
        Defaults.addInputFormats();
        return (ProgramReader)inputs.getObjectOfClass(s);
    }

    public static Action getAction(String s) {
        Defaults.addActions();
        return (Action)actions.getObjectOfClass(s);
    }

    public static MonitorFactory getMonitor(String s) {
        Defaults.addMonitors();
        return (MonitorFactory)monitorMap.getObjectOfClass(s);
    }

    public static Simulation getSimulation(String s) {
        Defaults.addSimulations();
        return (Simulation)simMap.getObjectOfClass(s);
    }

    public static ClassMap getTestHarnessMap() {
        Defaults.addTestHarnesses();
        return harnessMap;
    }

    public static List getActionList() {
        Defaults.addActions();
        return actions.getSortedList();
    }

    public static List getProgramReaderList() {
        Defaults.addInputFormats();
        return inputs.getSortedList();
    }

    public static void addSubCategories(ClassMap vals) {
        List l = vals.getSortedList();
        for (String val : l) {
            Class cz = vals.getClass(val);
            if (!HelpCategory.class.isAssignableFrom(cz)) continue;
            HelpSystem.addCategory(val, cz);
        }
    }

    public static void addMainCategory(HelpCategory cat) {
        HelpSystem.addCategory(cat.name, cat);
        mainCategories.put(cat.name, cat);
    }

    public static HelpCategory getHelpCategory(String name) {
        Defaults.addAll();
        return HelpSystem.getCategory(name);
    }

    public static List getMainCategories() {
        Defaults.addAll();
        ArrayList list = Collections.list(Collections.enumeration(mainCategories.values()));
        Collections.sort(list, HelpCategory.COMPARATOR);
        return list;
    }

    public static List getAllCategories() {
        Defaults.addAll();
        List l = HelpSystem.getSortedList();
        LinkedList<HelpCategory> nl = new LinkedList<HelpCategory>();
        for (String s : l) {
            nl.addLast(HelpSystem.getCategory(s));
        }
        return nl;
    }

    public static Simulator newSimulator(int id, Program p) {
        return Defaults.newSimulator(id, "atmega128", 8000000L, 8000000L, p);
    }

    public static Simulator newSimulator(int id, String mcu, long hz, long exthz, Program p) {
        MicrocontrollerFactory f = Defaults.getMicrocontroller(mcu);
        ClockDomain cd = new ClockDomain(hz);
        cd.newClock("external", exthz);
        return f.newMicrocontroller(id, cd, p).getSimulator();
    }

    public static class AutoProgramReader
    extends ProgramReader {
        public AutoProgramReader() {
            super("The \"auto\" input format reads a program from a single file at a time. It uses the extension of the filename as a clue to decide what input reader to use for that file. For example, an extension of \".asm\" is considered to be a program in Atmel assembly syntax.");
        }

        public Program read(String[] args) throws Exception {
            String n;
            int offset;
            if (args.length == 0) {
                Util.userError("no input files");
            }
            if (args.length != 1) {
                Util.userError("input type \"auto\" accepts only one file at a time.");
            }
            if ((offset = (n = args[0]).lastIndexOf(46)) < 0) {
                Util.userError("file " + StringUtil.quote(n) + " does not have an extension");
            }
            String extension = n.substring(offset).toLowerCase();
            ProgramReader reader = null;
            if (".asm".equals(extension)) {
                reader = new AtmelProgramReader();
            } else if (".od".equals(extension)) {
                reader = new ObjDumpProgramReader();
            } else if (".odpp".equals(extension)) {
                reader = new ObjDump2ProgramReader();
            } else if (".elf".equals(extension)) {
                reader = new ELFParser();
            }
            if (reader == null) {
                Util.userError("file extension " + StringUtil.quote(extension) + " unknown");
                return null;
            }
            reader.INDIRECT_EDGES.set(this.INDIRECT_EDGES.stringValue());
            reader.ARCH.set(this.ARCH.stringValue());
            reader.options.process(this.options);
            return reader.read(args);
        }
    }
}

