/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.tunnel;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.NetworkInterface;

public class TSPClient
implements NetworkInterface {
    public static final boolean DEBUG = false;
    public static final int DEFAULT_PORT = 3653;
    private static final byte[] VERSION = "VERSION=2.0.0\r\n".getBytes();
    private static final byte[] AUTH_PLAIN = "AUTHENTICATE PLAIN\r\b".getBytes();
    private static final byte[] AUTH_ANON = "AUTHENTICATE ANONYMOUS\r\b".getBytes();
    private static final Pattern prefixPattern = Pattern.compile("(?m).+?<prefix (.+?)>(.+?)</prefix>");
    private static final Pattern myIPPattern = Pattern.compile("(?s).+?<client>.+?ipv6\">(.+?)</address>");
    private IPStack ipStack;
    WriterState writerState = WriterState.STARTED;
    ReaderState readerState = ReaderState.CAP_EXPECTED;
    DatagramSocket connection;
    DatagramPacket receiveP;
    InetAddress serverAddr;
    int seq = 0;
    private String user;
    private String password;
    private boolean userLoggedIn = false;
    int wWait = 0;

    public TSPClient(String host) throws SocketException, UnknownHostException {
        this(host, null, null);
    }

    public TSPClient(String host, String user, String password) throws SocketException, UnknownHostException {
        this.user = user;
        this.password = password;
        this.connection = new DatagramSocket();
        this.serverAddr = InetAddress.getByName(host);
        this.receiveP = new DatagramPacket(new byte[1280], 1280);
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                try {
                    TSPClient.this.writer();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    TSPClient.this.reader();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(writer).start();
        new Thread(reader).start();
    }

    @Override
    public String getName() {
        return "tsp";
    }

    public static TSPClient startTSPTunnel(IPStack ipStack, String server, String user, String password) {
        try {
            TSPClient tunnel = new TSPClient(server, user, password);
            tunnel.setIPStack(ipStack);
            tunnel.waitSetup();
            return tunnel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setIPStack(IPStack ipStack) {
        this.ipStack = ipStack;
    }

    @Override
    public boolean isReady() {
        return this.writerState == WriterState.TUNNEL_UP;
    }

    private void writer() throws IOException, InterruptedException {
        System.out.println("Writer started. sending version...");
        block8: while (true) {
            switch (this.writerState) {
                case STARTED: {
                    this.sendPacket(VERSION);
                    this.setReaderState(ReaderState.CAP_EXPECTED, WriterState.WAIT);
                    continue block8;
                }
                case WAIT: {
                    Thread.sleep(100L);
                    ++this.wWait;
                    if (this.wWait <= 10) continue block8;
                    System.out.println("Waited for " + this.wWait);
                    continue block8;
                }
                case CAPABILITIES_RECEIVED: {
                    System.out.println("Writer: sending AUTH");
                    if (this.user == null) {
                        this.sendPacket(AUTH_ANON);
                        this.setReaderState(ReaderState.AUTH_OK_EXPECTED, WriterState.WAIT);
                        continue block8;
                    }
                    this.sendPacket(AUTH_PLAIN);
                    this.setReaderState(ReaderState.AUTH_ACK_EXPECTED, WriterState.WAIT);
                    continue block8;
                }
                case AUTHENTICATE_REQ_OK: {
                    if (this.user == null || this.userLoggedIn) {
                        this.sendTunnelReq();
                        this.setReaderState(ReaderState.TUNNEL_CONF_EXPECTED, WriterState.WAIT);
                        continue block8;
                    }
                    this.sendAuth();
                    this.userLoggedIn = true;
                    this.setReaderState(ReaderState.AUTH_OK_EXPECTED, WriterState.WAIT);
                    continue block8;
                }
                case TUNNEL_CONF_RECEIVED: {
                    String accept = "<tunnel action=\"accept\"></tunnel>\r\n";
                    accept = "Content-length: " + accept.length() + "\r\n" + accept;
                    this.sendPacket(accept.getBytes());
                    System.out.println("*** Tunnel UP!");
                    this.setReaderState(ReaderState.TUNNEL_UP, WriterState.TUNNEL_UP);
                    this.notifyReady();
                    continue block8;
                }
                case TUNNEL_UP: {
                    Thread.sleep(100L);
                    continue block8;
                }
            }
            System.out.println("In mode: " + (Object)((Object)this.writerState));
            Thread.sleep(1000L);
        }
    }

    private synchronized void notifyReady() {
        this.notifyAll();
    }

    private void sendAuth() throws IOException {
        String auth = "\u0000" + this.user + "\u0000" + this.password + "\r\n";
        this.sendPacket(auth.getBytes());
    }

    private void sendTunnelReq() throws IOException {
        InetAddress myAddr = InetAddress.getLocalHost();
        byte[] addr = myAddr.getAddress();
        String myAddress = String.format("%d.%d.%d.%d", addr[0] & 0xFF, addr[1] & 0xFF, addr[2] & 0xFF, addr[3] & 0xFF);
        String router = "";
        if (this.user != null) {
            router = "<router><prefix length=\"64\"/></router>";
        }
        String tunnelConf = "<tunnel action=\"create\" type=\"v6udpv4\"><client><address type=\"ipv4\">" + myAddress + "</address><keepalive interval=\"30\"></keepalive>" + router + "</client></tunnel>\r\n";
        tunnelConf = "Content-length: " + tunnelConf.length() + "\r\n" + tunnelConf;
        this.sendPacket(tunnelConf.getBytes());
    }

    private void setReaderState(ReaderState rs, WriterState ws) {
        this.readerState = rs;
        this.writerState = ws;
        this.wWait = 0;
    }

    private void reader() throws IOException {
        while (true) {
            System.out.println("Receiving packet...");
            this.connection.receive(this.receiveP);
            System.out.println("TSPClient: Packet received: " + this.receiveP.getLength());
            byte[] data = this.receiveP.getData();
            int i = 0;
            int n = this.receiveP.getLength();
            while (i < n) {
                if (i < 8 || this.writerState == WriterState.TUNNEL_UP) {
                    System.out.printf("%02x", data[i]);
                } else {
                    System.out.print((char)data[i]);
                }
                ++i;
            }
            String sData = new String(data, 8, this.receiveP.getLength() - 8);
            switch (this.readerState) {
                case CAP_EXPECTED: {
                    this.writerState = WriterState.CAPABILITIES_RECEIVED;
                    break;
                }
                case AUTH_ACK_EXPECTED: {
                    this.writerState = WriterState.AUTHENTICATE_REQ_OK;
                    break;
                }
                case AUTH_OK_EXPECTED: {
                    this.writerState = WriterState.AUTHENTICATE_REQ_OK;
                    break;
                }
                case TUNNEL_CONF_EXPECTED: {
                    byte[] prefix;
                    Matcher m;
                    if (this.user != null) {
                        m = prefixPattern.matcher(sData);
                        if (m.find()) {
                            System.out.println("Prefix: " + m.group(2) + " arg:" + m.group(1));
                            if (this.ipStack != null) {
                                prefix = this.getPrefix(m.group(2));
                                this.ipStack.setPrefix(prefix, 64);
                            }
                        }
                    } else {
                        m = myIPPattern.matcher(sData);
                        if (m.find()) {
                            if (this.ipStack != null) {
                                System.out.println("### Got IP address: " + m.group(1));
                                prefix = this.getPrefix(m.group(1));
                                byte[] macAddr = new byte[8];
                                this.ipStack.makeLLAddress(prefix, macAddr);
                                this.ipStack.setLinkLayerAddress(macAddr);
                                this.ipStack.setIPAddress(prefix);
                            }
                        } else {
                            System.out.println("NOT MATCH!!!");
                        }
                    }
                    this.writerState = WriterState.TUNNEL_CONF_RECEIVED;
                    break;
                }
                case TUNNEL_UP: {
                    System.out.println("*** Tunneled packet received!!!");
                    if (this.ipStack == null) break;
                    IPv6Packet packet = new IPv6Packet();
                    packet.setBytes(data, 0, this.receiveP.getLength());
                    packet.parsePacketData(packet);
                    packet.netInterface = this;
                    this.ipStack.receivePacket(packet);
                }
            }
        }
    }

    private byte[] getPrefix(String prefix) {
        prefix = prefix.trim();
        String[] parts = prefix.split(":");
        byte[] prefixBytes = new byte[parts.length * 2];
        int i = 0;
        while (i < parts.length) {
            System.out.println("## Parsing: " + parts[i]);
            int val = Integer.parseInt(parts[i], 16);
            prefixBytes[i * 2] = (byte)(val >> 8);
            prefixBytes[i * 2 + 1] = (byte)(val & 0xFF);
            ++i;
        }
        return prefixBytes;
    }

    private void sendPacket(byte[] packetData) throws IOException {
        byte[] pData;
        if (this.writerState != WriterState.TUNNEL_UP) {
            pData = new byte[8 + packetData.length];
            pData[0] = (byte)(0xF0 | this.seq >> 24 & 0xF);
            pData[1] = (byte)(this.seq >> 16 & 0xFF);
            pData[2] = (byte)(this.seq >> 8 & 0xFF);
            pData[3] = (byte)(this.seq & 0xFF);
            long time = System.currentTimeMillis() / 1000L;
            pData[4] = (byte)(time >> 24 & 0xFFL);
            pData[5] = (byte)(time >> 16 & 0xFFL);
            pData[6] = (byte)(time >> 8 & 0xFFL);
            pData[7] = (byte)(time >> 0 & 0xFFL);
            ++this.seq;
            System.arraycopy(packetData, 0, pData, 8, packetData.length);
        } else {
            pData = packetData;
        }
        DatagramPacket packet = new DatagramPacket(pData, pData.length, this.serverAddr, 3653);
        this.connection.send(packet);
    }

    @Override
    public void sendPacket(IPv6Packet packet) {
        byte[] data = packet.generatePacketData(packet);
        try {
            this.sendPacket(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws UnknownHostException, IOException {
        if (args.length == 1) {
            TSPClient tspc = new TSPClient(args[0]);
        } else if (args.length == 3) {
            TSPClient tSPClient = new TSPClient(args[0], args[1], args[2]);
        }
    }

    public synchronized boolean waitSetup() {
        if (!this.isReady()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.isReady();
    }

    static enum ReaderState {
        CAP_EXPECTED,
        AUTH_ACK_EXPECTED,
        AUTH_OK_EXPECTED,
        TUNNEL_CONF_EXPECTED,
        TUNNEL_UP;

    }

    static enum WriterState {
        WAIT,
        STARTED,
        CAPABILITIES_RECEIVED,
        AUTHENTICATE_REQ_OK,
        TUNNEL_CONF_RECEIVED,
        TUNNEL_UP;

    }
}

