/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.mac;

import se.sics.jipv6.core.AbstractPacketHandler;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.NetworkInterface;
import se.sics.jipv6.core.Packet;

public class LoWPANHandler
extends AbstractPacketHandler
implements NetworkInterface {
    private static final boolean DEBUG = false;
    private IPStack ipStack;

    @Override
    public void setIPStack(IPStack stack) {
        this.ipStack = stack;
    }

    @Override
    public String getName() {
        return "6lowpan";
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void packetReceived(Packet packet) {
        IPv6Packet ipPacket = new IPv6Packet(packet);
        byte dispatch = packet.getData(0);
        packet.setAttribute("6lowpan.dispatch", dispatch);
        ipPacket.incPos(1);
        if (dispatch == this.ipStack.getDefaultPacketer().getDispatch()) {
            this.ipStack.getDefaultPacketer().parsePacketData(ipPacket);
            ipPacket.netInterface = this;
            this.ipStack.receivePacket(ipPacket);
        }
    }

    @Override
    public void sendPacket(IPv6Packet packet) {
        byte[] data = this.ipStack.getPacketer().generatePacketData(packet);
        packet.setBytes(data);
        byte[] data2 = new byte[]{this.ipStack.getPacketer().getDispatch()};
        packet.prependBytes(data2);
        this.lowerLayer.sendPacket(packet);
    }

    @Override
    public void sendPacket(Packet packet) {
        this.sendPacket((IPv6Packet)packet);
    }
}

