/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.mac;

import java.io.PrintStream;
import se.sics.jipv6.core.AbstractPacketHandler;
import se.sics.jipv6.core.Packet;
import se.sics.jipv6.util.Utils;

public class IEEE802154Handler
extends AbstractPacketHandler {
    public static final String SOURCE_PAN_ID = "802154.sourcePAN";
    public static final String SOURCE_MODE = "802154.sourceMode";
    public static final String DESTINATION_PAN_ID = "802154.destPAN";
    public static final String DESTINATION_MODE = "802154.destMode";
    public static final String VERSION = "802154.version";
    public static final String SEQ_NO = "802154.seqno";
    public static final String PAYLOAD_LEN = "802154.len";
    public static final int BEACONFRAME = 0;
    public static final int DATAFRAME = 1;
    public static final int ACKFRAME = 2;
    public static final int CMDFRAME = 3;
    public static final int SHORT_ADDRESS = 2;
    public static final int LONG_ADDRESS = 3;
    private static final byte[] BROADCAST_ADDR = new byte[]{-1, -1};
    private int defaultAddressMode = 3;
    private byte seqNo = 0;
    private int myPanID = 43981;

    @Override
    public void packetReceived(Packet packet) {
        int type = packet.getData(0) & 7;
        int security = packet.getData(0) >> 3 & 1;
        int pending = packet.getData(0) >> 4 & 1;
        int ackRequired = packet.getData(0) >> 5 & 1;
        int panCompression = packet.getData(0) >> 6 & 1;
        int destAddrMode = packet.getData(1) >> 2 & 3;
        int frameVersion = packet.getData(1) >> 4 & 3;
        int srcAddrMode = packet.getData(1) >> 6 & 3;
        byte seqNumber = packet.getData(2);
        int pos = 3;
        int destPanID = 0;
        if (destAddrMode > 0) {
            destPanID = (packet.getData(pos) & 0xFF) + ((packet.getData(pos + 1) & 0xFF) << 8);
            packet.setAttribute(DESTINATION_PAN_ID, destPanID);
            byte[] destAddress = null;
            pos += 2;
            if (destAddrMode == 2) {
                destAddress = new byte[2];
                destAddress[1] = packet.getData(pos);
                destAddress[0] = packet.getData(pos + 1);
                pos += 2;
            } else if (destAddrMode == 3) {
                destAddress = new byte[8];
                int i = 0;
                while (i < 8) {
                    destAddress[i] = packet.getData(pos + 7 - i);
                    ++i;
                }
                pos += 8;
            }
            packet.setAttribute(DESTINATION_MODE, destAddrMode);
            packet.setAttribute("link.destination", destAddress);
        }
        if (srcAddrMode > 0) {
            int srcPanID = 0;
            if (panCompression == 0) {
                srcPanID = (packet.getData(pos) & 0xFF) + ((packet.getData(pos + 1) & 0xFF) << 8);
                pos += 2;
            } else {
                srcPanID = destPanID;
            }
            packet.setAttribute(SOURCE_PAN_ID, srcPanID);
            byte[] sourceAddress = null;
            if (srcAddrMode == 2) {
                sourceAddress = new byte[2];
                sourceAddress[1] = packet.getData(pos);
                sourceAddress[0] = packet.getData(pos + 1);
                pos += 2;
            } else if (srcAddrMode == 3) {
                sourceAddress = new byte[8];
                int i = 0;
                while (i < 8) {
                    sourceAddress[i] = packet.getData(pos + 7 - i);
                    ++i;
                }
                pos += 8;
            }
            packet.setAttribute(SOURCE_MODE, srcAddrMode);
            packet.setAttribute("link.source", sourceAddress);
        }
        packet.incPos(pos);
        packet.setAttribute(PAYLOAD_LEN, packet.getPayloadLength());
        packet.setAttribute(VERSION, frameVersion);
        packet.setAttribute(SEQ_NO, seqNumber);
        System.out.println("802.15.4 Consumed " + pos + " bytes");
        this.dispatch(-1, packet);
    }

    @Override
    public void sendPacket(Packet packet) {
        System.out.println("Packet should be sent!!!");
        byte[] buffer = new byte[127];
        int pos = 0;
        int destPanID = 43981;
        buffer[0] = 1;
        int destMode = this.defaultAddressMode;
        int srcMode = this.defaultAddressMode;
        int frameVersion = 0;
        if (Utils.equals(packet.getLinkDestination(), BROADCAST_ADDR)) {
            destMode = 2;
            destPanID = 65535;
        }
        buffer[1] = (byte)(destMode << 2 | frameVersion << 4 | srcMode << 6);
        this.seqNo = (byte)(this.seqNo + 1);
        pos = 3;
        buffer[pos++] = (byte)(destPanID & 0xFF);
        buffer[pos++] = (byte)(destPanID >> 8);
        byte[] dest = packet.getLinkDestination();
        int i = 0;
        while (i < dest.length) {
            buffer[pos++] = dest[dest.length - i - 1];
            ++i;
        }
        buffer[pos++] = (byte)(this.myPanID & 0xFF);
        buffer[pos++] = (byte)(this.myPanID >> 8);
        byte[] src = packet.getLinkSource();
        int i2 = 0;
        while (i2 < src.length) {
            buffer[pos++] = src[src.length - i2 - 1];
            ++i2;
        }
        byte[] pHeader = new byte[pos];
        System.arraycopy(buffer, 0, pHeader, 0, pos);
        packet.prependBytes(pHeader);
        this.lowerLayer.sendPacket(packet);
    }

    @Override
    public void printPacket(PrintStream out, Packet packet) {
        out.print("802.15.4 from " + Utils.hex16(packet.getAttributeAsInt(SOURCE_PAN_ID)) + "/");
        this.printAddress(out, packet.getAttributeAsInt(SOURCE_MODE), (byte[])packet.getAttribute("link.source"));
        out.print(" to " + Utils.hex16(packet.getAttributeAsInt(DESTINATION_PAN_ID)) + "/");
        this.printAddress(out, packet.getAttributeAsInt(DESTINATION_MODE), (byte[])packet.getAttribute("link.destination"));
        out.println(" seqNo: " + packet.getAttributeAsInt(SEQ_NO) + " vers: " + packet.getAttributeAsInt(VERSION) + " len: " + packet.getAttributeAsInt(PAYLOAD_LEN));
    }

    private void printAddress(PrintStream out, int type, byte[] addr) {
        if (type == 2) {
            out.print(String.valueOf(Utils.hex8(addr[0])) + Utils.hex8(addr[1]));
        } else if (type == 3) {
            out.print(String.valueOf(Utils.hex8(addr[0])) + Utils.hex8(addr[1]) + ":" + Utils.hex8(addr[2]) + Utils.hex8(addr[3]) + ":" + Utils.hex8(addr[4]) + Utils.hex8(addr[5]) + ":" + Utils.hex8(addr[6]) + Utils.hex8(addr[7]));
        }
    }
}

