/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.TCPConnection;
import se.sics.jipv6.core.TCPListener;
import se.sics.jipv6.core.TCPPacket;
import se.sics.jipv6.http.HttpServlet;
import se.sics.jipv6.http.HttpServletRequest;
import se.sics.jipv6.http.HttpServletResponse;

public class HttpServer
implements TCPListener,
Runnable {
    private IPStack ipStack;
    private TCPConnection serverConnection;
    private Hashtable servlets = new Hashtable();
    private Vector pending = new Vector();
    private String status = "";

    public HttpServer(IPStack stack) {
        this.ipStack = stack;
        this.serverConnection = this.ipStack.listen(80);
        this.serverConnection.setTCPListener(this);
        new Thread(this).start();
    }

    @Override
    public void connectionClosed(TCPConnection connection) {
    }

    @Override
    public void newConnection(TCPConnection connection) {
        this.handleConnection(connection);
    }

    @Override
    public void tcpDataReceived(TCPConnection source, TCPPacket packet) {
    }

    public void registerServlet(String path, HttpServlet servlet) {
        this.servlets.put(path, servlet);
    }

    private synchronized void handleConnection(TCPConnection connection) {
        System.out.println("%%% HttpServer: gotten new connection, adding to pending...");
        this.pending.addElement(connection);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handlePendingConnections() {
        while (true) {
            TCPConnection connection = null;
            HttpServer httpServer = this;
            synchronized (httpServer) {
                while (true) {
                    if (this.pending.size() != 0) {
                        this.status = "got connection";
                        connection = (TCPConnection)this.pending.firstElement();
                        this.pending.removeElementAt(0);
                        break;
                    }
                    try {
                        System.out.println("%%% HttpServer: worker waiting...");
                        this.status = "waiting for connections";
                        this.wait();
                        System.out.println("%%% HttpServer: worker notified...");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            InputStream input = connection.getInputStream();
            OutputStream output = connection.getOutputStream();
            connection.setTimeout(5000);
            try {
                try {
                    System.out.println("%%% HttpServer: reading req line from: " + input);
                    this.status = "reading request line";
                    String reqLine = this.readLine(input);
                    reqLine = reqLine.trim();
                    if (!this.handleRequest(reqLine, input, output, connection)) {
                        output.write("HTTP/1.0 404 NOT FOUND\r\n\r\n".getBytes());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        output.close();
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    connection.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                connection.close();
                throw throwable;
            }
            try {
                output.close();
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            connection.close();
        }
    }

    private boolean handleRequest(String reqLine, InputStream input, OutputStream output, TCPConnection connection) throws IOException {
        int space = reqLine.indexOf(32);
        if (space != -1) {
            String method = reqLine.substring(0, space);
            String path = reqLine.substring(space + 1, reqLine.lastIndexOf(32));
            System.out.println("Method: " + method);
            System.out.println("Path: " + path);
            int query = reqLine.indexOf(63);
            if (query > 0) {
                path = path.substring(0, query);
            }
            this.status = "finding servlet: " + path;
            HttpServlet servlet = (HttpServlet)this.servlets.get(path);
            if (servlet != null) {
                HttpServletRequest req = new HttpServletRequest(connection, method, path);
                HttpServletResponse resp = new HttpServletResponse(connection);
                this.status = "Servicing servlet";
                servlet.service(req, resp);
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        System.out.println("%%% HttpServer: worker thread started...");
        this.handlePendingConnections();
    }

    private String readLine(InputStream input) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = input.read()) != -1) {
            if (c != 13) {
                sb.append((char)c);
            }
            if (c != 10) continue;
            return sb.toString();
        }
        return null;
    }

    public void printStatus(PrintStream out) {
        out.println("HttpServer status: " + this.status);
    }
}

