/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.PrintStream;
import se.sics.jipv6.core.IPPayload;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.util.Utils;

public class UDPPacket
implements IPPayload {
    public static final boolean DEBUG = false;
    public static final int DISPATCH = 17;
    int sourcePort;
    int destinationPort;
    int length;
    int checkSum;
    byte[] payload;

    public UDPPacket replyPacket() {
        UDPPacket udp = new UDPPacket();
        udp.destinationPort = this.sourcePort;
        udp.sourcePort = this.destinationPort;
        return udp;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public void setDestinationPort(int destinationPort) {
        this.destinationPort = destinationPort;
    }

    @Override
    public byte[] generatePacketData(IPv6Packet packet) {
        int size = this.payload != null ? this.payload.length : 0;
        byte[] data = new byte[size += 8];
        int pos = 0;
        data[pos++] = (byte)(this.sourcePort >> 8);
        data[pos++] = (byte)(this.sourcePort & 0xFF);
        data[pos++] = (byte)(this.destinationPort >> 8);
        data[pos++] = (byte)(this.destinationPort & 0xFF);
        data[pos++] = (byte)(size >> 8);
        data[pos++] = (byte)(size & 0xFF);
        data[pos++] = 0;
        data[pos++] = 0;
        if (this.payload != null) {
            System.arraycopy(this.payload, 0, data, pos, this.payload.length);
        }
        packet.payloadLen = size;
        int sum = packet.upperLayerHeaderChecksum();
        sum = IPv6Packet.checkSum(sum, data, size);
        sum = ~sum & 0xFFFF;
        data[6] = (byte)(sum >> 8);
        data[7] = (byte)(sum & 0xFF);
        return data;
    }

    @Override
    public byte getDispatch() {
        return 17;
    }

    @Override
    public void printPacket(PrintStream out) {
        out.println("UDP Packet srcPort: " + this.sourcePort + " destPort: " + this.destinationPort);
        out.println("UDP length: " + this.length);
    }

    @Override
    public void parsePacketData(IPv6Packet packet) {
        this.sourcePort = packet.get16(0);
        this.destinationPort = packet.get16(2);
        int length = packet.get16(4);
        this.checkSum = packet.get16(6);
        this.payload = new byte[length - 8];
        packet.copy(8, this.payload, 0, length - 8);
        packet.setData(2, (byte)0);
        packet.setData(3, (byte)0);
        byte[] data = packet.getPayload();
        int sum = packet.upperLayerHeaderChecksum();
        sum = IPv6Packet.checkSum(sum, data, data.length);
        sum = ~sum & 0xFFFF;
        if (sum != this.checkSum) {
            System.out.println("UDP: Checksum error: " + Utils.hex16(this.checkSum) + " <?> " + Utils.hex16(sum));
        }
    }

    public int doVirtualChecksum(IPv6Packet packet) {
        byte[] vheader = new byte[8];
        int length = this.payload.length + 8;
        vheader[0] = (byte)(this.sourcePort >> 8);
        vheader[1] = (byte)(this.sourcePort & 0xFF);
        vheader[2] = (byte)(this.destinationPort >> 8);
        vheader[3] = (byte)(this.destinationPort & 0xFF);
        vheader[4] = (byte)(length >> 8);
        vheader[5] = (byte)(length & 0xFF);
        packet.payloadLen = length;
        int sum = packet.upperLayerHeaderChecksum();
        sum = IPv6Packet.checkSum(sum, vheader, 8);
        sum = IPv6Packet.checkSum(sum, this.payload, this.payload.length);
        if ((sum = ~sum & 0xFFFF) != this.checkSum) {
            System.out.println("UDP: Checksum error: " + Utils.hex16(this.checkSum) + " <?> " + Utils.hex16(sum));
        }
        return sum;
    }
}

