/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.IOException;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.UDPListener;
import se.sics.jipv6.core.UDPPacket;

public class UDPHandler {
    private static final int MAX_LISTENERS = 16;
    public UDPListener[] listeners = new UDPListener[16];
    public int[] listenPorts = new int[16];
    int noListeners = 0;

    public void addUDPListener(UDPListener listener, int port) throws IOException {
        if (this.noListeners >= 16) {
            throw new IOException("Too many open connections...");
        }
        System.out.println("UDPHandler: adding listener for " + port);
        this.listeners[this.noListeners] = listener;
        this.listenPorts[this.noListeners++] = port;
    }

    public void handlePacket(IPv6Packet packet, UDPPacket udpPacket) {
        int i = 0;
        while (i < this.noListeners) {
            if (this.listenPorts[i] == udpPacket.destinationPort) {
                this.listeners[i].packetReceived(packet, udpPacket);
                return;
            }
            ++i;
        }
    }
}

