/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.PrintStream;
import se.sics.jipv6.core.IPPayload;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.util.Utils;

public class TCPPacket
implements IPPayload {
    public static final int DEFAULT_WINDOW = 45;
    public static final int DEFAULT_MSS = 45;
    public static final int DISPATCH = 6;
    public static final int OPT_MSS = 2;
    public static final int OPT_MSS_LEN = 4;
    public static final int URG = 32;
    public static final int ACK = 16;
    public static final int PSH = 8;
    public static final int RST = 4;
    public static final int SYN = 2;
    public static final int FIN = 1;
    int sourcePort;
    int destinationPort;
    int seqNo;
    int ackNo;
    int offset = 5;
    int flags;
    int window = 45;
    int checksum;
    int urgentPointer;
    byte[] payload;

    @Override
    public byte[] generatePacketData(IPv6Packet packet) {
        int size = 20;
        if ((this.flags & 2) > 0) {
            size += 4;
        }
        this.offset = size / 4;
        if (this.payload != null) {
            size += this.payload.length;
        }
        byte[] data = new byte[size];
        int pos = 0;
        data[pos++] = (byte)(this.sourcePort >> 8);
        data[pos++] = (byte)(this.sourcePort & 0xFF);
        data[pos++] = (byte)(this.destinationPort >> 8);
        data[pos++] = (byte)(this.destinationPort & 0xFF);
        IPv6Packet.set32(data, pos, this.seqNo);
        IPv6Packet.set32(data, pos += 4, this.ackNo);
        pos += 4;
        data[pos++] = (byte)(this.offset << 4);
        data[pos++] = (byte)this.flags;
        data[pos++] = (byte)(this.window >> 8);
        data[pos++] = (byte)(this.window & 0xFF);
        data[pos++] = 0;
        data[pos++] = 0;
        data[pos++] = (byte)(this.urgentPointer >> 8);
        data[pos++] = (byte)(this.urgentPointer & 0xFF);
        if ((this.flags & 2) > 0) {
            data[pos++] = 2;
            data[pos++] = 4;
            data[pos++] = 0;
            data[pos++] = 45;
        }
        if (this.payload != null) {
            System.arraycopy(this.payload, 0, data, pos, this.payload.length);
        }
        packet.payloadLen = size;
        int sum = packet.upperLayerHeaderChecksum();
        sum = IPv6Packet.checkSum(sum, data, size);
        sum = ~sum & 0xFFFF;
        data[16] = (byte)(sum >> 8);
        data[17] = (byte)(sum & 0xFF);
        return data;
    }

    public boolean isAck() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isPush() {
        return (this.flags & 8) > 0;
    }

    public boolean isSyn() {
        return (this.flags & 2) > 0;
    }

    public boolean isFin() {
        return (this.flags & 1) > 0;
    }

    public boolean isReset() {
        return (this.flags & 4) > 0;
    }

    @Override
    public byte getDispatch() {
        return 6;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public void parsePacketData(IPv6Packet packet) {
        this.sourcePort = packet.get16(0);
        this.destinationPort = packet.get16(2);
        this.seqNo = packet.get32(4);
        this.ackNo = packet.get32(8);
        this.offset = (packet.getData(12) & 0xFF) >> 4;
        this.flags = packet.getData(13);
        this.window = packet.get16(14);
        this.checksum = packet.get16(16);
        this.urgentPointer = packet.get16(18);
        packet.setData(16, (byte)0);
        packet.setData(17, (byte)0);
        byte[] data = packet.getPayload();
        int sum = packet.upperLayerHeaderChecksum();
        sum = IPv6Packet.checkSum(sum, data, data.length);
        sum = ~sum & 0xFFFF;
        if (sum != this.checksum) {
            System.out.println("TCP: Checksum error: " + Utils.hex16(this.checksum) + " <?> " + Utils.hex16(sum));
        }
        if (data.length - this.offset * 4 > 0) {
            int len = data.length - this.offset * 4;
            this.payload = new byte[len];
            System.arraycopy(data, this.offset * 4, this.payload, 0, len);
        }
    }

    @Override
    public void printPacket(PrintStream out) {
        out.print("[TCP " + this.sourcePort + " -> " + this.destinationPort + " Flag: " + Utils.hex8(this.flags) + " seq: " + Long.toString((long)this.seqNo & 0xFFFFL, 16) + " ack:" + Long.toString((long)this.ackNo & 0xFFFFL, 16));
        if (this.payload != null) {
            System.out.print("|");
            int len = 8;
            if (this.payload.length < len) {
                len = this.payload.length;
            }
            int i = 0;
            while (i < len) {
                out.print((char)this.payload[i]);
                ++i;
            }
        }
        System.out.println("]");
    }

    public TCPPacket replyPacket() {
        TCPPacket packet = new TCPPacket();
        packet.sourcePort = this.destinationPort;
        packet.destinationPort = this.sourcePort;
        return packet;
    }
}

