/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.IOException;
import java.io.OutputStream;
import se.sics.jipv6.core.TCPConnection;

public class TCPOutputStream
extends OutputStream {
    byte[] output = new byte[40];
    int pos = 0;
    TCPConnection connection;

    TCPOutputStream(TCPConnection connection) {
        this.connection = connection;
    }

    @Override
    public synchronized void write(int data) throws IOException {
        if (this.connection.state != 4) {
            throw new IOException("TCP connection not open state: " + this.connection.state);
        }
        this.output[this.pos++] = (byte)(data & 0xFF);
        if (this.pos == this.output.length) {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        byte[] buffer = new byte[this.pos];
        int i = 0;
        while (i < this.pos) {
            buffer[i] = this.output[i];
            ++i;
        }
        this.pos = 0;
        this.connection.send(buffer);
    }
}

