/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.IOException;
import java.io.InputStream;
import se.sics.jipv6.core.TCPConnection;
import se.sics.jipv6.core.TCPListener;
import se.sics.jipv6.core.TCPPacket;

public class TCPInputStream
extends InputStream {
    private TCPConnection connection;
    private byte[] inputBuffer = new byte[128];
    private int firstByte = 0;
    private int nextEmpty = 0;
    boolean closed = false;
    long lastReadCall = 0L;
    TCPListener listener = new TCPListener(){

        @Override
        public void connectionClosed(TCPConnection connection) {
            TCPInputStream.this.closed = true;
            System.out.println("InputStream - connection closed...");
            TCPInputStream.this.notifyReader();
        }

        @Override
        public void newConnection(TCPConnection connection) {
        }

        @Override
        public void tcpDataReceived(TCPConnection source, TCPPacket packet) {
            byte[] payload = packet.payload;
            if (payload == null || payload.length == 0) {
                return;
            }
            int pos = 0;
            if (TCPInputStream.this.inputBuffer.length - TCPInputStream.this.available() > payload.length) {
                while (pos < payload.length) {
                    byte[] byArray = TCPInputStream.this.inputBuffer;
                    TCPInputStream tCPInputStream = TCPInputStream.this;
                    int n = tCPInputStream.nextEmpty;
                    tCPInputStream.nextEmpty = n + 1;
                    byArray[n] = payload[pos++];
                    if (TCPInputStream.this.nextEmpty < TCPInputStream.this.inputBuffer.length) continue;
                    TCPInputStream.this.nextEmpty = 0;
                }
                TCPInputStream.this.notifyReader();
            } else {
                System.out.println("ERROR!!!! packet does not fit buffer... should not ack!!!");
            }
        }
    };

    TCPInputStream(TCPConnection connection) {
        this.connection = connection;
    }

    private synchronized void notifyReader() {
        this.notify();
    }

    @Override
    public int available() {
        int ava = this.nextEmpty - this.firstByte;
        if (ava < 0) {
            ava += this.inputBuffer.length;
        }
        return ava;
    }

    @Override
    public void close() {
        this.connection.close();
        this.closed = true;
        this.notifyReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        TCPInputStream tCPInputStream = this;
        synchronized (tCPInputStream) {
            this.lastReadCall = System.currentTimeMillis();
            while (!this.closed && this.firstByte == this.nextEmpty) {
                try {
                    this.wait(1000L);
                    System.out.println("TCPInputStream: waiting for input...");
                    if (this.connection.timeout == -1 || this.lastReadCall + (long)this.connection.timeout >= System.currentTimeMillis()) continue;
                    throw new IOException("I/O operation: Read timed out...");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!this.closed) {
            byte data = this.inputBuffer[this.firstByte++];
            if (this.firstByte >= this.inputBuffer.length) {
                this.firstByte = 0;
            }
            return data & 0xFF;
        }
        return -1;
    }
}

