/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.TCPConnection;
import se.sics.jipv6.core.TCPPacket;

public class TCPHandler
extends TimerTask {
    private static final int MAX_CONNECTIONS = 16;
    private static final int MAX_LISTEN = 16;
    TCPConnection[] activeConnections = new TCPConnection[16];
    TCPConnection[] listenConnections = new TCPConnection[16];
    int connectionNo = 0;
    int listenNo = 0;
    IPStack ipStack;
    Timer timer;

    public TCPHandler(IPStack stack) {
        this.ipStack = stack;
        this.timer = this.ipStack.getTimer();
        this.timer.schedule((TimerTask)this, 100L, 100L);
    }

    public synchronized TCPConnection addListenConnection(int port) {
        TCPConnection tCPConnection = new TCPConnection(this.ipStack, null);
        this.listenConnections[this.listenNo++] = tCPConnection;
        TCPConnection conn = tCPConnection;
        conn.localPort = port;
        conn.state = 1;
        return conn;
    }

    private synchronized void addConnection(TCPConnection c) {
        c.pos = (byte)this.connectionNo;
        this.activeConnections[this.connectionNo++] = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacket(IPv6Packet packet) {
        TCPPacket tcpPacket = (TCPPacket)packet.getIPPayload();
        TCPConnection connection = this.findConnection(packet, tcpPacket);
        if (connection == null) {
            connection = this.findListenConnection(packet, tcpPacket);
            if (connection == null) {
                System.out.println("TCPHandler: can not find active or listen connection for this packet");
            } else if (tcpPacket.isSyn()) {
                TCPPacket tcpReply = TCPHandler.createAck(tcpPacket, 2);
                TCPConnection tc = new TCPConnection(this.ipStack, packet.netInterface);
                tc.externalIP = packet.sourceAddress;
                tc.externalPort = tcpPacket.sourcePort;
                tc.localIP = this.ipStack.myIPAddress;
                tc.localPort = tcpPacket.destinationPort;
                tc.state = 3;
                tc.receiveNext = tcpPacket.seqNo + 1;
                tc.sendNext = tcpReply.seqNo = (int)(System.currentTimeMillis() * 7L);
                tc.sentUnack = tcpReply.seqNo;
                this.addConnection(tc);
                connection.newConnection(tc);
                tcpReply.ackNo = tc.receiveNext;
                try {
                    tc.send(tcpReply);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                tc.sentUnack = ++tc.sendNext;
                tc.serverConnection = connection;
            } else {
                System.out.println("TCPHandler: dropping packet & sending RST - likely for old connection?");
                TCPPacket tcpReply = tcpPacket.replyPacket();
                tcpReply.flags = 20;
                tcpReply.seqNo = tcpPacket.ackNo;
                tcpReply.ackNo = tcpPacket.seqNo + 1;
                IPv6Packet ipReply = packet.replyPacket(tcpReply);
                this.ipStack.sendPacket(ipReply, packet.netInterface);
            }
        } else {
            if (tcpPacket.isReset()) {
                connection.state = 0;
            }
            switch (connection.state) {
                case 3: {
                    if (!tcpPacket.isAck()) break;
                    System.out.println("TCPConnection: gotten ACK on syn! => ESTABLISHED!! " + connection.pos);
                    connection.state = 4;
                    connection.receive(tcpPacket);
                    TCPConnection tCPConnection = connection;
                    synchronized (tCPConnection) {
                        connection.notify();
                        break;
                    }
                }
                case 4: {
                    if (tcpPacket.isFin()) {
                        System.out.println("TCPConnection: received FIN => CLOSE_WAIT!!!");
                        connection.state = 5;
                    }
                    connection.receive(tcpPacket);
                    break;
                }
                case 6: {
                    if (!tcpPacket.isAck()) break;
                    System.out.println("Received ACK on FIN => CLOSED! " + connection.pos);
                    connection.state = 0;
                    break;
                }
                case 7: {
                    if (tcpPacket.isAck()) {
                        connection.state = 8;
                    }
                    if (tcpPacket.isFin()) {
                        connection.state = 10;
                    }
                    connection.receive(tcpPacket);
                    break;
                }
                case 8: {
                    if (tcpPacket.isFin()) {
                        System.out.println("TCPHandler: setting connection in TIME_WAIT... " + connection.pos);
                        connection.state = 10;
                        connection.lastSendTime = System.currentTimeMillis();
                        ++connection.receiveNext;
                        connection.sendAck(tcpPacket);
                        break;
                    }
                    connection.sendReset();
                    break;
                }
                case 5: {
                    connection.sendReset();
                }
            }
        }
    }

    static TCPPacket createAck(TCPPacket tcpPacket, int flags) {
        TCPPacket tcpReply = tcpPacket.replyPacket();
        tcpReply.flags |= flags | 0x10;
        return tcpReply;
    }

    private TCPConnection findConnection(IPv6Packet packet, TCPPacket tcpPacket) {
        int i = 0;
        while (i < this.connectionNo) {
            if (this.activeConnections[i].matches(packet, tcpPacket)) {
                return this.activeConnections[i];
            }
            ++i;
        }
        return null;
    }

    private TCPConnection findListenConnection(IPv6Packet packet, TCPPacket tcpPacket) {
        int i = 0;
        while (i < this.listenNo) {
            if (this.listenConnections[i].matches(packet, tcpPacket)) {
                return this.listenConnections[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public synchronized void run() {
        if (this.connectionNo > 0) {
            long time = System.currentTimeMillis();
            int i = 0;
            while (i < this.connectionNo) {
                TCPConnection connection = this.activeConnections[i];
                switch (connection.state) {
                    case 4: {
                        if (connection.outSize() > 0 && connection.lastSendTime + (long)connection.retransmissionTime < time) {
                            System.out.println("### Timeout - retransmitting...");
                            connection.resend();
                        }
                        if (connection.timeout == -1 || connection.lastSendTime + (long)connection.timeout >= time) break;
                        connection.close();
                        break;
                    }
                    case 5: {
                        if (connection.outSize() == 0) {
                            System.out.println("Closing - sending FIN");
                            connection.state = 6;
                            connection.sendFIN();
                            break;
                        }
                        connection.resend();
                        break;
                    }
                    case 7: 
                    case 8: {
                        if (connection.lastSendTime + (long)connection.retransmissionTime >= time) break;
                        connection.resend();
                        break;
                    }
                    case 10: {
                        if (connection.lastSendTime + 1000L >= time) break;
                        System.out.println("TCPHandler: TIME_WAIT over => CLOSED!");
                        connection.state = 0;
                        break;
                    }
                    case 0: {
                        System.out.println("TCPHandler: Connection is closed... removing connection " + connection.pos);
                        connection.closed();
                        --this.connectionNo;
                        if (this.connectionNo <= 0) break;
                        this.activeConnections[i] = this.activeConnections[this.connectionNo];
                        this.activeConnections[i].pos = (byte)i;
                        --i;
                    }
                }
                ++i;
            }
        }
    }

    public void printStatus(PrintStream out) {
        out.println("---- TCP Connection info ----");
        int i = 0;
        while (i < this.connectionNo) {
            out.println("* Connection " + i + " in state: " + this.activeConnections[i].state);
            ++i;
        }
    }
}

