/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.NetworkInterface;
import se.sics.jipv6.core.TCPHandler;
import se.sics.jipv6.core.TCPInputStream;
import se.sics.jipv6.core.TCPListener;
import se.sics.jipv6.core.TCPOutputStream;
import se.sics.jipv6.core.TCPPacket;
import se.sics.jipv6.util.Utils;

public class TCPConnection {
    public static final int CLOSED = 0;
    public static final int LISTEN = 1;
    public static final int SYN_SENT = 2;
    public static final int SYN_RECEIVED = 3;
    public static final int ESTABLISHED = 4;
    public static final int CLOSE_WAIT = 5;
    public static final int LAST_ACK = 6;
    public static final int FIN_WAIT_1 = 7;
    public static final int FIN_WAIT_2 = 8;
    public static final int CLOSING = 9;
    public static final int TIME_WAIT = 10;
    public static final long TIME_WAIT_MILLIS = 1000L;
    private static final int OUT_BUFFER = 128;
    int retransmissionTime = 1000;
    int localPort;
    byte[] localIP;
    int externalPort = -1;
    byte[] externalIP;
    byte pos;
    int state;
    int sentUnack;
    int sendNext;
    int sendWindow = 45;
    int receiveNext;
    int receiveWindow = 45;
    private IPStack ipStack;
    private NetworkInterface netInterface;
    private TCPListener tcpListener;
    TCPConnection serverConnection;
    long lastSendTime;
    private byte[] outgoingBuffer = new byte[128];
    int bufPos = 0;
    int bufNextEmpty = 0;
    private TCPInputStream inputStream;
    private TCPOutputStream outputStream;
    private boolean closing;
    int timeout = -1;

    TCPConnection(IPStack stack, NetworkInterface nIf) {
        this.ipStack = stack;
        this.netInterface = nIf;
    }

    public InputStream getInputStream() {
        if (this.inputStream == null) {
            System.out.println("TCPConnection: creating new input stream...");
            this.inputStream = new TCPInputStream(this);
            this.tcpListener = this.inputStream.listener;
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new TCPOutputStream(this);
        }
        return this.outputStream;
    }

    public void setTCPListener(TCPListener listener) {
        if (this.tcpListener != null) {
            throw new IllegalStateException("TCPListener already set: " + this.tcpListener);
        }
        this.tcpListener = listener;
    }

    public void newConnection(TCPConnection c) {
        if (this.tcpListener != null) {
            this.tcpListener.newConnection(c);
        }
    }

    public boolean matches(IPv6Packet packet, TCPPacket tcpPacket) {
        return !(this.externalPort != -1 && tcpPacket.sourcePort != this.externalPort || tcpPacket.destinationPort != this.localPort || this.localIP != null && !Utils.equals(this.localIP, packet.destAddress) || this.externalIP != null && !Utils.equals(this.externalIP, packet.sourceAddress));
    }

    public void send(TCPPacket tcpPacket) throws IOException {
        IPv6Packet packet = new IPv6Packet(tcpPacket, this.localIP, this.externalIP);
        tcpPacket.seqNo = this.sendNext;
        tcpPacket.ackNo = this.receiveNext;
        if (tcpPacket.payload != null) {
            this.copyToBuffer(tcpPacket.payload);
            this.sendNext += tcpPacket.payload.length;
            System.out.println("SEND: Updated sendNext: " + this.sendNext + " outSize: " + this.outSize() + " seqDiff: " + (this.sendNext - this.sentUnack));
        }
        if (tcpPacket.isFin()) {
            ++this.sendNext;
        }
        this.lastSendTime = System.currentTimeMillis();
        tcpPacket.printPacket(System.out);
        this.ipStack.sendPacket(packet, this.netInterface);
    }

    int outSize() {
        int bytesToSend = this.bufNextEmpty - this.bufPos;
        if (bytesToSend < 0) {
            bytesToSend += this.outgoingBuffer.length;
        }
        return bytesToSend;
    }

    private synchronized void copyToBuffer(byte[] data) throws IOException {
        int empty = this.outgoingBuffer.length - this.outSize();
        while (empty < data.length || this.state == 3 || this.state == 2) {
            if (this.state == 0) {
                throw new IOException("Connection closed");
            }
            try {
                System.out.println("blocking output... state: " + this.state);
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            empty = this.outgoingBuffer.length - this.outSize();
        }
        int i = 0;
        while (i < data.length) {
            this.outgoingBuffer[this.bufNextEmpty++] = data[i];
            if (this.bufNextEmpty >= this.outgoingBuffer.length) {
                this.bufNextEmpty = 0;
            }
            ++i;
        }
    }

    synchronized void resend() {
        TCPPacket tcpPacket;
        if (this.state == 7 || this.state == 8) {
            System.out.println("Resending FIN!!!!");
            tcpPacket = this.createPacket();
            tcpPacket.flags |= 1;
        } else {
            int size = this.outSize();
            System.out.println("### Bytes to resend: " + this.outSize() + " seqDiff: " + (this.sendNext - this.sentUnack));
            if (size == 0) {
                return;
            }
            if (this.outSize() < size) {
                size = this.outSize();
            }
            if (size > 40) {
                size = 40;
            }
            byte[] data = new byte[size];
            int pos = this.bufPos;
            int i = 0;
            while (i < data.length) {
                data[i] = this.outgoingBuffer[pos++];
                if (pos >= this.outgoingBuffer.length) {
                    pos = 0;
                }
                ++i;
            }
            tcpPacket = this.createPacket();
            tcpPacket.payload = data;
            System.out.println("**** TCPConnection resending data: size = " + size);
        }
        IPv6Packet packet = new IPv6Packet(tcpPacket, this.localIP, this.externalIP);
        tcpPacket.seqNo = this.sentUnack;
        this.lastSendTime = System.currentTimeMillis();
        tcpPacket.printPacket(System.out);
        this.ipStack.sendPacket(packet, this.netInterface);
    }

    synchronized void receive(TCPPacket tcpPacket) {
        int plen;
        int n = plen = tcpPacket.payload == null ? 0 : tcpPacket.payload.length;
        if (tcpPacket.isAck()) {
            if (this.sentUnack <= tcpPacket.ackNo && this.sendNext >= tcpPacket.ackNo) {
                int noAcked = tcpPacket.ackNo - this.sentUnack;
                this.sentUnack = tcpPacket.ackNo;
                this.bufPos += noAcked;
                if (this.bufPos >= this.outgoingBuffer.length) {
                    this.bufPos -= this.outgoingBuffer.length;
                }
                System.out.println("ACK for " + noAcked + " bytes. pos: " + this.bufPos + " nxtE:" + this.bufNextEmpty + " unack: " + Integer.toString(this.sentUnack & 0xFFFF, 16) + " sendNext: " + Integer.toString(this.sendNext & 0xFFFF, 16) + " outSize: " + this.outSize() + " seqDiff: " + (this.sendNext - this.sentUnack) + " plen: " + plen);
                this.notify();
                if (this.state == 4 && this.closing && this.outSize() == 0) {
                    System.out.println("==== Closing connection...");
                    this.state = 7;
                    this.sendFIN();
                }
            } else {
                System.out.println("TCPHandler: Unexpected ACK no: " + Integer.toString(tcpPacket.ackNo & 0xFFFF, 16) + " sendNext: " + Integer.toString(this.sendNext & 0xFFFF, 16) + " sentUnack: " + Integer.toString(this.sentUnack & 0xFFFF, 16));
                if (tcpPacket.ackNo == this.sentUnack) {
                    this.resend();
                }
            }
        }
        if (tcpPacket.isFin()) {
            System.out.println("***** FIN RECEIVED!!!!!");
        }
        if (this.receiveNext == tcpPacket.seqNo) {
            this.receiveNext = tcpPacket.seqNo + plen;
            if (tcpPacket.isFin()) {
                ++this.receiveNext;
                if (plen == 0) {
                    this.sendAck(tcpPacket);
                }
            }
            if (plen > 0) {
                this.sendAck(tcpPacket);
                if (this.tcpListener != null) {
                    this.tcpListener.tcpDataReceived(this, tcpPacket);
                } else {
                    System.out.println("*** ERROR: dropped data: did not have listener...");
                }
            }
        } else {
            System.out.println("TCPHandler: seq error: expSeq: " + Integer.toString(this.receiveNext & 0xFFFF, 16) + " != seqNo: " + Integer.toString(tcpPacket.seqNo & 0xFFFF, 16));
            this.sendAck(tcpPacket);
        }
    }

    void sendAck(TCPPacket tcpPacket) {
        TCPPacket tcpReply = TCPHandler.createAck(tcpPacket, 0);
        try {
            this.send(tcpReply);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send(byte[] bytes) throws IOException {
        if (this.closing) {
            throw new IOException("TCPConnection closing...");
        }
        TCPPacket tcpPacket = this.createPacket();
        tcpPacket.payload = bytes;
        this.send(tcpPacket);
    }

    public void close() {
        if (this.state == 4) {
            System.out.println("=== Closing connection... outSize: " + this.outSize());
            this.closing = true;
            if (this.outSize() == 0) {
                this.state = 7;
                this.sendFIN();
            }
        }
    }

    void closed() {
        if (this.tcpListener != null) {
            this.tcpListener.connectionClosed(this);
        }
    }

    void sendFIN() {
        System.out.println("Sending FIN!!!!");
        TCPPacket packet = this.createPacket();
        packet.flags |= 1;
        try {
            this.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TCPPacket createPacket() {
        TCPPacket tcpPacket = new TCPPacket();
        tcpPacket.sourcePort = this.localPort;
        tcpPacket.destinationPort = this.externalPort;
        return tcpPacket;
    }

    public void setTimeout(int tms) {
        this.timeout = tms;
    }

    void sendReset() {
        System.out.println("Sending RESET!!!!");
        TCPPacket packet = this.createPacket();
        packet.flags |= 4;
        try {
            this.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

