/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.util.Hashtable;

public class Packet {
    public static final String LL_SOURCE = "link.source";
    public static final String LL_DESTINATION = "link.destination";
    protected Hashtable attributes = new Hashtable();
    protected byte[] packetData;
    int currentPos = 0;

    public void setBytes(byte[] data) {
        this.packetData = data;
        this.currentPos = 0;
    }

    public void setBytes(byte[] data, int startPos, int len) {
        byte[] payload = new byte[len];
        System.arraycopy(data, startPos, payload, 0, len);
        this.packetData = payload;
        this.currentPos = 0;
    }

    public void appendBytes(byte[] data) {
        if (this.packetData == null) {
            this.packetData = data;
        } else {
            this.setPacketData(this.packetData, data);
        }
    }

    public void prependBytes(byte[] data) {
        if (this.packetData == null) {
            this.packetData = data;
        } else {
            this.setPacketData(data, this.packetData);
        }
    }

    private void setPacketData(byte[] data1, byte[] data2) {
        byte[] newData = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, newData, 0, data1.length);
        System.arraycopy(data2, 0, newData, data1.length, data2.length);
        this.packetData = newData;
    }

    public byte[] getBytes() {
        return this.packetData;
    }

    public int getTotalLength() {
        return this.packetData.length;
    }

    public int getPayloadLength() {
        return this.packetData.length - this.currentPos;
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void setAttribute(String name, int data) {
        this.attributes.put(name, new Integer(data));
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public byte[] getLinkSource() {
        return (byte[])this.attributes.get(LL_SOURCE);
    }

    public byte[] getLinkDestination() {
        return (byte[])this.attributes.get(LL_DESTINATION);
    }

    public int get32(int pos) {
        if (this.packetData.length >= (pos = this.currentPos + pos) + 3) {
            return (this.packetData[pos] & 0xFF) << 24 | (this.packetData[pos + 1] & 0xFF) << 16 | (this.packetData[pos + 2] & 0xFF) << 8 | this.packetData[pos + 3] & 0xFF;
        }
        return 0;
    }

    static int get32(byte[] data, int pos) {
        if (data.length >= pos + 3) {
            return (data[pos] & 0xFF) << 24 | (data[pos + 1] & 0xFF) << 16 | (data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF;
        }
        return 0;
    }

    static int get16(byte[] data, int pos) {
        if (data.length >= pos + 1) {
            return (data[pos] & 0xFF) << 8 | (data[pos + 1] & 0xFF) << 0;
        }
        return 0;
    }

    public int get16(int pos) {
        if (this.packetData.length > (pos = this.currentPos + pos) + 1) {
            return (this.packetData[pos] & 0xFF) << 8 | this.packetData[pos + 1] & 0xFF;
        }
        return 0;
    }

    public byte getData(int pos) {
        return this.packetData[this.currentPos + pos];
    }

    public void incPos(int delta) {
        this.currentPos += delta;
    }

    public byte[] getPayload() {
        byte[] payload = new byte[this.packetData.length - this.currentPos];
        System.arraycopy(this.packetData, this.currentPos, payload, 0, payload.length);
        return payload;
    }

    public int getAttributeAsInt(String attr) {
        Object val = this.attributes.get(attr);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof String) {
            return Integer.parseInt((String)val);
        }
        return -1;
    }

    public void copy(int pos, byte[] dst, int dstPos, int len) {
        int tPos = pos + this.currentPos;
        System.arraycopy(this.packetData, tPos, dst, dstPos, len);
    }

    public void setData(int pos, byte val) {
        this.packetData[this.currentPos + pos] = val;
    }
}

