/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.Neighbor;
import se.sics.jipv6.util.Utils;

public class NeighborTable {
    Neighbor[] neighbors = new Neighbor[64];
    int neighborCount = 0;
    Neighbor defrouter;

    public synchronized Neighbor addNeighbor(byte[] ipAddress, byte[] linkAddress) {
        Neighbor nb = this.getNeighbor(ipAddress);
        if (nb == null) {
            if (this.checkIPAddress(ipAddress)) {
                nb = new Neighbor();
                nb.ipAddress = ipAddress;
                nb.linkAddress = linkAddress;
                int n = nb.state = this.checkLinkAddress(linkAddress) ? 2 : 0;
                if (this.neighborCount < this.neighbors.length) {
                    this.neighbors[this.neighborCount++] = nb;
                } else {
                    this.neighbors[0] = nb;
                }
            }
        } else {
            nb.linkAddress = linkAddress;
            nb.state = 0;
        }
        return nb;
    }

    private boolean checkLinkAddress(byte[] link) {
        return link != null;
    }

    private boolean checkIPAddress(byte[] ipAddress) {
        return !Utils.equals(ipAddress, IPStack.UNSPECIFIED);
    }

    public Neighbor getDefrouter() {
        return this.defrouter;
    }

    public void setDefrouter(Neighbor neighbor) {
        this.defrouter = neighbor;
    }

    public synchronized boolean removeNeighbor(Neighbor nb) {
        int i = 0;
        while (i < this.neighborCount) {
            if (nb == this.neighbors[i]) {
                this.neighbors[i] = this.neighbors[this.neighborCount - 1];
                --this.neighborCount;
                return true;
            }
            ++i;
        }
        return false;
    }

    public Neighbor getNeighbor(byte[] ipAddress) {
        int neighborCount0 = this.neighborCount;
        Neighbor[] neis = this.neighbors;
        int i = 0;
        while (i < neighborCount0) {
            if (Utils.equals(ipAddress, neis[i].ipAddress)) {
                return neis[i];
            }
            ++i;
        }
        return null;
    }
}

