/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.util.TimerTask;
import se.sics.jipv6.core.ICMP6Packet;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.Neighbor;
import se.sics.jipv6.core.NeighborTable;

public class NeighborManager
extends TimerTask {
    private NeighborTable neigborTable;
    private IPStack ipStack;
    private long nextRS = 0L;
    private long nextRA = 0L;
    private boolean duplicateDetectionNS;

    public NeighborManager(IPStack stack, NeighborTable table) {
        this.neigborTable = table;
        this.ipStack = stack;
        stack.getTimer().schedule((TimerTask)this, 1000L, 1000L);
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        if (!this.duplicateDetectionNS) {
            System.out.println("NeighborManager: sending neighbor solicitation (DAD)");
            this.duplicateDetectionNS = true;
            ICMP6Packet icmp = new ICMP6Packet(135);
            icmp.targetAddress = this.ipStack.myLinkAddress;
            IPv6Packet ipp = new IPv6Packet(icmp, this.ipStack.myLocalIPAddress, this.ipStack.myLocalSolicited);
            this.ipStack.sendPacket(ipp, null);
        } else if (!this.ipStack.isRouter() && this.neigborTable.getDefrouter() == null && this.nextRS < time) {
            System.out.println("NeighborManager: sending router solicitation");
            this.nextRS = time + 10000L;
            ICMP6Packet icmp = new ICMP6Packet(133);
            icmp.addLinkOption(1, this.ipStack.getLinkLayerAddress());
            IPv6Packet ipp = new IPv6Packet(icmp, this.ipStack.myLocalIPAddress, IPStack.ALL_ROUTERS);
            this.ipStack.sendPacket(ipp, null);
        } else if (this.ipStack.isRouter() && this.nextRA < time) {
            this.nextRA = time + 10000L;
        }
    }

    public void receiveNDMessage(IPv6Packet packet) {
        ICMP6Packet payload = (ICMP6Packet)packet.getIPPayload();
        Neighbor nei = null;
        switch (payload.type) {
            case 133: {
                nei = this.neigborTable.addNeighbor(packet.sourceAddress, packet.getLinkSource());
                if (nei != null) {
                    nei.setState(1);
                }
                if (!this.ipStack.isRouter()) break;
                this.sendRA(packet);
                break;
            }
            case 134: {
                nei = this.neigborTable.addNeighbor(packet.sourceAddress, packet.getLinkSource());
                this.neigborTable.setDefrouter(nei);
                nei.setState(1);
            }
        }
    }

    private void sendRA(IPv6Packet packet) {
        ICMP6Packet payload = (ICMP6Packet)packet.getIPPayload();
        ICMP6Packet p = new ICMP6Packet();
        p.targetAddress = payload.targetAddress;
        p.type = 134;
        p.flags = (packet != null ? 64 : 0) | 0x20;
        p.updateRA(this.ipStack);
        IPv6Packet ipp = new IPv6Packet();
        ipp.setIPPayload(p);
        ipp.destAddress = packet != null ? packet.sourceAddress : IPStack.ALL_NODES;
        ipp.sourceAddress = this.ipStack.myLocalIPAddress;
        System.out.print("Created ICMP6 RA for ");
        IPv6Packet.printAddress(System.out, ipp.destAddress);
        packet.printPacket(System.out);
        this.ipStack.sendPacket(ipp, packet != null ? packet.netInterface : null);
    }
}

