/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.PrintStream;
import se.sics.jipv6.core.IPPacketer;
import se.sics.jipv6.core.IPPayload;
import se.sics.jipv6.core.NetworkInterface;
import se.sics.jipv6.core.Packet;
import se.sics.jipv6.util.Utils;

public class IPv6Packet
extends Packet
implements IPPacketer {
    public static final int ICMP6_DISPATCH = 58;
    public static final boolean DEBUG = true;
    int version = 6;
    int trafficClass;
    int flowLabel = 0;
    byte nextHeader;
    int hopLimit = 255;
    byte[] sourceAddress = new byte[16];
    byte[] destAddress = new byte[16];
    int ipLen = 0;
    int payloadLen = 0;
    IPPayload ipPayload;
    public NetworkInterface netInterface;

    public IPv6Packet() {
    }

    public IPv6Packet(Packet packet) {
        this();
        this.currentPos = packet.currentPos;
        this.attributes = packet.attributes;
        this.packetData = packet.packetData;
        this.ipLen = this.packetData.length - this.currentPos;
    }

    public IPv6Packet(IPPayload pl) {
        this();
        this.nextHeader = pl.getDispatch();
        this.ipPayload = pl;
    }

    public IPv6Packet(IPPayload pl, byte[] source, byte[] dest) {
        this(pl);
        this.sourceAddress = source;
        this.destAddress = dest;
    }

    public IPv6Packet replyPacket(IPPayload payload) {
        IPv6Packet ipPacket = new IPv6Packet();
        ipPacket.destAddress = this.sourceAddress;
        ipPacket.ipPayload = payload;
        ipPacket.nextHeader = payload.getDispatch();
        return ipPacket;
    }

    public byte[] getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(byte[] addr) {
        this.sourceAddress = addr;
    }

    public byte[] getDestinationAddress() {
        return this.destAddress;
    }

    public void setDestinationAddress(byte[] addr) {
        this.destAddress = addr;
    }

    public void printPacket(PrintStream out) {
        out.print("IPv6: from ");
        IPv6Packet.printAddress(out, this.sourceAddress);
        out.print(" to ");
        IPv6Packet.printAddress(out, this.destAddress);
        out.println(" NxHdr: " + this.nextHeader);
    }

    public static void printAddress(PrintStream out, byte[] address) {
        int i = 0;
        while (i < 16) {
            out.print(Utils.hex16((address[i] & 0xFF) << 8 | address[i + 1] & 0xFF));
            if (i < 14) {
                out.print(":");
            }
            i += 2;
        }
        out.println();
    }

    @Override
    public void parsePacketData(IPv6Packet packet) {
        this.version = (packet.getData(0) & 0xFF) >> 4;
        System.out.println("IPv6Packet: version: " + this.version);
        if (this.version != 6) {
            return;
        }
        this.trafficClass = ((packet.getData(0) & 0xF) << 4) + ((packet.getData(1) & 0xFF) >> 4);
        this.flowLabel = (packet.getData(1) & 0xF) << 16 + (packet.getData(2) & 0xFF) << 8 + packet.getData(3) & 0xFF;
        this.payloadLen = ((packet.getData(4) & 0xFF) << 8) + packet.getData(5);
        this.nextHeader = packet.getData(6);
        this.hopLimit = packet.getData(7) & 0xFF;
        packet.copy(8, this.sourceAddress, 0, 16);
        packet.copy(24, this.destAddress, 0, 16);
        packet.incPos(40);
    }

    public static void set32(byte[] data, int pos, long value) {
        data[pos++] = (byte)(value >> 24 & 0xFFL);
        data[pos++] = (byte)(value >> 16 & 0xFFL);
        data[pos++] = (byte)(value >> 8 & 0xFFL);
        data[pos++] = (byte)(value & 0xFFL);
    }

    public static long getLong(byte[] data, int pos) {
        long lval = (long)data[pos] + (((long)data[pos + 1] & 0xFFL) << 8) + (((long)data[pos + 2] & 0xFFL) << 16) + (((long)data[pos + 3] & 0xFFL) << 24) + (((long)data[pos + 4] & 0xFFL) << 32) + (((long)data[pos + 5] & 0xFFL) << 40) + (((long)data[pos + 6] & 0xFFL) << 48) + (((long)data[pos + 7] & 0xFFL) << 56);
        return lval;
    }

    public int upperLayerHeaderChecksum() {
        if (this.payloadLen == 0) {
            throw new IllegalStateException("No payload length when calculating upper layer checksum.");
        }
        int sum = this.payloadLen + this.nextHeader;
        sum = IPv6Packet.checkSum(sum, this.sourceAddress, 16);
        sum = IPv6Packet.checkSum(sum, this.destAddress, 16);
        return sum;
    }

    public static int checkSum(int sum, byte[] data, int size) {
        int dsum;
        int i = 0;
        while (i < size - 1) {
            int dsum2 = (data[i] & 0xFF) << 8 | data[i + 1] & 0xFF;
            if ((sum = sum + dsum2 & 0xFFFF) < dsum2) {
                ++sum;
            }
            i += 2;
        }
        if ((size & 1) > 0 && (sum = sum + (dsum = (data[size - 1] & 0xFF) << 8) & 0xFFFF) < dsum) {
            ++sum;
        }
        return sum;
    }

    public static boolean isMACBased(byte[] address, byte[] macAddress) {
        if (address[8] == (macAddress[0] ^ 2)) {
            int i = 1;
            while (i < macAddress.length) {
                if (address[8 + i] != macAddress[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isSourceMACBased() {
        byte[] macAddress = this.getLinkSource();
        return IPv6Packet.isMACBased(this.sourceAddress, macAddress);
    }

    public boolean isMulticastDestination() {
        return this.destAddress[0] == -1;
    }

    public boolean isDestinationMACBased() {
        byte[] macAddress = this.getLinkDestination();
        return IPv6Packet.isMACBased(this.destAddress, macAddress);
    }

    @Override
    public byte getDispatch() {
        return this.nextHeader;
    }

    @Override
    public byte[] generatePacketData(IPv6Packet packet) {
        byte[] payload = this.ipPayload.generatePacketData(packet);
        int size = 40 + payload.length;
        byte[] dataPacket = new byte[size];
        dataPacket[0] = (byte)(0x60 | this.trafficClass >> 4 & 0xF);
        dataPacket[1] = (byte)((this.trafficClass & 0xF) << 4 | this.flowLabel >> 16 & 0xF);
        dataPacket[2] = (byte)(this.trafficClass >> 8 & 0xFF);
        dataPacket[3] = (byte)(this.trafficClass & 0xFF);
        dataPacket[4] = (byte)(payload.length >> 8 & 0xFF);
        dataPacket[5] = (byte)(payload.length & 0xFF);
        dataPacket[6] = (byte)(this.nextHeader & 0xFF);
        dataPacket[7] = (byte)(this.hopLimit & 0xFF);
        int pos = 8;
        System.arraycopy(packet.getSourceAddress(), 0, dataPacket, pos, 16);
        System.arraycopy(packet.getDestinationAddress(), 0, dataPacket, pos += 16, 16);
        pos += 16;
        System.arraycopy(payload, 0, dataPacket, 40, payload.length);
        return dataPacket;
    }

    public IPPayload getIPPayload() {
        return this.ipPayload;
    }

    public void setIPPayload(IPPayload ipp) {
        this.ipPayload = ipp;
        this.nextHeader = ipp.getDispatch();
    }

    public static void printMACAddress(PrintStream out, byte[] data, int pos, int size) {
        int i = 0;
        while (i < size) {
            out.print(Utils.hex8(data[i + pos]));
            if (i < size - 1) {
                out.print(":");
            }
            ++i;
        }
    }

    public static byte[] parseAddress(String addressStr) {
        byte[] address = new byte[16];
        int hexVal = 0;
        int pos = 0;
        int splitPos = 0;
        addressStr = addressStr.toLowerCase();
        int i = 0;
        while (i < addressStr.length() && pos < 16) {
            char c = addressStr.charAt(i);
            if (c == ':') {
                address[pos++] = (byte)(hexVal >> 8);
                address[pos++] = (byte)(hexVal & 0xFF);
                if (i + 1 < addressStr.length() && addressStr.charAt(i + 1) == ':') {
                    splitPos = pos;
                }
                hexVal = 0;
            } else if (c >= '0' && c <= '9') {
                hexVal = (hexVal << 4) + c - 48;
            } else if (c >= 'a' && c <= 'f') {
                hexVal = (hexVal << 4) + c - 97 + 10;
            }
            ++i;
        }
        return address;
    }

    public static void main(String[] args) {
        byte[] data = Utils.hexconv("6000000000200001fe80000000000000023048fffe904cd2ff02000000000000000000026c5b5f303a000100050200008300527800000000ff02000000000000000000026c5b5f30");
        IPv6Packet packet = new IPv6Packet();
        packet.setBytes(data);
        packet.parsePacketData(packet);
        packet.printPacket(System.out);
    }
}

