/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Timer;
import se.sics.jipv6.core.BytePayload;
import se.sics.jipv6.core.HC01Packeter;
import se.sics.jipv6.core.ICMP6PacketHandler;
import se.sics.jipv6.core.IPPacketer;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.Neighbor;
import se.sics.jipv6.core.NeighborManager;
import se.sics.jipv6.core.NeighborTable;
import se.sics.jipv6.core.NetworkEventListener;
import se.sics.jipv6.core.NetworkInterface;
import se.sics.jipv6.core.PacketHandler;
import se.sics.jipv6.core.TCPConnection;
import se.sics.jipv6.core.TCPHandler;
import se.sics.jipv6.core.TCPPacket;
import se.sics.jipv6.core.UDPHandler;
import se.sics.jipv6.core.UDPListener;
import se.sics.jipv6.core.UDPPacket;
import se.sics.jipv6.util.Utils;

public class IPStack {
    private static final boolean DEBUG = false;
    public static final byte[] ALL_NODES;
    public static final byte[] ALL_ROUTERS;
    public static final byte[] UNSPECIFIED;
    byte[] prefix = null;
    int prefixSize = 0;
    byte[] myIPAddress;
    byte[] myLocalIPAddress;
    byte[] myLocalSolicited;
    byte[] myLinkAddress;
    byte[] linkBroadcast;
    private PacketHandler linkLayerHandler;
    private IPPacketer defaultPacketer;
    private ICMP6PacketHandler icmp6Handler;
    private TCPHandler tcpHandler;
    private UDPHandler udpHandler;
    private boolean isRouter;
    private NetworkInterface tunnel;
    private NeighborTable neighborTable;
    private NeighborManager neighborManager;
    private NetworkEventListener networkEventListener;
    private Timer timer;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = -1;
        byArray[1] = 2;
        byArray[15] = 1;
        ALL_NODES = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = -1;
        byArray2[1] = 2;
        byArray2[15] = 2;
        ALL_ROUTERS = byArray2;
        UNSPECIFIED = new byte[16];
    }

    public IPStack() {
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 5;
        byArray[5] = 6;
        byArray[6] = 7;
        byArray[7] = 8;
        byArray[8] = 9;
        byArray[9] = 10;
        byArray[10] = 11;
        byArray[11] = 12;
        byArray[12] = 13;
        byArray[13] = 14;
        byArray[14] = 15;
        this.myIPAddress = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = -2;
        byArray2[1] = -128;
        byArray2[8] = 9;
        byArray2[9] = 10;
        byArray2[10] = 11;
        byArray2[11] = 12;
        byArray2[12] = 13;
        byArray2[13] = 14;
        byArray2[14] = 15;
        this.myLocalIPAddress = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = -1;
        byArray3[1] = 2;
        byArray3[11] = 1;
        byArray3[12] = -1;
        this.myLocalSolicited = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[1] = 18;
        byArray4[2] = 117;
        byArray4[3] = 4;
        byArray4[4] = 5;
        byArray4[5] = 6;
        byArray4[6] = 7;
        byArray4[7] = 8;
        this.myLinkAddress = byArray4;
        this.linkBroadcast = new byte[]{-1, -1};
        this.defaultPacketer = new HC01Packeter();
        this.tcpHandler = null;
        this.udpHandler = null;
        this.isRouter = false;
        this.neighborTable = new NeighborTable();
        this.timer = new Timer();
        this.icmp6Handler = new ICMP6PacketHandler(this);
        byte[] byArray5 = new byte[8];
        byArray5[0] = -86;
        byArray5[1] = -86;
        this.prefix = byArray5;
        this.prefixSize = 64;
        this.configureIPAddress();
        this.neighborManager = new NeighborManager(this, this.neighborTable);
        this.tcpHandler = new TCPHandler(this);
        this.udpHandler = new UDPHandler();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public TCPConnection listen(int port) {
        return this.tcpHandler.addListenConnection(port);
    }

    public void listen(UDPListener listener, int port) throws IOException {
        this.udpHandler.addUDPListener(listener, port);
    }

    public NeighborTable getNeighborTable() {
        return this.neighborTable;
    }

    public NeighborManager getNeighborManager() {
        return this.neighborManager;
    }

    public void setLinkLayerHandler(PacketHandler handler) {
        this.linkLayerHandler = handler;
    }

    public void setNetworkEventListener(NetworkEventListener li) {
        this.networkEventListener = li;
    }

    public void setTunnel(NetworkInterface tunnel) {
        this.tunnel = tunnel;
    }

    public void setPrefix(byte[] prefix, int size) {
        this.prefix = prefix;
        this.prefixSize = size;
        this.configureIPAddress();
    }

    public boolean isOnLink(byte[] address) {
        if (address[0] == -1 || address[0] == -2 && address[1] == -128) {
            return true;
        }
        if (Utils.equals(UNSPECIFIED, address)) {
            return true;
        }
        int i = 0;
        while (i < this.prefixSize / 8) {
            if (address[i] != this.prefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void configureIPAddress() {
        if (this.prefix != null) {
            System.arraycopy(this.prefix, 0, this.myIPAddress, 0, this.prefixSize / 8);
        }
        int i = 0;
        while (i < 8) {
            byte by = this.myLinkAddress[i];
            this.myIPAddress[8 + i] = by;
            this.myLocalIPAddress[8 + i] = by;
            ++i;
        }
        this.myLocalIPAddress[8] = this.myIPAddress[8] = (byte)(this.myIPAddress[8] ^ 2);
        i = 13;
        while (i < 16) {
            this.myLocalSolicited[i] = this.myIPAddress[i];
            ++i;
        }
        System.out.print("***** Configured IP address: ");
        IPv6Packet.printAddress(System.out, this.myIPAddress);
        System.out.println();
        System.out.print("***** Configured Local IP address: ");
        IPv6Packet.printAddress(System.out, this.myLocalIPAddress);
        System.out.println();
        System.out.print("***** Configured Solicited IP address: ");
        IPv6Packet.printAddress(System.out, this.myLocalSolicited);
        System.out.println();
    }

    private boolean findRoute(IPv6Packet packet) {
        if (packet.getLinkDestination() == null) {
            byte[] destAddr = packet.getDestinationAddress();
            if (Utils.equals(ALL_ROUTERS, destAddr)) {
                packet.setAttribute("link.destination", this.linkBroadcast);
            } else if (Utils.equals(ALL_NODES, destAddr)) {
                packet.setAttribute("link.destination", this.linkBroadcast);
            } else {
                byte[] destMAC;
                Neighbor n = this.neighborTable.getNeighbor(destAddr);
                if (n == null) {
                    if (this.neighborTable.getDefrouter() != null) {
                        destMAC = this.neighborTable.getDefrouter().linkAddress;
                    } else {
                        destMAC = new byte[8];
                        this.makeLLAddress(destAddr, destMAC);
                    }
                } else {
                    destMAC = n.linkAddress;
                }
                packet.setAttribute("link.destination", destMAC);
            }
        }
        packet.setAttribute("link.source", this.myLinkAddress);
        return true;
    }

    public void makeLLAddress(byte[] ipAddr, byte[] macAddr) {
        int i = 0;
        while (i < macAddr.length) {
            macAddr[i] = ipAddr[8 + i];
            ++i;
        }
        macAddr[0] = (byte)(macAddr[0] ^ 2);
    }

    public void sendPacket(IPv6Packet packet, NetworkInterface nIf) {
        if (nIf == this.linkLayerHandler || nIf == null && this.isOnLink(packet.getDestinationAddress())) {
            if (this.findRoute(packet)) {
                this.linkLayerHandler.sendPacket(packet);
            }
        } else if (this.tunnel != null && this.tunnel.isReady()) {
            this.tunnel.sendPacket(packet);
        }
    }

    public void receivePacket(IPv6Packet packet) {
        block21: {
            block20: {
                if (!this.isForMe(packet.getDestinationAddress())) break block20;
                switch (packet.nextHeader) {
                    case 58: {
                        this.icmp6Handler.handlePacket(packet);
                        if (this.networkEventListener != null) {
                            this.networkEventListener.packetHandled(packet);
                            break;
                        }
                        break block21;
                    }
                    case 17: {
                        if (packet.getIPPayload() != null) {
                            packet.getIPPayload().printPacket(System.out);
                            this.udpHandler.handlePacket(packet, (UDPPacket)packet.getIPPayload());
                        } else {
                            UDPPacket p = new UDPPacket();
                            p.parsePacketData(packet);
                            p.printPacket(System.out);
                            packet.setIPPayload(p);
                            this.udpHandler.handlePacket(packet, p);
                        }
                        if (this.networkEventListener != null) {
                            this.networkEventListener.packetHandled(packet);
                            break;
                        }
                        break block21;
                    }
                    case 6: {
                        TCPPacket p = new TCPPacket();
                        p.parsePacketData(packet);
                        p.printPacket(System.out);
                        packet.setIPPayload(p);
                        this.tcpHandler.handlePacket(packet);
                        if (this.networkEventListener == null) break block21;
                        this.networkEventListener.packetHandled(packet);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block21;
            }
            if (!this.isOnLink(packet.getDestinationAddress()) && packet.netInterface != this.tunnel) {
                if (packet.ipPayload == null) {
                    packet.setIPPayload(new BytePayload(packet));
                }
                if (this.tunnel != null && this.tunnel.isReady()) {
                    this.tunnel.sendPacket(packet);
                }
            } else if (packet.netInterface != this.linkLayerHandler) {
                if (packet.ipPayload == null) {
                    packet.setIPPayload(new BytePayload(packet));
                    if (this.findRoute(packet)) {
                        this.linkLayerHandler.sendPacket(packet);
                    }
                }
            } else {
                System.out.println("#### PACKET ignored...");
            }
        }
    }

    private boolean isForMe(byte[] address) {
        if (Utils.equals(this.myIPAddress, address) || Utils.equals(this.myLocalIPAddress, address) || Utils.equals(this.myLocalSolicited, address)) {
            return true;
        }
        if (this.isRouter && Utils.equals(ALL_ROUTERS, address)) {
            return true;
        }
        if (Utils.equals(ALL_NODES, address)) {
            return true;
        }
        return Utils.equals(UNSPECIFIED, address);
    }

    public void setLinkLayerAddress(byte[] addr) {
        this.myLinkAddress = addr;
        this.configureIPAddress();
    }

    public void setIPAddress(byte[] addr) {
        this.myIPAddress = addr;
    }

    public byte[] getLinkLayerAddress() {
        return this.myLinkAddress;
    }

    public byte[] getIPAddress() {
        return this.myIPAddress;
    }

    public IPPacketer getPacketer() {
        return this.getDefaultPacketer();
    }

    public void setDefaultPacketer(IPPacketer defaultPacketer) {
        this.defaultPacketer = defaultPacketer;
    }

    public IPPacketer getDefaultPacketer() {
        return this.defaultPacketer;
    }

    public void setRouter(boolean isRouter) {
        this.isRouter = isRouter;
    }

    public boolean isRouter() {
        return this.isRouter;
    }

    public void printTCPStatus(PrintStream out) {
        this.tcpHandler.printStatus(out);
    }
}

