/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import se.sics.jipv6.core.ICMP6Packet;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.IPv6Packet;

public class ICMP6PacketHandler {
    IPStack ipStack;

    public ICMP6PacketHandler(IPStack stack) {
        this.ipStack = stack;
    }

    public void handlePacket(IPv6Packet packet) {
        ICMP6Packet icmpPacket = new ICMP6Packet();
        icmpPacket.parsePacketData(packet);
        packet.setIPPayload(icmpPacket);
        icmpPacket.printPacket(System.out);
        switch (icmpPacket.type) {
            case 128: {
                ICMP6Packet p = new ICMP6Packet();
                p.type = 129;
                p.seqNo = icmpPacket.seqNo;
                p.id = icmpPacket.id;
                p.echoData = icmpPacket.echoData;
                IPv6Packet ipp = new IPv6Packet();
                ipp.setIPPayload(p);
                ipp.destAddress = packet.sourceAddress;
                ipp.sourceAddress = this.ipStack.myIPAddress;
                this.ipStack.sendPacket(ipp, packet.netInterface);
                break;
            }
            case 129: {
                System.out.println("ICMP6 got echo reply!!");
                break;
            }
            case 135: {
                ICMP6Packet p = new ICMP6Packet();
                p.targetAddress = icmpPacket.targetAddress;
                p.type = 136;
                p.flags = 96;
                if (this.ipStack.isRouter()) {
                    p.flags |= 0x80;
                }
                p.addLinkOption(2, this.ipStack.getLinkLayerAddress());
                IPv6Packet ipp = new IPv6Packet();
                ipp.setIPPayload(p);
                ipp.destAddress = packet.sourceAddress.equals(IPStack.UNSPECIFIED) ? IPStack.ALL_NODES : packet.sourceAddress;
                ipp.sourceAddress = this.ipStack.myLocalIPAddress;
                this.ipStack.sendPacket(ipp, packet.netInterface);
                break;
            }
            case 133: {
                this.ipStack.getNeighborManager().receiveNDMessage(packet);
                break;
            }
            case 134: {
                byte[] prefixInfo;
                if (this.ipStack.isRouter() || (prefixInfo = icmpPacket.getOption(3)) == null) break;
                byte[] prefix = new byte[16];
                System.arraycopy(prefixInfo, 16, prefix, 0, prefix.length);
                byte size = prefixInfo[2];
                this.ipStack.setPrefix(prefix, size);
                this.ipStack.getNeighborManager().receiveNDMessage(packet);
            }
        }
    }
}

