/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.PrintStream;
import java.util.Vector;
import se.sics.jipv6.core.IPPayload;
import se.sics.jipv6.core.IPStack;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.Packet;
import se.sics.jipv6.util.Utils;

public class ICMP6Packet
implements IPPayload {
    public static final int DISPATCH = 58;
    public static final int ECHO_REQUEST = 128;
    public static final int ECHO_REPLY = 129;
    public static final int GROUP_QUERY = 130;
    public static final int GROUP_REPORT = 131;
    public static final int GROUP_REDUCTION = 132;
    public static final int ROUTER_SOLICITATION = 133;
    public static final int ROUTER_ADVERTISEMENT = 134;
    public static final int NEIGHBOR_SOLICITATION = 135;
    public static final int NEIGHBOR_ADVERTISEMENT = 136;
    public static final int FLAG_ROUTER = 128;
    public static final int FLAG_SOLICITED = 64;
    public static final int FLAG_OVERRIDE = 32;
    public static final int ON_LINK = 128;
    public static final int AUTOCONFIG = 64;
    public static final int SOURCE_LINKADDR = 1;
    public static final int TARGET_LINKADDR = 2;
    public static final int PREFIX_INFO = 3;
    public static final int MTU_INFO = 5;
    public static final String[] TYPE_NAME = new String[]{"ECHO_REQUEST", "ECHO_REPLY", "GROUP_QUERY", "GROUP_REPORT", "GROUP_REDUCTION", "ROUTER_SOLICITATION", "ROUTER_ADVERTISEMENT", "NEIGHBOR_SOLICITATION", "NEIGHBOR_ADVERTISEMENT"};
    int type;
    int code;
    int checksum;
    byte[] targetAddress;
    int id;
    int seqNo;
    int flags;
    byte hopLimit = (byte)-128;
    byte autoConfigFlags;
    int routerLifetime = 65535;
    int reachableTime = 360000;
    int retransmissionTimer = 3000;
    int mtuSize = 1280;
    byte[] echoData;
    private Vector options = new Vector();
    private static final byte[] defaultPrefixInfo;
    byte[] mtuOption;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 3;
        byArray[1] = 4;
        byArray[2] = 64;
        byArray[3] = -64;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[16] = -86;
        byArray[17] = -86;
        defaultPrefixInfo = byArray;
    }

    public ICMP6Packet() {
        byte[] byArray = new byte[8];
        byArray[0] = 5;
        byArray[1] = 1;
        byArray[6] = 5;
        this.mtuOption = byArray;
    }

    public ICMP6Packet(int type) {
        byte[] byArray = new byte[8];
        byArray[0] = 5;
        byArray[1] = 1;
        byArray[6] = 5;
        this.mtuOption = byArray;
        this.type = type;
    }

    void updateRA(IPStack stack) {
        byte[] llAddr = stack.getLinkLayerAddress();
        this.options.removeAllElements();
        byte[] prefixInfo = new byte[defaultPrefixInfo.length];
        System.arraycopy(defaultPrefixInfo, 0, prefixInfo, 0, defaultPrefixInfo.length);
        byte[] prefix = stack.prefix;
        System.arraycopy(prefix, 0, prefixInfo, 16, prefix.length);
        this.options.addElement(prefixInfo);
        this.options.addElement(this.mtuOption);
        this.addLinkOption(1, llAddr);
    }

    void addLinkOption(int type, byte[] llAddr) {
        byte[] opt = llAddr.length > 6 ? new byte[16] : new byte[8];
        opt[0] = (byte)type;
        opt[1] = (byte)(opt.length / 8);
        System.arraycopy(llAddr, 0, opt, 2, llAddr.length);
        this.options.addElement(opt);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public byte[] getOption(int type) {
        int i = 0;
        while (i < this.options.size()) {
            if (((byte[])this.options.elementAt(i))[0] == type) {
                return (byte[])this.options.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public byte[] getEchoData() {
        return this.echoData;
    }

    public void setEchoData(byte[] edata) {
        this.echoData = edata;
    }

    @Override
    public void printPacket(PrintStream out) {
        int tS;
        String typeS = "" + this.type;
        if (this.type >= 128 && (tS = this.type - 128) < TYPE_NAME.length) {
            typeS = TYPE_NAME[tS];
        }
        out.println("ICMPv6 Type: " + this.type + " (" + typeS + ") Code: " + this.code + " id: " + this.id + " seq: " + this.seqNo);
        if (this.targetAddress != null) {
            out.print("ICMPv6 Target address: ");
            IPv6Packet.printAddress(out, this.targetAddress);
            out.println();
        }
        if (this.type == 134) {
            System.out.println("ICMPv6 Route Advertisement");
            System.out.println("  Hop Limit: " + (this.hopLimit & 0xFF));
            System.out.println("  autoConfig: " + (this.autoConfigFlags & 0xFF));
            System.out.println("  routerLifeTime: " + this.routerLifetime + " (sec)");
            System.out.println("  reachableTime: " + this.reachableTime + " (msec)");
            System.out.println("  retransmissionTimer: " + this.retransmissionTimer + " (msec)");
            System.out.println("  autoConf: " + this.autoConfigFlags);
            byte[] prefixInfo = this.getOption(3);
            byte bits = prefixInfo[2];
            int bytes = bits / 8;
            out.print("RA Prefix: ");
            int i = 0;
            while (i < bytes) {
                out.print(Utils.hex8(prefixInfo[16 + i]));
                if ((i & 1) == 1) {
                    out.print(":");
                }
                ++i;
            }
            out.println("/" + bits);
            out.println("RA Valid Lifetime: " + Packet.get32(prefixInfo, 4));
            out.println("RA Pref. Lifetime: " + Packet.get32(prefixInfo, 8));
            byte[] srcLink = this.getOption(1);
            if (srcLink != null) {
                System.out.print("Source Link: ");
                IPv6Packet.printMACAddress(out, srcLink, 2, 8);
                System.out.println();
            }
        }
    }

    @Override
    public void parsePacketData(IPv6Packet packet) {
        if (packet.nextHeader == 58) {
            this.type = packet.getData(0) & 0xFF;
            this.code = packet.getData(1) & 0xFF;
            this.checksum = (packet.getData(2) & 0xFF) << 8 | packet.getData(3) & 0xFF;
            packet.setData(2, (byte)0);
            packet.setData(3, (byte)0);
            switch (this.type) {
                case 128: 
                case 129: {
                    this.id = packet.get16(4);
                    this.seqNo = packet.get16(6);
                    int dataLen = packet.getPayloadLength() - 8;
                    if (dataLen <= 0) break;
                    this.echoData = new byte[dataLen];
                    packet.copy(8, this.echoData, 0, dataLen);
                    break;
                }
                case 135: 
                case 136: {
                    if (this.type == 136) {
                        this.flags = packet.getData(4) & 0xFF;
                    }
                    this.targetAddress = new byte[16];
                    packet.copy(8, this.targetAddress, 0, 16);
                    this.handleOptions(packet, 24);
                    break;
                }
                case 133: {
                    break;
                }
                case 134: {
                    this.hopLimit = packet.getData(4);
                    this.autoConfigFlags = packet.getData(5);
                    this.routerLifetime = packet.get16(6);
                    this.reachableTime = packet.get32(8);
                    this.retransmissionTimer = packet.get32(12);
                    this.handleOptions(packet, 16);
                }
            }
            byte[] data = packet.getPayload();
            System.out.println("Payloadsize: " + data.length);
            int sum = packet.upperLayerHeaderChecksum();
            sum = IPv6Packet.checkSum(sum, data, data.length);
            sum = ~sum & 0xFFFF;
            if (sum == this.checksum) {
                System.out.println("ICMPv6: Checksum matches!!!");
            } else {
                System.out.println("ICMPv6: Checksum error: " + Utils.hex16(this.checksum) + " <?> " + Utils.hex16(sum));
            }
        }
    }

    private void handleOptions(IPv6Packet packet, int pos) {
        int size = packet.getPayloadLength();
        System.out.println("ICMPv6 Options: total size: " + size + " pos: " + pos);
        while (pos < size) {
            byte type = packet.getData(pos);
            int oSize = (packet.getData(pos + 1) & 0xFF) * 8;
            System.out.println("Handling option: " + type + " size " + oSize);
            if (oSize == 0) {
                return;
            }
            byte[] option = new byte[oSize];
            packet.copy(pos, option, 0, oSize);
            this.options.addElement(option);
            pos += oSize;
        }
    }

    @Override
    public byte[] generatePacketData(IPv6Packet packet) {
        byte[] buffer = new byte[127];
        buffer[0] = (byte)this.type;
        buffer[1] = (byte)this.code;
        int pos = 4;
        switch (this.type) {
            case 128: 
            case 129: {
                buffer[pos++] = (byte)(this.id >> 8);
                buffer[pos++] = (byte)(this.id & 0xFF);
                buffer[pos++] = (byte)(this.seqNo >> 8);
                buffer[pos++] = (byte)(this.seqNo & 0xFF);
                if (this.echoData == null) break;
                int i = 0;
                while (i < this.echoData.length) {
                    buffer[pos++] = this.echoData[i];
                    ++i;
                }
                break;
            }
            case 135: 
            case 136: {
                if (this.type == 136) {
                    buffer[pos++] = (byte)this.flags;
                }
                pos = 8;
                int i = 0;
                while (i < this.targetAddress.length) {
                    buffer[pos++] = this.targetAddress[i];
                    ++i;
                }
                pos = this.addOptions(buffer, pos);
                break;
            }
            case 133: {
                buffer[pos++] = 0;
                buffer[pos++] = 0;
                buffer[pos++] = 0;
                buffer[pos++] = 0;
                pos = this.addOptions(buffer, pos);
                break;
            }
            case 134: {
                buffer[pos++] = this.hopLimit;
                buffer[pos++] = this.autoConfigFlags;
                buffer[pos++] = (byte)(this.routerLifetime >> 8 & 0xFF);
                buffer[pos++] = (byte)(this.routerLifetime & 0xFF);
                IPv6Packet.set32(buffer, pos, this.reachableTime);
                IPv6Packet.set32(buffer, pos += 4, this.retransmissionTimer);
                pos += 4;
                pos = this.addOptions(buffer, pos);
            }
        }
        byte[] packetData = new byte[pos];
        System.arraycopy(buffer, 0, packetData, 0, pos);
        packet.payloadLen = pos;
        int sum = packet.upperLayerHeaderChecksum();
        sum = IPv6Packet.checkSum(sum, packetData, packetData.length);
        sum = ~sum & 0xFFFF;
        packetData[2] = (byte)(sum >> 8);
        packetData[3] = (byte)(sum & 0xFF);
        return packetData;
    }

    private int addOptions(byte[] buffer, int pos) {
        int i = 0;
        while (i < this.options.size()) {
            byte[] option = (byte[])this.options.elementAt(i);
            System.out.println("Adding option: " + option[0] + " len: " + option[1] + "/" + option.length + " at " + pos);
            System.arraycopy(option, 0, buffer, pos, option.length);
            pos += option.length;
            ++i;
        }
        return pos;
    }

    @Override
    public byte getDispatch() {
        return 58;
    }

    public static void main(String[] args) {
        byte[] pData = Utils.hexconv("6000000000403a3f200105c01000000a00000000000001ad200105c011024e000212740504030201800070e3de1b00011b87194ad859000008090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f3031323334353637");
        IPv6Packet packet = new IPv6Packet();
        packet.setBytes(pData);
        packet.parsePacketData(packet);
        if (packet.nextHeader == 58) {
            ICMP6Packet icmpPacket = new ICMP6Packet();
            icmpPacket.parsePacketData(packet);
            icmpPacket.printPacket(System.out);
        }
    }
}

