/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import se.sics.jipv6.core.IPPacketer;
import se.sics.jipv6.core.IPPayload;
import se.sics.jipv6.core.IPv6Packet;
import se.sics.jipv6.core.UDPPacket;
import se.sics.jipv6.util.Utils;

public class HC01Packeter
implements IPPacketer {
    private boolean DEBUG = false;
    public static final int IPHC_TC_C = 128;
    public static final int IPHC_VF_C = 64;
    public static final int IPHC_NH_C = 32;
    public static final int IPHC_TTL_1 = 8;
    public static final int IPHC_TTL_64 = 16;
    public static final int IPHC_TTL_255 = 24;
    public static final int IPHC_TTL_I = 0;
    public static final int IPHC_SAM_I = 0;
    public static final int IPHC_SAM_64 = 64;
    public static final int IPHC_SAM_16 = 128;
    public static final int IPHC_SAM_0 = 192;
    public static final int IPHC_DAM_I = 0;
    public static final int IPHC_DAM_64 = 4;
    public static final int IPHC_DAM_16 = 8;
    public static final int IPHC_DAM_0 = 12;
    public static final int NHC_UDP_ID = 248;
    public static final int NHC_UDP_C = 251;
    public static final int NHC_UDP_I = 248;
    public static final int IPHC_ADDR_CONTEXT_LL = 0;
    public static final int IPHC_MCAST_RANGE = 160;
    public static final int UDP_PORT_MIN = 61616;
    public static final int UDP_PORT_MAX = 61631;
    public static final int HC01_DISPATCH = 3;
    public static final int PROTO_ICMP = 1;
    public static final int PROTO_TCP = 6;
    public static final int PROTO_UDP = 17;
    public static final int PROTO_ICMP6 = 58;
    private AddrContext[] contexts = new AddrContext[4];

    public HC01Packeter() {
        this.contexts[0] = new AddrContext();
        this.contexts[1] = new AddrContext();
        this.contexts[0].number = 0;
        this.contexts[0].prefix[0] = -2;
        this.contexts[0].prefix[1] = -128;
        this.contexts[1].number = 1;
        this.contexts[1].prefix[0] = -86;
        this.contexts[1].prefix[1] = -86;
    }

    @Override
    public byte getDispatch() {
        return 3;
    }

    private boolean is16bitCompressable(byte[] address) {
        return (address[8] | address[9] | address[10] | address[11] | address[12] | address[13]) == 0 && (address[14] & 0x80) == 0;
    }

    @Override
    public byte[] generatePacketData(IPv6Packet packet) {
        byte[] pload;
        int enc1 = 0;
        int enc2 = 0;
        byte[] data = new byte[48];
        int pos = 2;
        if (packet.flowLabel == 0) {
            enc1 |= 0x40;
        }
        if (packet.trafficClass == 0) {
            enc1 |= 0x80;
        }
        if ((enc1 & 0x40) == 0) {
            pos += this.writeVFlow(packet, data, pos);
        }
        if ((enc1 & 0x80) == 0) {
            data[pos++] = (byte)(packet.trafficClass & 0xFF);
        }
        if (packet.nextHeader == 17) {
            enc1 |= 0x20;
        } else {
            data[pos++] = (byte)(packet.nextHeader & 0xFF);
        }
        switch (packet.hopLimit) {
            case 1: {
                enc1 |= 8;
                break;
            }
            case 64: {
                enc1 |= 0x10;
                break;
            }
            case 255: {
                enc1 |= 0x18;
                break;
            }
            default: {
                data[pos++] = (byte)(packet.hopLimit & 0xFF);
            }
        }
        int context = this.lookupContext(packet.sourceAddress);
        if (context != -1) {
            if (this.DEBUG) {
                System.out.println("HC01: Found context (SRC): " + context);
            }
            enc2 |= context << 4;
            if (packet.isSourceMACBased()) {
                enc2 |= 0xC0;
            } else if (this.is16bitCompressable(packet.sourceAddress)) {
                enc2 |= 0x80;
                data[pos++] = packet.sourceAddress[14];
                data[pos++] = packet.sourceAddress[15];
            } else {
                enc2 |= 0x40;
                System.arraycopy(packet.sourceAddress, 8, data, pos, 8);
                pos += 8;
            }
        } else {
            if (this.DEBUG) {
                System.out.println("HC01: no context - use full addr (SRC)");
            }
            enc2 |= 0;
            System.arraycopy(packet.sourceAddress, 0, data, pos, 16);
            pos += 16;
        }
        if (packet.isMulticastDestination()) {
            if (this.isMulticastCompressable(packet.destAddress)) {
                enc2 |= 8;
                data[pos] = -96;
                int n = pos++;
                data[n] = (byte)(data[n] | (packet.destAddress[1] & 0xF) << 1);
                data[pos++] = packet.destAddress[15];
            } else {
                enc2 |= 0;
                System.arraycopy(packet.destAddress, 0, data, pos, 16);
                pos += 16;
            }
        } else {
            context = this.lookupContext(packet.destAddress);
            if (context != -1) {
                if (this.DEBUG) {
                    System.out.println("HC01: Found context (DST): " + context);
                }
                enc2 |= context;
                if (packet.isDestinationMACBased()) {
                    enc2 |= 0xC;
                } else if (this.is16bitCompressable(packet.destAddress)) {
                    enc2 |= 8;
                    data[pos++] = packet.destAddress[14];
                    data[pos++] = packet.destAddress[15];
                } else {
                    enc2 |= 4;
                    System.arraycopy(packet.destAddress, 8, data, pos, 8);
                    pos += 8;
                }
            } else {
                if (this.DEBUG) {
                    System.out.println("HC01: full destination address");
                }
                enc2 |= 0;
                System.arraycopy(packet.destAddress, 0, data, pos, 16);
                pos += 16;
            }
        }
        if (packet.nextHeader == 17) {
            int checksum;
            UDPPacket udp = (UDPPacket)packet.getIPPayload();
            if (udp.sourcePort >= 61616 && udp.sourcePort < 61631 && udp.destinationPort >= 61616 && udp.destinationPort < 61631) {
                data[pos++] = -5;
                data[pos++] = (byte)((udp.sourcePort - 61616 << 4) + (udp.destinationPort - 61616));
                checksum = udp.doVirtualChecksum(packet);
                data[pos++] = (byte)(checksum >> 8);
                data[pos++] = (byte)(checksum & 0xFF);
            } else {
                data[pos++] = -8;
                data[pos++] = (byte)(udp.sourcePort >> 8);
                data[pos++] = (byte)(udp.sourcePort & 0xFF);
                data[pos++] = (byte)(udp.destinationPort >> 8);
                data[pos++] = (byte)(udp.destinationPort & 0xFF);
                checksum = udp.doVirtualChecksum(packet);
                data[pos++] = (byte)(checksum >> 8);
                data[pos++] = (byte)(checksum & 0xFF);
            }
        }
        data[0] = (byte)(enc1 & 0xFF);
        data[1] = (byte)(enc2 & 0xFF);
        if (this.DEBUG) {
            System.out.println("HC01 Header compression: size " + pos + " enc1: " + Utils.hex8(enc1) + " enc2: " + Utils.hex8(enc2));
        }
        if (this.DEBUG) {
            System.out.print("HC01: From ");
            IPv6Packet.printAddress(System.out, packet.sourceAddress);
            System.out.print("HC01:   To ");
            IPv6Packet.printAddress(System.out, packet.destAddress);
        }
        if (packet.nextHeader == 17) {
            UDPPacket udp = (UDPPacket)packet.getIPPayload();
            pload = udp.payload;
        } else {
            IPPayload payload = packet.getIPPayload();
            pload = payload.generatePacketData(packet);
        }
        if (this.DEBUG) {
            System.out.println("HC01 Payload size: " + pload.length);
        }
        byte[] dataPacket = new byte[pos + pload.length];
        System.arraycopy(data, 0, dataPacket, 0, pos);
        System.arraycopy(pload, 0, dataPacket, pos, pload.length);
        return dataPacket;
    }

    public int writeVFlow(IPv6Packet packet, byte[] data, int pos) {
        data[pos++] = (byte)(0x60 | packet.flowLabel >> 16 & 0xF);
        data[pos++] = (byte)(packet.flowLabel >> 8 & 0xFF);
        data[pos++] = (byte)(packet.flowLabel & 0xFF);
        return 3;
    }

    @Override
    public void parsePacketData(IPv6Packet packet) {
        boolean frag;
        UDPPacket udp = null;
        int pos = 2;
        byte enc1 = packet.getData(0);
        byte enc2 = packet.getData(1);
        if ((enc1 & 0x40) == 0) {
            if ((enc1 & 0x80) == 0) {
                packet.version = (packet.getData(pos) & 0xF0) >> 4;
                packet.trafficClass = ((packet.getData(pos) & 0xF) << 4) + ((packet.getData(pos + 1) & 0xFF) >> 4);
                packet.flowLabel = (packet.getData(pos + 1) & 0xF) << 16 + (packet.getData(pos + 2) & 0xFF) << 8 + packet.getData(pos + 3) & 0xFF;
                pos += 4;
            } else {
                packet.version = 6;
                packet.trafficClass = 0;
                packet.flowLabel = (packet.getData(pos) & 0xF) << 16 + (packet.getData(pos + 1) & 0xFF) << 8 + packet.getData(pos + 2) & 0xFF;
                pos += 3;
            }
        } else {
            packet.version = 6;
            packet.flowLabel = 0;
            if ((enc1 & 0x80) == 0) {
                packet.trafficClass = packet.getData(pos) & 0xFF;
                ++pos;
            } else {
                packet.trafficClass = 0;
            }
        }
        if ((enc1 & 0x20) == 0) {
            packet.nextHeader = packet.getData(pos++);
        }
        switch (enc1 & 0x18) {
            case 8: {
                packet.hopLimit = 1;
                break;
            }
            case 16: {
                packet.hopLimit = 64;
                break;
            }
            case 24: {
                packet.hopLimit = 255;
                break;
            }
            case 0: {
                packet.hopLimit = packet.getData(pos++);
            }
        }
        int srcAddress = (enc2 & 0x30) >> 4;
        AddrContext context = this.lookupContext(srcAddress);
        if (this.DEBUG) {
            System.out.println("HC01: uncompress (SRC) enc2 & c0 = " + (enc2 & 0xC0) + " ctx =" + srcAddress);
        }
        switch (enc2 & 0xC0) {
            case 192: {
                if (context == null) {
                    System.out.println("sicslowpan uncompress_hdr: error context not found\n");
                    return;
                }
                System.arraycopy(context.prefix, 0, packet.sourceAddress, 0, 8);
                byte[] linkAddress = packet.getLinkSource();
                System.arraycopy(linkAddress, 0, packet.sourceAddress, 8, 8);
                packet.sourceAddress[8] = (byte)(packet.sourceAddress[8] ^ 2);
                break;
            }
            case 128: {
                if ((packet.getData(pos) & 0x80) == 0) {
                    if (context == null) {
                        System.out.println("sicslowpan uncompress_hdr: error context not found\n");
                        return;
                    }
                    System.arraycopy(context.prefix, 0, packet.sourceAddress, 0, 8);
                    Utils.fill(packet.sourceAddress, 8, 14, (byte)0);
                    packet.sourceAddress[14] = packet.getData(pos);
                    packet.sourceAddress[15] = packet.getData(pos + 1);
                    pos += 2;
                    break;
                }
                Utils.fill(packet.sourceAddress, 0, 16, (byte)0);
                packet.sourceAddress[0] = -1;
                packet.sourceAddress[1] = (byte)((packet.getData(pos) & 0xFF) >> 1 & 0xF);
                packet.sourceAddress[15] = packet.getData(pos + 1);
                pos += 2;
                break;
            }
            case 64: {
                if (context == null) {
                    System.out.println("sicslowpan uncompress_hdr: error context not found\n");
                    return;
                }
                System.arraycopy(context.prefix, 0, packet.sourceAddress, 0, 8);
                packet.copy(pos, packet.sourceAddress, 8, 8);
                pos += 8;
                break;
            }
            case 0: {
                if (this.DEBUG) {
                    System.out.println("HC01: full address used (SRC)");
                }
                packet.copy(pos, packet.sourceAddress, 0, 16);
                pos += 16;
            }
        }
        context = this.lookupContext(enc2 & 3);
        if (this.DEBUG) {
            System.out.println("HC01: uncompress (DST) enc2 & 0x0c = " + (enc2 & 0xC) + " ctx =" + (enc2 & 3));
        }
        switch (enc2 & 0xC) {
            case 12: {
                if (context == null) {
                    System.out.println("sicslowpan uncompress_hdr: error context not found\n");
                    return;
                }
                System.arraycopy(context.prefix, 0, packet.destAddress, 0, 8);
                byte[] destAddress = packet.getLinkDestination();
                System.arraycopy(destAddress, 0, packet.destAddress, 8, 8);
                packet.destAddress[8] = (byte)(packet.destAddress[8] ^ 2);
                break;
            }
            case 8: {
                if ((packet.getData(pos) & 0x80) == 0) {
                    if (context == null) {
                        System.out.println("sicslowpan uncompress_hdr: error context not found\n");
                        return;
                    }
                    System.arraycopy(context.prefix, 0, packet.destAddress, 0, 8);
                    packet.destAddress[14] = packet.getData(pos);
                    packet.destAddress[15] = packet.getData(pos + 1);
                    pos += 2;
                    break;
                }
                Utils.fill(packet.destAddress, 0, 16, (byte)0);
                packet.destAddress[0] = -1;
                packet.destAddress[1] = (byte)((packet.getData(pos) & 0xFF) >> 1 & 0xF);
                packet.destAddress[15] = (byte)(packet.getData(pos + 1) & 0xFF);
                pos += 2;
                break;
            }
            case 4: {
                if (context == null) {
                    System.out.println("sicslowpan uncompress_hdr: error context not found\n");
                    return;
                }
                System.arraycopy(context.prefix, 0, packet.destAddress, 0, 8);
                packet.copy(pos, packet.destAddress, 8, 8);
                pos += 8;
                break;
            }
            case 0: {
                packet.copy(pos, packet.destAddress, 0, 16);
                pos += 16;
            }
        }
        if ((enc1 & 0x20) != 0 && (packet.getData(pos) & 0xFC) == 248) {
            if (this.DEBUG) {
                System.out.println("HC01: Next header UDP!");
            }
            packet.nextHeader = (byte)17;
            int srcPort = 0;
            int destPort = 0;
            int checkSum = 0;
            switch (packet.getData(pos) & 0xFF) {
                case 251: {
                    srcPort = 61616 + ((packet.getData(pos + 1) & 0xFF) >> 4);
                    destPort = 61616 + (packet.getData(pos + 1) & 0xF);
                    checkSum = ((packet.getData(pos + 2) & 0xFF) << 8) + (packet.getData(pos + 3) & 0xFF);
                    pos += 4;
                    break;
                }
                case 248: {
                    srcPort = ((packet.getData(pos + 1) & 0xFF) << 8) + (packet.getData(pos + 2) & 0xFF);
                    destPort = ((packet.getData(pos + 3) & 0xFF) << 8) + (packet.getData(pos + 4) & 0xFF);
                    checkSum = ((packet.getData(pos + 5) & 0xFF) << 8) + (packet.getData(pos + 6) & 0xFF);
                    pos += 7;
                    break;
                }
                default: {
                    System.out.println("sicslowpan uncompress_hdr: error unsupported UDP compression\n");
                    return;
                }
            }
            udp = new UDPPacket();
            udp.sourcePort = srcPort;
            udp.destinationPort = destPort;
            udp.checkSum = checkSum;
        }
        if (!(frag = false)) {
            packet.incPos(pos);
        }
        if (this.DEBUG) {
            System.out.println("Encoding 0: " + Utils.hex8(enc1) + " Encoding 1: " + Utils.hex8(enc2));
            System.out.println("TTL: " + packet.hopLimit);
            System.out.print("Src Addr: ");
            IPv6Packet.printAddress(System.out, packet.sourceAddress);
            System.out.print("Dst Addr: ");
            IPv6Packet.printAddress(System.out, packet.destAddress);
            System.out.println();
        }
        packet.payloadLen = packet.getPayloadLength();
        if (udp != null) {
            udp.payload = packet.getPayload();
            udp.length = udp.payload.length + 8;
            packet.payloadLen += 8;
            udp.doVirtualChecksum(packet);
            packet.setIPPayload(udp);
        }
    }

    private boolean isMulticastCompressable(byte[] address) {
        int i = 2;
        while (i < 15) {
            if (address[i] != 0) {
                return false;
            }
            ++i;
        }
        return address[15] == 1 || address[15] == 2;
    }

    private AddrContext lookupContext(int index) {
        if (index < this.contexts.length) {
            return this.contexts[index];
        }
        return null;
    }

    private int lookupContext(byte[] address) {
        int i = 0;
        while (i < this.contexts.length) {
            if (this.contexts[i] != null && this.contexts[i].matchPrefix(address)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class AddrContext {
        int used;
        int number;
        byte[] prefix = new byte[8];

        private AddrContext() {
        }

        public boolean matchPrefix(byte[] address) {
            int i = 0;
            while (i < this.prefix.length) {
                if (this.prefix[i] != address[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

