/*
 * Decompiled with CFR 0.152.
 */
package se.sics.jipv6.core;

import java.io.PrintStream;
import java.util.Vector;
import se.sics.jipv6.core.Packet;
import se.sics.jipv6.core.PacketHandler;

public abstract class AbstractPacketHandler
implements PacketHandler {
    boolean debug = true;
    Vector upperLayers = new Vector();
    protected PacketHandler lowerLayer;

    public PacketHandler getLowerLayerHandler() {
        return this.lowerLayer;
    }

    @Override
    public void addUpperLayerHandler(int protoID, PacketHandler handler) {
        PacketHandlerDispatch layer = new PacketHandlerDispatch();
        layer.dispatch = protoID;
        layer.packetHandler = handler;
        this.upperLayers.addElement(layer);
    }

    @Override
    public void setLowerLayerHandler(PacketHandler handler) {
        this.lowerLayer = handler;
    }

    protected void dispatch(int dispatch, Packet packet) {
        if (this.debug) {
            this.printPacket(System.out, packet);
        }
        if (dispatch != -1) {
            int i = 0;
            while (i < this.upperLayers.size()) {
                if (((PacketHandlerDispatch)this.upperLayers.elementAt((int)i)).dispatch == dispatch) {
                    ((PacketHandlerDispatch)this.upperLayers.elementAt((int)i)).packetHandler.packetReceived(packet);
                    return;
                }
                ++i;
            }
            System.out.println("**** no dispatch handler for " + dispatch + " found...");
        } else if (this.upperLayers.size() > 0) {
            ((PacketHandlerDispatch)this.upperLayers.elementAt((int)0)).packetHandler.packetReceived(packet);
        }
    }

    @Override
    public abstract void packetReceived(Packet var1);

    @Override
    public abstract void sendPacket(Packet var1);

    public void printPacket(PrintStream out, Packet packet) {
    }

    private static class PacketHandlerDispatch {
        int dispatch;
        PacketHandler packetHandler;

        private PacketHandlerDispatch() {
        }
    }
}

