/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#ifndef __SHAWN_LEGACYAPPS_WS08_TEMPERATURE_READING_H
#define __SHAWN_LEGACYAPPS_WS08_TEMPERATURE_READING_H
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "apps/reading/simple_reading.h"
#include "sys/event_scheduler.h"
#include <vector>

namespace ws08
{

   /**
    *
    */
   class Ws08TemperatureReading
      : public reading::DoubleReading, shawn::EventScheduler::EventHandler
   {

   public:

      ///@name Ctor/Dtor
      ///@{
      Ws08TemperatureReading();
      virtual ~Ws08TemperatureReading();
      ///@}

      ///@name Basic methods inherited from the superclass KeeperManaged
      ///@{
      virtual std::string name( void ) const throw();
      virtual std::string description( void ) const throw();
      ///@}

      ///@name Basic methods inherited from DoubleReading
      ///@{
      /**
       *
       */
      virtual void init( void ) throw();
      /**
       *
       */
      virtual ValueType value( const shawn::Vec& v ) const throw();
      ///@}

      ///@name Basic method inherited from EventHandler
      ///@{
      /** This method should be exclusively called by the EventScheduler.
       *  On timeout, may SandbagWaterlineReading has changed and informs every
       *  ReadingChangedHandler, whose box intersects with the box containing
       *  new values, that its content has changed.
       */
      void timeout( shawn::EventScheduler&, shawn::EventScheduler::EventHandle,
                    double, shawn::EventScheduler::EventTagHandle& )
         throw();
      ///@}
      

   private:
      
      shawn::EventScheduler::EventHandle event_handle_;
   };

}

#endif
#endif
