/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "legacyapps/ws08/ws08_temperature_reading.h"
#include "sys/world.h"
#include "sys/simulation/simulation_controller.h"
#include "sys/simulation/simulation_environment.h"
#include "apps/reading/reading_keeper.h"
#include <algorithm>
#include <cmath>


namespace ws08
{

   Ws08TemperatureReading::
   Ws08TemperatureReading()
   {}
   // ----------------------------------------------------------------------
   Ws08TemperatureReading::
   ~Ws08TemperatureReading()
   {}
   // ----------------------------------------------------------------------
   std::string
   Ws08TemperatureReading::
   name( void )
      const throw()
   {
      return "ws08_temperature";
   }
   // ----------------------------------------------------------------------
   std::string
   Ws08TemperatureReading::
   description( void )
      const throw()
   {
      return "Temperature in a virtual scenario.";
   }
   // ----------------------------------------------------------------------
   void
   Ws08TemperatureReading::
   init( void )
      throw()
   {
      event_handle_ = world_w().scheduler_w().new_event( *this, 0.1, NULL );
   }
   // ----------------------------------------------------------------------
   reading::DoubleReading::ValueType
   Ws08TemperatureReading::
   value( const shawn::Vec& v )
      const throw()
   {
      double width  = world().upper_right().x() - world().lower_left().x();
      double height = world().upper_right().y() - world().lower_left().y();
      
      double x = (v.x() / width) * 20;
      double y = (v.y() / height) * 20;
      
      return y * std::sin( x / 2 );
   }
   // ----------------------------------------------------------------------
   void
   Ws08TemperatureReading::
   timeout( shawn::EventScheduler& event_scheduler,
            shawn::EventScheduler::EventHandle event_handle,
            double time,
            shawn::EventScheduler::EventTagHandle& event_tag_handle )
         throw()
   {
      // set new event for next iteration
      event_handle_ = world_w().scheduler_w().new_event( *this, time + 1, NULL );
   }

}

#endif
