/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#ifndef WS08_DELAYED_TRANSMISSION_MODEL_FACTORY_H_
#define WS08_DELAYED_TRANSMISSION_MODEL_FACTORY_H_
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08
#include <string>
#include "sys/transm_models/transmission_model_factory.h"

namespace ws08
{

   ///Creates instances of Ws08DelayedTransmissionModel
   class Ws08DelayedTransmissionModelFactory: public shawn::TransmissionModelFactory
   {
   public:
      Ws08DelayedTransmissionModelFactory();
      virtual ~Ws08DelayedTransmissionModelFactory();
      virtual std::string name(void) const throw();
      virtual std::string description(void) const throw();
      virtual shawn::TransmissionModel* create(
            const shawn::SimulationController&) throw();
   };

}

#endif
#endif
