/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "legacyapps/ws08/ws08_delayed_transmission_model.h"
#include "legacyapps/ws08/ws08_delayed_transmission_model_factory.h"
#include "sys/transm_models/transmission_model_keeper.h"
#include "sys/simulation/simulation_controller.h"
#include "sys/simulation/simulation_environment.h"

using namespace shawn;

namespace ws08
{

   Ws08DelayedTransmissionModelFactory::
   Ws08DelayedTransmissionModelFactory()
   {
   }
   // ----------------------------------------------------------------------
   Ws08DelayedTransmissionModelFactory::
   ~Ws08DelayedTransmissionModelFactory()
   {
   }
   // ----------------------------------------------------------------------
   std::string 
   Ws08DelayedTransmissionModelFactory::
   name(void) 
      const throw()
   {
      return std::string("ws08_delayed");
   }
   // ----------------------------------------------------------------------
   std::string 
   Ws08DelayedTransmissionModelFactory::
   description(void) 
      const throw()
   {
      return std::string(
            "A Ws08DelayedTransmissionModel (\"ws08_delayed\") delays message-delivery for one "
            "round with a given probability."
            "This probability has to be set in the configuration file by assigning a value between 0 and 1 to "
            "the required parameter $delay_prob .");
   }
   // ----------------------------------------------------------------------
   TransmissionModel*
   Ws08DelayedTransmissionModelFactory::
   create(const SimulationController& sc) 
      throw()
   {
      return new Ws08DelayedTransmissionModel();
   }

}

#endif

