/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#ifndef __WS08_DElAYED_TRANSMISSION_MODEL_H
#define __WS08_DElAYED_TRANSMISSION_MODEL_H
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "sys/transmission_model.h"

#include <queue>

namespace ws08
{

   class Ws08DelayedTransmissionModel: public shawn::TransmissionModel
   {
   public:
      ///@name Construction, destruction and lifecycle support
      ///@{

      Ws08DelayedTransmissionModel();
      virtual ~Ws08DelayedTransmissionModel();

      ///@
      ///@name Transmission model implementation
      ///@{

      ///Initializes the model
      /**
       * Reads required and optional parameters from the simulation environment
       */
      virtual void init(void) throw();
      ///
      virtual void reset(void) throw();

      ///Mobility is depending on mobility support from the edge model
      /** The edge model is used to determine the 1-hop neighbours
       * which will receive the message
       */
      virtual bool supports_mobility(void) const throw(std::logic_error);

      /// Stores each message in a list for delivery at the next simulation round start.
      virtual void
      send_message(shawn::TransmissionModel::MessageInfo& mi) throw();

      /// Delivers all messages which are in the list
      virtual void deliver_messages() throw();

      ///@}

   private:
      double prob_;

      ///Delivers one message to one node
      virtual void deliver_one_message(
            shawn::TransmissionModel::MessageInfo& mi) throw();

      ///The messages that have been sent by the nodes and are waiting for delivery
      /*
       * In aired_messages the messages that will be send during this round are stored
       */
      std::queue<shawn::TransmissionModel::MessageInfo*> aired_messages_;
      /*
       * queued_messages contains the messages received for sending this round, which are not delayed
       */
      std::queue<shawn::TransmissionModel::MessageInfo*> queued_messages_;
      /*
       * delayed_messages contains the messages received for sending, that will be delayed
       */
      std::queue<shawn::TransmissionModel::MessageInfo*> delayed_messages_;
   };

}

#endif
#endif
