/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#ifndef __SHAWN_LEGACYAPPS_WS08_TEMPERATURE_SENSOR_H
#define __SHAWN_LEGACYAPPS_WS08_TEMPERATURE_SENSOR_H
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "sys/misc/random/random_variable.h"
#include "sys/misc/random/normal_random_variable.h"
#include "apps/reading/simple_reading.h"


namespace shawn
{
    class SimulationController;
}


namespace ws08
{

   ///
   /**
    *
    */
   class Ws08TemperatureSensor
   {

   public:

      ///@name Ctor/Dtor
      ///@{
      Ws08TemperatureSensor();
      virtual ~Ws08TemperatureSensor();
      ///@}

      
      void init( shawn::SimulationController& sc ) throw();
      
      
      /**
       *
       */
      virtual double value( void ) throw();

      
      virtual void set_temperature_reading( const reading::DoubleReadingHandle& ) throw();
      virtual reading::DoubleReading& temperature_reading_w( void ) throw();
      virtual const reading::DoubleReading& temperature_reading( void ) const throw();
      
      virtual void set_node( shawn::Node& ) throw();
      virtual shawn::Node& node_w( void ) throw();
      virtual const shawn::Node& node( void ) const throw();
      

   private:

      ///
      shawn::Node *node_;
      ///
      reading::DoubleReadingHandle temperature_reading_;
            
      /// Fraction of malfuntioned sensors.
      double err_malfunction_frac_;
      /// Variance of resulting measurement.
      double measure_variance_;
      /// if malfunctioned, sensor returns false values
      bool sensor_malfunction_;
      /// set to true, if init() has been called
      bool initialized_;

      shawn::ConstRandomVariableHandle uni_rnd_;
   };

}

#endif
#endif
