/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "legacyapps/ws08/ws08_temperature_sensor.h"
#include "sys/node.h"
#include "sys/world.h"
#include "sys/misc/basic_tag_rw.h"
#include "sys/simulation/simulation_controller.h"
#include "sys/simulation/simulation_environment.h"
#include "apps/reading/reading_keeper.h"
#include "sys/misc/random/random_variable_keeper.h"
#include <algorithm>


namespace ws08
{

   Ws08TemperatureSensor::
   Ws08TemperatureSensor()
     : err_malfunction_frac_ ( 0.0 ),
       measure_variance_     ( 0.0 ),
       sensor_malfunction_   ( false ),
       initialized_          ( false ),
       uni_rnd_              ( NULL )
   {}
   // ----------------------------------------------------------------------
   Ws08TemperatureSensor::
   ~Ws08TemperatureSensor()
   {}
   // ----------------------------------------------------------------------
   void
   Ws08TemperatureSensor::
   init( shawn::SimulationController& sc )
      throw()
   {
      const shawn::SimulationEnvironment& se = 
         sc.world().simulation_controller().environment();

      err_malfunction_frac_ = se.optional_double_param( 
                                          "malfunction_frac", 
                                          err_malfunction_frac_ );

      uni_rnd_ = sc.world().simulation_controller().
                     random_variable_keeper().find( "uni[0;1]" );

      if ( err_malfunction_frac_ > *uni_rnd_ )
         sensor_malfunction_ = true;
      
      initialized_ = true;
   }
   // ----------------------------------------------------------------------
   double
   Ws08TemperatureSensor::
   value( void )
      throw()
   {
      if ( sensor_malfunction_ )
         return temperature_reading().value( node().real_position() ) + 40.0;

      return temperature_reading().value( node().real_position() );
   }
   // ----------------------------------------------------------------------
   void 
   Ws08TemperatureSensor::
   set_temperature_reading( const reading::DoubleReadingHandle& drh ) throw()
   {
      assert( drh.is_not_null() );
      temperature_reading_ = drh;
   }
   // ----------------------------------------------------------------------
   reading::DoubleReading& 
   Ws08TemperatureSensor::
   temperature_reading_w( void ) throw()
   {
      assert( temperature_reading_.is_not_null() );
      return *temperature_reading_;
   }
   // ----------------------------------------------------------------------
   const reading::DoubleReading& 
   Ws08TemperatureSensor::
   temperature_reading( void ) 
      const throw()
   {
      assert( temperature_reading_.is_not_null() );
      return *temperature_reading_;
   }
   // ----------------------------------------------------------------------
   void
   Ws08TemperatureSensor::
   set_node( shawn::Node& node ) 
      throw()
   {
      assert( initialized_ );
      node_ = &node;
      
      if ( sensor_malfunction_ )
         shawn::write_tag<std::string>( node, "real_outlier", "true" );
      else
         shawn::write_tag<std::string>( node, "real_outlier", "false" );
   }
   // ----------------------------------------------------------------------
   shawn::Node& 
   Ws08TemperatureSensor::
   node_w( void ) 
      throw()
   {
      assert( node_ );
      return *node_;
   }
   // ----------------------------------------------------------------------
   const shawn::Node& 
   Ws08TemperatureSensor::
   node( void ) 
      const throw()
   {
      assert( node_ );
      return *node_;
   }

}

#endif
