/************************************************************************
 ** This file is part of the network simulator Shawn.                  **
 ** Copyright (C) 2004-2007 by the SwarmNet (www.swarmnet.de) project  **
 ** Shawn is free software; you can redistribute it and/or modify it   **
 ** under the terms of the BSD License. Refer to the shawn-licence.txt **
 ** file in the root of the Shawn source tree for further details.     **
 ************************************************************************/
#include "_legacyapps_enable_cmake.h"
#ifdef ENABLE_WS08

#include "legacyapps/ws08/ws08_processor_factory.h"
#include "legacyapps/ws08/ws08_processor.h"
#include "sys/processors/processor_keeper.h"
#include "sys/simulation/simulation_controller.h"
#include <iostream>

using namespace std;
using namespace shawn;

namespace ws08
{

   // ----------------------------------------------------------------------
   void
   Ws08ProcessorFactory::
   register_factory( SimulationController& sc )
   throw()
   {
      sc.processor_keeper_w().add( new Ws08ProcessorFactory );
   }
   // ----------------------------------------------------------------------
   Ws08ProcessorFactory::
   Ws08ProcessorFactory()
   {
      //cout << "HelloworldProcessorFactory ctor" << &auto_reg_ << endl;
   }
   // ----------------------------------------------------------------------
   Ws08ProcessorFactory::
   ~Ws08ProcessorFactory()
   {
      //cout << "HelloworldProcessorFactory dtor" << endl;
   }
   // ----------------------------------------------------------------------
   std::string
   Ws08ProcessorFactory::
   name( void )
   const throw()
   {
      return "ws08";
   }
   // ----------------------------------------------------------------------
   std::string
   Ws08ProcessorFactory::
   description( void )
   const throw()
   {
      return "Shawn Winterschool 08 Example Processor";
   }
   // ----------------------------------------------------------------------
   shawn::Processor*
   Ws08ProcessorFactory::
   create( void )
   throw()
   {
      return new Ws08Processor;
   }
}

#endif
